/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.Pairs;
import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.persist.MultiValueWrapper;
import java.util.ArrayList;
import java.util.List;

final class InPairsExpression
extends AbstractExpression {
    private final boolean not;
    private final String property0;
    private final String property1;
    private List<Pairs.Entry> entries;
    private boolean multiValueSupported;
    private final String separator;
    private final String suffix;
    private List<Object> concatBindValues;

    InPairsExpression(Pairs pairs, boolean not) {
        super(pairs.property0());
        this.property0 = pairs.property0();
        this.property1 = pairs.property1();
        this.entries = pairs.entries();
        this.not = not;
        this.separator = pairs.concatSeparator();
        this.suffix = pairs.concatSuffix();
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        if (this.not) {
            return false;
        }
        List<Pairs.Entry> copy = data.matchInPairs(this.property0, this.property1, this.entries);
        if (copy == null) {
            return false;
        }
        this.entries = copy;
        return true;
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        this.multiValueSupported = request.isMultiValueSupported(String.class);
    }

    @Override
    public void writeDocQuery(DocQueryContext context) {
        throw new RuntimeException("Not supported with document query");
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        this.concatBindValues = new ArrayList<Object>(this.entries.size());
        for (Pairs.Entry entry : this.entries) {
            this.concatBindValues.add(this.concat(entry.getA(), entry.getB()));
        }
        request.addBindValue(new MultiValueWrapper(this.concatBindValues, String.class));
    }

    private String concat(Object key, Object value) {
        StringBuilder sb = new StringBuilder(30);
        sb.append(key);
        sb.append(this.separator);
        sb.append(value);
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
        return sb.toString();
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.entries.isEmpty()) {
            request.append(this.not ? "1=1" : "1=0");
            return;
        }
        request.parse(request.platformHandler().concat(this.property0, this.separator, this.property1, this.suffix));
        request.appendInExpression(this.not, this.concatBindValues);
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        if (this.not) {
            builder.append("NotInPairs[");
        } else {
            builder.append("InPairs[");
        }
        builder.append(this.property0).append("-");
        builder.append(this.property1).append("-");
        builder.append(this.separator).append("-");
        builder.append(this.suffix).append(" ?");
        if (!this.multiValueSupported || this.entries.isEmpty()) {
            builder.append(this.entries.size());
        }
        builder.append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.entries.size());
        for (Pairs.Entry entry : this.entries) {
            key.add(entry.getA()).add(entry.getB());
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        InPairsExpression that = (InPairsExpression)other;
        return this.entries.size() == that.entries.size() && this.entries.equals(that.entries);
    }
}

