/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.loadcontext;

import io.ebean.bean.ObjectGraphNode;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.loadcontext.DLoadContext;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.util.concurrent.locks.ReentrantLock;

abstract class DLoadBaseContext {
    protected final ReentrantLock lock = new ReentrantLock();
    protected final DLoadContext parent;
    protected final BeanDescriptor<?> desc;
    protected final String fullPath;
    protected final String serverName;
    final OrmQueryProperties queryProps;
    final boolean hitCache;
    final int batchSize;
    final ObjectGraphNode objectGraphNode;
    final boolean queryFetch;

    DLoadBaseContext(DLoadContext parent, BeanDescriptor<?> desc, String path, OrmQueryProperties queryProps) {
        this.parent = parent;
        this.serverName = parent.server().name();
        this.desc = desc;
        this.queryProps = queryProps;
        this.fullPath = parent.fullPath(path);
        this.hitCache = parent.isBeanCacheGet() && desc.isBeanCaching();
        this.objectGraphNode = parent.objectGraphNode(path);
        this.queryFetch = queryProps != null && queryProps.isQueryFetch();
        this.batchSize = parent.batchSize(queryProps);
    }

    void setLabel(SpiQuery<?> query) {
        String label = this.parent.planLabel();
        if (label != null) {
            query.setProfilePath(label, this.fullPath + "(" + query.loadMode() + ")", this.parent.profileLocation());
        }
    }

    PersistenceContext persistenceContext() {
        return this.parent.persistenceContext();
    }
}

