/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.persist.DefaultPersister;
import io.ebeaninternal.server.persist.SaveMany;
import java.io.IOException;

abstract class SaveManyBase
implements SaveMany {
    final DefaultPersister persister;
    final PersistRequestBean<?> request;
    final SpiEbeanServer server;
    final boolean insertedParent;
    final BeanPropertyAssocMany<?> many;
    final SpiTransaction transaction;
    final EntityBean parentBean;
    final Object value;

    SaveManyBase(DefaultPersister persister, boolean insertedParent, BeanPropertyAssocMany<?> many, EntityBean parentBean, PersistRequestBean<?> request) {
        this.persister = persister;
        this.request = request;
        this.server = request.server();
        this.many = many;
        this.parentBean = parentBean;
        this.transaction = request.transaction();
        this.value = many.getValue(parentBean);
        this.insertedParent = insertedParent;
        if (!insertedParent) {
            request.setUpdatedMany();
        }
    }

    abstract void save();

    final void preElementCollectionUpdate() {
        if (!this.insertedParent) {
            this.request.preElementCollectionUpdate();
            this.persister.addToFlushQueue(this.many.deleteByParentId(this.request.beanId(), null), this.transaction, 0);
        }
    }

    final void resetModifyState() {
        if (this.value instanceof BeanCollection) {
            this.modifyListenReset((BeanCollection)this.value);
        }
    }

    final void modifyListenReset(BeanCollection<?> c) {
        if (this.insertedParent) {
            c.setModifyListening(this.many.modifyListenMode());
        }
        c.modifyReset();
    }

    final void postElementCollectionUpdate() {
        if (!this.insertedParent && this.request.isNotifyCache()) {
            try {
                String asJson = this.many.jsonWriteCollection(this.value);
                this.request.addCollectionChange(this.many.name(), asJson);
            }
            catch (IOException e) {
                CoreLog.log.log(System.Logger.Level.ERROR, "Error build element collection entry for L2 cache", (Throwable)e);
            }
        }
    }
}

