/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dmlbind;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableId;
import io.ebeaninternal.server.persist.dmlbind.BindableRequest;
import io.ebeaninternal.server.persist.dmlbind.MatchedImportedProperty;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.persistence.PersistenceException;

final class BindableIdEmbedded
implements BindableId {
    private final BeanPropertyAssocOne<?> embId;
    private final BeanProperty[] props;
    private final MatchedImportedProperty[] matches;

    BindableIdEmbedded(BeanPropertyAssocOne<?> embId, MatchedImportedProperty[] matches) {
        this.embId = embId;
        this.props = embId.properties();
        this.matches = matches;
    }

    @Override
    public boolean isDraftOnly() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isConcatenated() {
        return true;
    }

    @Override
    public String getIdentityColumn() {
        return null;
    }

    public String toString() {
        return String.valueOf(this.embId) + " props:" + Arrays.toString(this.props);
    }

    @Override
    public void addToUpdate(PersistRequestBean<?> request, List<Bindable> list) {
    }

    @Override
    public void dmlBind(BindableRequest request, EntityBean bean) throws SQLException {
        EntityBean idValue = (EntityBean)this.embId.getValue(bean);
        for (BeanProperty prop : this.props) {
            Object value = prop.getValue(idValue);
            request.bind(value, prop);
        }
        request.setIdValue(idValue);
    }

    @Override
    public void dmlAppend(GenerateDmlRequest request) {
        for (BeanProperty prop : this.props) {
            request.appendColumn(prop.dbColumn());
        }
    }

    @Override
    public boolean deriveConcatenatedId(PersistRequestBean<?> persist) {
        if (this.matches == null) {
            String m = "No matches for " + this.embId.fullName() + " the concatenated key columns where not found? I expect that the concatenated key was null, and this bean does not have ManyToOne assoc beans matching the primary key columns?";
            throw new PersistenceException(m);
        }
        EntityBean bean = persist.entityBean();
        EntityBean newId = (EntityBean)this.embId.createEmbeddedId();
        for (MatchedImportedProperty match : this.matches) {
            match.populate(bean, newId);
        }
        this.embId.setValueIntercept(bean, newId);
        return true;
    }
}

