/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebeaninternal.api.SpiDbQueryPlan;
import io.ebeaninternal.api.SpiQueryBindCapture;
import io.ebeaninternal.api.SpiQueryPlan;
import io.ebeaninternal.server.bind.capture.BindCapture;
import io.ebeaninternal.server.query.CQueryPlanManager;
import io.ebeaninternal.server.query.CQueryPlanRequest;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

final class CQueryBindCapture
implements SpiQueryBindCapture {
    private static final double multiplier = 1.5;
    private final ReentrantLock lock = new ReentrantLock();
    private final CQueryPlanManager manager;
    private final SpiQueryPlan queryPlan;
    private BindCapture bindCapture;
    private long queryTimeMicros;
    private long thresholdMicros;
    private long captureCount;
    private long lastBindCapture;

    CQueryBindCapture(CQueryPlanManager manager, SpiQueryPlan queryPlan, long thresholdMicros) {
        this.manager = manager;
        this.queryPlan = queryPlan;
        this.thresholdMicros = thresholdMicros;
    }

    @Override
    public boolean collectFor(long timeMicros) {
        return timeMicros > this.thresholdMicros && this.captureCount < 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBind(BindCapture bindCapture, long queryTimeMicros, long startNanos) {
        this.lock.lock();
        try {
            this.thresholdMicros = Math.round((double)queryTimeMicros * 1.5);
            ++this.captureCount;
            this.bindCapture = bindCapture;
            this.queryTimeMicros = queryTimeMicros;
            this.lastBindCapture = System.currentTimeMillis();
            this.manager.notifyBindCapture(this, startNanos);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void queryPlanInit(long thresholdMicros) {
        this.lock.lock();
        try {
            this.thresholdMicros = thresholdMicros;
            this.captureCount = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean collectQueryPlan(CQueryPlanRequest request) {
        if (this.bindCapture == null || request.since() < this.lastBindCapture) {
            return false;
        }
        Instant whenCaptured = Instant.ofEpochMilli(this.lastBindCapture);
        BindCapture last = this.bindCapture;
        long startNanos = System.nanoTime();
        SpiDbQueryPlan queryPlan = this.manager.collectPlan(request.connection(), this.queryPlan, last);
        if (queryPlan != null) {
            long captureMicros = TimeUnit.MICROSECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
            request.add(queryPlan.with(this.queryTimeMicros, this.captureCount, captureMicros, whenCaptured));
            this.thresholdMicros = Long.MAX_VALUE;
            return true;
        }
        return false;
    }
}

