/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.CancelableQuery;
import io.ebean.CountedValue;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarDataReader;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.type.RsetDataReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

final class CQueryFetchSingleAttribute
implements SpiProfileTransactionEvent,
CancelableQuery {
    private final CQueryPlan queryPlan;
    private final OrmQueryRequest<?> request;
    private final BeanDescriptor<?> desc;
    private final SpiQuery<?> query;
    private final CQueryPredicates predicates;
    private final String sql;
    private RsetDataReader dataReader;
    private PreparedStatement pstmt;
    private String bindLog;
    private long executionTimeMicros;
    private int rowCount;
    private final ScalarDataReader<?> reader;
    private final boolean containsCounts;
    private long profileOffset;
    private final ReentrantLock lock = new ReentrantLock();

    CQueryFetchSingleAttribute(OrmQueryRequest<?> request, CQueryPredicates predicates, CQueryPlan queryPlan, boolean containsCounts) {
        this.request = request;
        this.queryPlan = queryPlan;
        this.query = request.query();
        this.sql = queryPlan.sql();
        this.desc = request.descriptor();
        this.predicates = predicates;
        this.containsCounts = containsCounts;
        this.reader = queryPlan.singleAttributeScalarType();
        this.query.setGeneratedSql(this.sql);
    }

    String summary() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("FindAttr exeMicros[").append(this.executionTimeMicros).append("] rows[").append(this.rowCount).append("] type[").append(this.desc.name()).append("] predicates[").append(this.predicates.logWhereSql()).append("] bind[").append(this.bindLog).append("]");
        return sb.toString();
    }

    long micros() {
        return this.executionTimeMicros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findCollection(Collection result) throws SQLException {
        long startNano = System.nanoTime();
        try {
            this.prepareExecute();
            while (this.dataReader.next()) {
                Object value = this.reader.read((DataReader)this.dataReader);
                if (this.containsCounts) {
                    value = new CountedValue(value, this.dataReader.getLong().longValue());
                }
                result.add(value);
                ++this.rowCount;
            }
            this.executionTimeMicros = (System.nanoTime() - startNano) / 1000L;
            this.request.slowQueryCheck(this.executionTimeMicros, this.rowCount);
            if (this.queryPlan.executionTime(this.executionTimeMicros)) {
                this.queryPlan.captureBindForQueryPlan(this.predicates, this.executionTimeMicros);
            }
            this.transaction().profileEvent(this);
        }
        finally {
            this.close();
        }
    }

    private SpiTransaction transaction() {
        return this.request.transaction();
    }

    String bindLog() {
        return this.bindLog;
    }

    String generatedSql() {
        return this.sql;
    }

    private void prepareExecute() throws SQLException {
        this.lock.lock();
        try {
            this.query.checkCancelled();
            SpiTransaction t = this.transaction();
            this.profileOffset = t.profileOffset();
            Connection conn = t.internalConnection();
            this.pstmt = conn.prepareStatement(this.sql);
            if (this.query.bufferFetchSizeHint() > 0) {
                this.pstmt.setFetchSize(this.query.bufferFetchSizeHint());
            }
            if (this.query.timeout() > 0) {
                this.pstmt.setQueryTimeout(this.query.timeout());
            }
            this.bindLog = this.predicates.bind(this.pstmt, conn);
        }
        finally {
            this.lock.unlock();
        }
        this.dataReader = new RsetDataReader(this.request.dataTimeZone(), this.pstmt.executeQuery());
        this.query.checkCancelled();
    }

    private void close() {
        try {
            if (this.dataReader != null) {
                this.dataReader.close();
                this.dataReader = null;
            }
        }
        catch (SQLException e) {
            CoreLog.log.log(System.Logger.Level.ERROR, "Error closing DataReader", (Throwable)e);
        }
        JdbcClose.close((Statement)this.pstmt);
        this.pstmt = null;
    }

    @Override
    public void profile() {
        this.transaction().profileStream().addQueryEvent(this.query.profileEventId(), this.profileOffset, this.desc.name(), this.rowCount, this.query.profileId());
    }

    Set<String> dependentTables() {
        return this.queryPlan.dependentTables();
    }

    public void cancel() {
        this.lock.lock();
        try {
            JdbcClose.cancel((Statement)this.pstmt);
        }
        finally {
            this.lock.unlock();
        }
    }
}

