/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.CancelableQuery;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.CQueryPredicates;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.PersistenceException;

final class CQueryRowCount
implements SpiProfileTransactionEvent,
CancelableQuery {
    private final CQueryPlan queryPlan;
    private final OrmQueryRequest<?> request;
    private final BeanDescriptor<?> desc;
    private final SpiQuery<?> query;
    private final CQueryPredicates predicates;
    private final String sql;
    private ResultSet rset;
    private PreparedStatement pstmt;
    private String bindLog;
    private long executionTimeMicros;
    private int rowCount;
    private long profileOffset;
    private final ReentrantLock lock = new ReentrantLock();

    CQueryRowCount(CQueryPlan queryPlan, OrmQueryRequest<?> request, CQueryPredicates predicates) {
        this.queryPlan = queryPlan;
        this.request = request;
        this.query = request.query();
        this.sql = queryPlan.sql();
        this.desc = request.descriptor();
        this.predicates = predicates;
        this.query.setGeneratedSql(this.sql);
    }

    public String summary() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("FindCount exeMicros[").append(this.executionTimeMicros).append("] rows[").append(this.rowCount).append("] type[").append(this.desc.fullName()).append("] predicates[").append(this.predicates.logWhereSql()).append("] bind[").append(this.bindLog).append("]");
        return sb.toString();
    }

    public String bindLog() {
        return this.bindLog;
    }

    public String generatedSql() {
        return this.sql;
    }

    long micros() {
        return this.executionTimeMicros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findCount() throws SQLException {
        long startNano = System.nanoTime();
        try {
            SpiTransaction t = this.transaction();
            this.profileOffset = t.profileOffset();
            Connection conn = t.internalConnection();
            this.lock.lock();
            try {
                this.query.checkCancelled();
                this.pstmt = conn.prepareStatement(this.sql);
                if (this.query.timeout() > 0) {
                    this.pstmt.setQueryTimeout(this.query.timeout());
                }
                this.bindLog = this.predicates.bind(this.pstmt, conn);
            }
            finally {
                this.lock.unlock();
            }
            this.rset = this.pstmt.executeQuery();
            this.query.checkCancelled();
            if (!this.rset.next()) {
                throw new PersistenceException("Expecting 1 row but got none?");
            }
            this.rowCount = this.rset.getInt(1);
            this.executionTimeMicros = (System.nanoTime() - startNano) / 1000L;
            this.request.slowQueryCheck(this.executionTimeMicros, this.rowCount);
            if (this.queryPlan.executionTime(this.executionTimeMicros)) {
                this.queryPlan.captureBindForQueryPlan(this.predicates, this.executionTimeMicros);
            }
            t.profileEvent(this);
            int n = this.rowCount;
            return n;
        }
        finally {
            this.close();
        }
    }

    private SpiTransaction transaction() {
        return this.request.transaction();
    }

    private void close() {
        JdbcClose.close((ResultSet)this.rset);
        JdbcClose.close((Statement)this.pstmt);
        this.rset = null;
        this.pstmt = null;
    }

    @Override
    public void profile() {
        this.transaction().profileStream().addQueryEvent(this.query.profileEventId(), this.profileOffset, this.desc.name(), this.rowCount, this.query.profileId());
    }

    Set<String> dependentTables() {
        return this.queryPlan.dependentTables();
    }

    public void cancel() {
        this.lock.lock();
        try {
            JdbcClose.cancel((Statement)this.pstmt);
        }
        finally {
            this.lock.unlock();
        }
    }
}

