/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebeaninternal.api.BinaryReadContext;
import io.ebeaninternal.api.BinaryWritable;
import io.ebeaninternal.api.BinaryWriteContext;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.id.IdBinder;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class BeanPersistIds
implements BinaryWritable {
    private final BeanDescriptor<?> beanDescriptor;
    private final String descriptorId;
    private List<Object> ids;

    public BeanPersistIds(BeanDescriptor<?> desc) {
        this.beanDescriptor = desc;
        this.descriptorId = desc.descriptorId();
    }

    public static BeanPersistIds readBinaryMessage(SpiEbeanServer server, BinaryReadContext input) throws IOException {
        BeanDescriptor<?> desc = server.descriptorById(input.readUTF());
        BeanPersistIds bp = new BeanPersistIds(desc);
        bp.read(input);
        return bp;
    }

    private void read(BinaryReadContext dataInput) throws IOException {
        dataInput.readInt();
        this.ids = this.readIdList(dataInput.in(), this.beanDescriptor.idBinder());
    }

    @Override
    public void writeBinary(BinaryWriteContext out) throws IOException {
        DataOutputStream os = out.start(1);
        os.writeUTF(this.descriptorId);
        os.writeInt(1);
        if (this.ids == null) {
            os.writeInt(0);
        } else {
            os.writeInt(this.ids.size());
            IdBinder idBinder = this.beanDescriptor.idBinder();
            for (Object idValue : this.ids) {
                idBinder.writeData(os, idValue);
            }
        }
    }

    private List<Object> readIdList(DataInput dataInput, IdBinder idBinder) throws IOException {
        int count = dataInput.readInt();
        if (count < 1) {
            return null;
        }
        ArrayList<Object> idList = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            idList.add(idBinder.readData(dataInput));
        }
        return idList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanIds[");
        if (this.beanDescriptor != null) {
            sb.append(this.beanDescriptor.fullName());
        } else {
            sb.append("descId:").append(this.descriptorId);
        }
        if (this.ids != null) {
            sb.append(" ids:").append(this.ids);
        }
        sb.append("]");
        return sb.toString();
    }

    public void addId(PersistRequest.Type type, Object id) {
        if (type != PersistRequest.Type.INSERT) {
            if (this.ids == null) {
                this.ids = new ArrayList<Object>();
            }
            this.ids.add(id);
        }
    }

    public BeanDescriptor<?> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public List<Object> getIds() {
        return this.ids;
    }

    public void notifyCache(CacheChangeSet changeSet) {
        changeSet.addClearQuery(this.beanDescriptor);
        if (this.ids != null) {
            changeSet.addBeanRemoveMany(this.beanDescriptor, this.ids);
        }
    }
}

