/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.config.ExternalTransactionManager;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.JtaTransaction;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeaninternal.server.transaction.TransactionScopeManager;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;

public final class JtaTransactionManager
implements ExternalTransactionManager {
    private static final System.Logger log = CoreLog.internal;
    private static final String EBEAN_TXN_RESOURCE = "EBEAN_TXN_RESOURCE";
    private TransactionManager transactionManager;
    private TransactionScopeManager scope;

    public void setTransactionManager(Object txnMgr) {
        this.transactionManager = (TransactionManager)txnMgr;
        this.scope = this.transactionManager.scope();
    }

    private DataSource dataSource() {
        return this.transactionManager.dataSource();
    }

    private TransactionSynchronizationRegistry registry() {
        try {
            InitialContext ctx = new InitialContext();
            return (TransactionSynchronizationRegistry)ctx.lookup("java:comp/TransactionSynchronizationRegistry");
        }
        catch (NamingException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private UserTransaction userTransaction() {
        try {
            InitialContext ctx = new InitialContext();
            return (UserTransaction)ctx.lookup("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            return new DummyUserTransaction();
        }
    }

    public Object getCurrentTransaction() {
        TransactionSynchronizationRegistry syncRegistry = this.registry();
        try {
            SpiTransaction t = (SpiTransaction)syncRegistry.getResource((Object)EBEAN_TXN_RESOURCE);
            if (t != null) {
                return t;
            }
        }
        catch (Exception e) {
            return null;
        }
        SpiTransaction currentEbeanTransaction = this.scope.inScope();
        if (currentEbeanTransaction != null) {
            log.log(System.Logger.Level.WARNING, "JTA Transaction - no current txn BUT using current Ebean one {0}", currentEbeanTransaction.id());
            return currentEbeanTransaction;
        }
        UserTransaction ut = this.userTransaction();
        if (ut == null) {
            if (log.isLoggable(System.Logger.Level.DEBUG)) {
                log.log(System.Logger.Level.DEBUG, "JTA Transaction - no current txn");
            }
            return null;
        }
        JtaTransaction newTrans = new JtaTransaction(true, ut, this.dataSource(), this.transactionManager);
        JtaTxnListener txnListener = this.createJtaTxnListener(newTrans);
        syncRegistry.putResource((Object)EBEAN_TXN_RESOURCE, (Object)newTrans);
        syncRegistry.registerInterposedSynchronization((Synchronization)txnListener);
        this.scope.set(newTrans);
        return newTrans;
    }

    private JtaTxnListener createJtaTxnListener(SpiTransaction t) {
        return new JtaTxnListener(this.transactionManager, t);
    }

    private static class DummyUserTransaction
    implements UserTransaction {
        private DummyUserTransaction() {
        }

        public void begin() {
        }

        public void commit() throws SecurityException, IllegalStateException {
        }

        public int getStatus() {
            return 0;
        }

        public void rollback() throws IllegalStateException, SecurityException {
        }

        public void setRollbackOnly() throws IllegalStateException {
        }

        public void setTransactionTimeout(int seconds) {
        }
    }

    private static class JtaTxnListener
    implements Synchronization {
        private final TransactionManager transactionManager;
        private final SpiTransaction transaction;

        private JtaTxnListener(TransactionManager transactionManager, SpiTransaction t) {
            this.transactionManager = transactionManager;
            this.transaction = t;
        }

        public void beforeCompletion() {
            this.transaction.preCommit();
        }

        public void afterCompletion(int status) {
            switch (status) {
                case 3: {
                    log.log(System.Logger.Level.DEBUG, "Jta Txn [{0}] committed", this.transaction.id());
                    this.transaction.postCommit();
                    this.transactionManager.scope().clearExternal();
                    break;
                }
                case 4: {
                    log.log(System.Logger.Level.DEBUG, "Jta Txn [{0}] rollback", this.transaction.id());
                    this.transaction.postRollback(null);
                    this.transactionManager.scope().clearExternal();
                    break;
                }
                default: {
                    log.log(System.Logger.Level.DEBUG, "Jta Txn [{0}] status:{1}", this.transaction.id(), status);
                }
            }
            JdbcClose.close((Connection)this.transaction.internalConnection());
        }
    }
}

