/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.changelog;

import io.avaje.applog.AppLog;
import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeLogListener;
import io.ebean.event.changelog.ChangeSet;
import io.ebean.event.changelog.ChangeType;
import io.ebean.plugin.Plugin;
import io.ebean.plugin.SpiServer;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.changelog.ChangeJsonBuilder;
import java.io.StringWriter;
import java.util.Properties;

public final class DefaultChangeLogListener
implements ChangeLogListener,
Plugin {
    private static final System.Logger changeLog = AppLog.getLogger((String)"io.ebean.ChangeLog");
    private ChangeJsonBuilder jsonBuilder;
    private int defaultBufferSize = 400;

    public void configure(SpiServer server) {
        String bufferSize;
        this.jsonBuilder = new ChangeJsonBuilder();
        Properties properties = server.config().getProperties();
        if (properties != null && (bufferSize = properties.getProperty("ebean.changeLog.bufferSize")) != null) {
            this.defaultBufferSize = Integer.parseInt(bufferSize);
        }
    }

    public void online(boolean online) {
    }

    public void shutdown() {
    }

    public void log(ChangeSet changeSet) {
        for (BeanChange beanChange : changeSet.getChanges()) {
            try {
                StringWriter writer = new StringWriter(this.getBufferSize(beanChange));
                this.jsonBuilder.writeBeanJson(writer, beanChange, changeSet);
                changeLog.log(System.Logger.Level.INFO, writer.toString());
            }
            catch (Exception e) {
                CoreLog.log.log(System.Logger.Level.ERROR, "Exception logging beanChange " + beanChange, (Throwable)e);
            }
        }
    }

    private int getBufferSize(BeanChange beanChange) {
        return ChangeType.DELETE == beanChange.getEvent() ? 250 : this.defaultBufferSize;
    }
}

