/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.ebean.bean.EntityBean;
import io.ebean.text.json.EJson;
import io.ebeaninternal.api.json.SpiJsonReader;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.persist.DmlUtil;
import java.io.IOException;
import java.util.LinkedHashMap;

final class BeanDescriptorJsonHelp<T> {
    private final BeanDescriptor<T> desc;
    private final InheritInfo inheritInfo;

    BeanDescriptorJsonHelp(BeanDescriptor<T> desc) {
        this.desc = desc;
        this.inheritInfo = desc.inheritInfo;
    }

    void jsonWrite(SpiJsonWriter writeJson, EntityBean bean, String key) throws IOException {
        writeJson.writeStartObject(key);
        if (this.inheritInfo == null) {
            this.jsonWriteProperties(writeJson, bean);
        } else {
            InheritInfo localInheritInfo = this.inheritInfo.readType(bean.getClass());
            String discValue = localInheritInfo.getDiscriminatorStringValue();
            String discColumn = localInheritInfo.getDiscriminatorColumn();
            writeJson.gen().writeStringField(discColumn, discValue);
            localInheritInfo.desc().jsonWriteProperties(writeJson, bean);
        }
        writeJson.writeEndObject();
    }

    void jsonWriteProperties(SpiJsonWriter writeJson, EntityBean bean) {
        writeJson.writeBean(this.desc, bean);
    }

    void jsonWriteDirty(SpiJsonWriter writeJson, EntityBean bean, boolean[] dirtyProps) throws IOException {
        if (this.inheritInfo == null) {
            this.jsonWriteDirtyProperties(writeJson, bean, dirtyProps);
        } else {
            this.desc.descOf(bean.getClass()).jsonWriteDirtyProperties(writeJson, bean, dirtyProps);
        }
    }

    void jsonWriteDirtyProperties(SpiJsonWriter writeJson, EntityBean bean, boolean[] dirtyProps) throws IOException {
        BeanProperty[] props;
        writeJson.writeStartObject(null);
        for (BeanProperty prop : props = this.desc.propertiesNonTransient()) {
            if (!dirtyProps[prop.propertyIndex()]) continue;
            prop.jsonWrite(writeJson, bean);
        }
        writeJson.writeEndObject();
    }

    T jsonRead(SpiJsonReader jsonRead, String path, boolean withInheritance, T target) throws IOException {
        JsonParser parser = jsonRead.getParser();
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            JsonToken token = parser.nextToken();
            if (JsonToken.VALUE_NULL == token || JsonToken.END_ARRAY == token) {
                return null;
            }
            if (JsonToken.START_OBJECT != token) {
                throw new JsonParseException(parser, "Unexpected token " + token + " - expecting start_object", parser.getCurrentLocation());
            }
        }
        if (this.desc.inheritInfo == null || !withInheritance) {
            return this.jsonReadObject(jsonRead, path, target);
        }
        ObjectNode node = (ObjectNode)jsonRead.getObjectMapper().readTree(parser);
        if (node.isNull()) {
            return null;
        }
        JsonParser newParser = node.traverse();
        SpiJsonReader newReader = jsonRead.forJson(newParser);
        String discColumn = this.inheritInfo.getRoot().getDiscriminatorColumn();
        JsonNode discNode = node.get(discColumn);
        if (discNode == null || discNode.isNull()) {
            if (!this.desc.isAbstractType()) {
                return this.desc.jsonReadObject(newReader, path, target);
            }
            String msg = "Error reading inheritance discriminator - expected [" + discColumn + "] but no json key?";
            throw new JsonParseException(newParser, msg, parser.getCurrentLocation());
        }
        BeanDescriptor<?> inheritDesc = this.inheritInfo.readType(discNode.asText()).desc();
        return (T)inheritDesc.jsonReadObject(newReader, path, target);
    }

    private T jsonReadObject(SpiJsonReader readJson, String path, T target) throws IOException {
        EntityBean bean;
        if (target == null) {
            bean = this.desc.createEntityBeanForJson();
        } else if (this.desc.beanType.isInstance(target)) {
            bean = (EntityBean)target;
        } else {
            throw new ClassCastException(target.getClass().getName() + " provided, but " + this.desc.beanType.getClass().getName() + " expected");
        }
        return this.jsonReadProperties(readJson, bean, path);
    }

    private T jsonReadProperties(SpiJsonReader readJson, EntityBean bean, String path) throws IOException {
        JsonParser parser;
        JsonToken event;
        if (path != null) {
            readJson.pushPath(path);
        }
        LinkedHashMap<String, Object> unmappedProperties = null;
        while (JsonToken.FIELD_NAME == (event = (parser = readJson.getParser()).nextToken())) {
            String key = parser.getCurrentName();
            BeanProperty p = this.desc.beanProperty(key);
            if (p != null) {
                p.jsonRead(readJson, bean);
                continue;
            }
            if (unmappedProperties == null) {
                unmappedProperties = new LinkedHashMap<String, Object>();
            }
            unmappedProperties.put(key, EJson.parse((JsonParser)parser));
        }
        if (JsonToken.END_OBJECT != event) {
            throw new RuntimeException("Unexpected token " + event + " - expecting key or end_object at: " + parser.getCurrentLocation());
        }
        if (unmappedProperties != null) {
            this.desc.setUnmappedJson(bean, unmappedProperties);
        }
        Object contextBean = null;
        Object id = this.desc.id(bean);
        if (!DmlUtil.isNullOrZero(id)) {
            contextBean = readJson.persistenceContextPutIfAbsent(id, bean, this.desc);
        }
        if (contextBean == null) {
            readJson.beanVisitor(bean, unmappedProperties);
            if (!DmlUtil.isNullOrZero(id)) {
                this.desc.setReferenceIfIdOnly(bean._ebean_getIntercept());
            }
        }
        if (path != null) {
            readJson.popPath();
        }
        return (T)(contextBean == null ? bean : contextBean);
    }
}

