/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.idgen;

import io.avaje.applog.AppLog;
import io.ebean.Transaction;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class UuidV1RndIdGenerator
implements PlatformIdGenerator {
    protected static final System.Logger log = AppLog.getLogger((String)"io.ebean.IDGEN");
    protected static final long UUID_EPOCH_OFFSET = 122192928000000000L;
    protected static final long MILLIS_TO_UUID = 10000L;
    public static final UuidV1RndIdGenerator INSTANCE = new UuidV1RndIdGenerator();
    protected final AtomicInteger clockSeq = new AtomicInteger((int)(Math.random() * 16383.0));
    private final SecureRandom numberGenerator = new SecureRandom();
    protected AtomicLong timeStamp = new AtomicLong(UuidV1RndIdGenerator.currentUuidTime());
    private AtomicLong nanoToMilliOffset = new AtomicLong(UuidV1RndIdGenerator.currentUuidTime());
    private final ReentrantLock lock = new ReentrantLock();

    private static long currentUuidTime() {
        return System.currentTimeMillis() * 10000L + 122192928000000000L;
    }

    public UuidV1RndIdGenerator() {
        this.computeNanoOffset();
    }

    protected void computeNanoOffset() {
        long fromNanos;
        long currentTime = UuidV1RndIdGenerator.currentUuidTime();
        long offset = currentTime - (fromNanos = System.nanoTime() / 100L + this.nanoToMilliOffset.get());
        if (Math.abs(offset) > 10000000L) {
            this.nanoToMilliOffset.addAndGet(offset);
        }
    }

    protected void saveState() {
    }

    protected byte[] getNodeIdBytes() {
        byte[] idBytes = new byte[6];
        this.numberGenerator.nextBytes(idBytes);
        idBytes[0] = (byte)(idBytes[0] | 1);
        return idBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID nextId(Transaction t) {
        long delta;
        int seq;
        long current = System.nanoTime() / 100L + this.nanoToMilliOffset.get();
        block3: do {
            long last;
            seq = this.clockSeq.get();
            while (true) {
                if ((delta = current - (last = this.timeStamp.get())) < -200000000L) {
                    log.log(System.Logger.Level.INFO, "Clock skew of {} ms detected", delta / -10000L);
                    this.lock.lock();
                    try {
                        if (!this.clockSeq.compareAndSet(seq, seq + 1)) continue;
                        this.timeStamp.set(current);
                        this.saveState();
                        this.computeNanoOffset();
                    }
                    finally {
                        this.lock.unlock();
                        continue;
                    }
                }
                if (delta > 0L && this.timeStamp.compareAndSet(last, current)) continue block3;
                if (this.timeStamp.compareAndSet(last, last + 1L)) break;
            }
            current = last + 1L;
        } while (seq != this.clockSeq.get());
        if (delta > 600000000L) {
            this.saveState();
            this.computeNanoOffset();
        }
        long msb = current << 32;
        msb |= (current & 0xFFFF00000000L) >> 16;
        msb |= 0x1000L | current >> 48 & 0xFFFL;
        byte[] idBytes = this.getNodeIdBytes();
        long lsb = 0L;
        for (int i = 0; i < 6; ++i) {
            lsb = lsb << 8 | (long)(idBytes[i] & 0xFF);
        }
        seq = seq & 0x3FFF | 0x8000;
        return new UUID(msb, lsb |= (long)seq << 48);
    }

    public String getName() {
        return "uuid";
    }

    public boolean isDbSequence() {
        return false;
    }

    public void preAllocateIds(int allocateSize) {
    }
}

