/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.avaje.lang.NonNullApi;
import io.ebean.CacheMode;
import io.ebean.CountDistinctOrder;
import io.ebean.Database;
import io.ebean.DtoQuery;
import io.ebean.Expression;
import io.ebean.ExpressionFactory;
import io.ebean.ExpressionList;
import io.ebean.FetchConfig;
import io.ebean.FetchGroup;
import io.ebean.FetchPath;
import io.ebean.FutureIds;
import io.ebean.FutureList;
import io.ebean.FutureRowCount;
import io.ebean.OrderBy;
import io.ebean.PagedList;
import io.ebean.PersistenceContextScope;
import io.ebean.ProfileLocation;
import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.QueryType;
import io.ebean.RawSql;
import io.ebean.Transaction;
import io.ebean.UpdateQuery;
import io.ebean.Version;
import io.ebean.bean.CallOrigin;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.bean.ObjectGraphOrigin;
import io.ebean.bean.PersistenceContext;
import io.ebean.event.BeanQueryRequest;
import io.ebean.event.readaudit.ReadEvent;
import io.ebean.plugin.BeanType;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.CQueryPlanKey;
import io.ebeaninternal.api.CacheIdLookup;
import io.ebeaninternal.api.CacheIdLookupMany;
import io.ebeaninternal.api.CacheIdLookupSingle;
import io.ebeaninternal.api.HashQuery;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionList;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.api.SpiNamedParam;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQuerySecondary;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.autotune.ProfilingListener;
import io.ebeaninternal.server.core.SpiOrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanNaturalKey;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.expression.DefaultExpressionList;
import io.ebeaninternal.server.expression.IdInExpression;
import io.ebeaninternal.server.expression.InExpression;
import io.ebeaninternal.server.expression.SimpleExpression;
import io.ebeaninternal.server.query.NativeSqlQueryPlanKey;
import io.ebeaninternal.server.querydefn.AbstractQuery;
import io.ebeaninternal.server.querydefn.DefaultUpdateQuery;
import io.ebeaninternal.server.querydefn.NaturalKeyBindParam;
import io.ebeaninternal.server.querydefn.ONamedParam;
import io.ebeaninternal.server.querydefn.OrmQueryDetail;
import io.ebeaninternal.server.querydefn.OrmQueryPlanKey;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import io.ebeaninternal.server.querydefn.OrmQuerySecondary;
import io.ebeaninternal.server.querydefn.OrmUpdateProperties;
import io.ebeaninternal.server.querydefn.SpiFetchGroup;
import io.ebeaninternal.server.rawsql.SpiRawSql;
import io.ebeaninternal.server.transaction.ExternalJdbcTransaction;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.persistence.PersistenceException;

@NonNullApi
public class DefaultOrmQuery<T>
extends AbstractQuery
implements SpiQuery<T> {
    private static final String DEFAULT_QUERY_NAME = "default";
    private static final FetchConfig FETCH_CACHE = FetchConfig.ofCache();
    private static final FetchConfig FETCH_QUERY = FetchConfig.ofQuery();
    private static final FetchConfig FETCH_LAZY = FetchConfig.ofLazy();
    private final Class<T> beanType;
    private final ExpressionFactory expressionFactory;
    private final BeanDescriptor<T> rootBeanDescriptor;
    private BeanDescriptor<T> beanDescriptor;
    private SpiEbeanServer server;
    private SpiTransaction transaction;
    private TableJoin m2mIncludeJoin;
    private ProfilingListener profilingListener;
    private SpiQuery.Type type;
    private String label;
    private SpiQuery.Mode mode = SpiQuery.Mode.NORMAL;
    private Object tenantId;
    private OrmQueryDetail detail;
    private int maxRows;
    private int firstRow;
    private boolean disableLazyLoading;
    private int lazyLoadBatchSize;
    private OrderBy<T> orderBy;
    private String loadMode;
    private String loadDescription;
    private String generatedSql;
    private String lazyLoadProperty;
    private String lazyLoadManyPath;
    private boolean allowLoadErrors;
    private boolean manualId;
    private boolean distinct;
    private boolean futureFetch;
    private ReadEvent futureFetchAudit;
    private int timeout;
    private String mapKey;
    private Object id;
    private Map<String, ONamedParam> namedParams;
    private BindParams bindParams;
    private DefaultExpressionList<T> textExpressions;
    private DefaultExpressionList<T> whereExpressions;
    private DefaultExpressionList<T> havingExpressions;
    private boolean asOfBaseTable;
    private int asOfTableCount;
    private Timestamp asOf;
    private SpiQuery.TemporalMode temporalMode = SpiQuery.TemporalMode.CURRENT;
    private Timestamp versionsStart;
    private Timestamp versionsEnd;
    private List<String> softDeletePredicates;
    private boolean disableReadAudit;
    private int bufferFetchSizeHint;
    private boolean usageProfiling = true;
    private CacheMode useBeanCache = CacheMode.AUTO;
    private CacheMode useQueryCache = CacheMode.OFF;
    private Boolean readOnly;
    private PersistenceContextScope persistenceContextScope;
    private Boolean autoTune;
    private Query.LockWait forUpdate;
    private Query.LockType lockType;
    private boolean singleAttribute;
    private CountDistinctOrder countDistinctOrder;
    private boolean autoTuned;
    private String rootTableAlias;
    private String baseTable;
    private ObjectGraphNode parentNode;
    private BeanPropertyAssocMany<?> lazyLoadForParentsProperty;
    private CQueryPlanKey queryPlanKey;
    private PersistenceContext persistenceContext;
    private ManyWhereJoins manyWhereJoins;
    private SpiRawSql rawSql;
    private boolean useDocStore;
    private String docIndexName;
    private OrmUpdateProperties updateProperties;
    private String nativeSql;
    private boolean orderById;
    private ProfileLocation profileLocation;

    public DefaultOrmQuery(BeanDescriptor<T> desc, SpiEbeanServer server, ExpressionFactory expressionFactory) {
        this.beanDescriptor = desc;
        this.rootBeanDescriptor = desc;
        this.beanType = desc.type();
        this.server = server;
        this.orderById = server.config().isDefaultOrderById();
        this.disableLazyLoading = server.config().isDisableLazyLoading();
        this.expressionFactory = expressionFactory;
        this.detail = new OrmQueryDetail();
    }

    public final void setNativeSql(String nativeSql) {
        this.nativeSql = nativeSql;
    }

    public final <D> DtoQuery<D> asDto(Class<D> dtoClass) {
        return this.server.findDto(dtoClass, this);
    }

    public final UpdateQuery<T> asUpdate() {
        return new DefaultUpdateQuery(this);
    }

    @Override
    public final BeanDescriptor<T> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public final boolean isFindAll() {
        return this.whereExpressions == null && this.nativeSql == null && this.rawSql == null;
    }

    @Override
    public final boolean isFindById() {
        if (this.id == null && this.whereExpressions != null) {
            this.id = this.whereExpressions.idEqualTo(this.beanDescriptor.idName());
            if (this.id != null) {
                this.whereExpressions = null;
            }
        }
        return this.id != null;
    }

    @Override
    public final String profileEventId() {
        switch (this.mode) {
            case LAZYLOAD_BEAN: {
                return "lo";
            }
            case LAZYLOAD_MANY: {
                return "lm";
            }
        }
        return this.type.profileEventId();
    }

    @Override
    public final String getProfileId() {
        return this.getPlanLabel();
    }

    public final Query<T> setProfileLocation(ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
        return this;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final String getPlanLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.profileLocation != null) {
            return this.profileLocation.label();
        }
        return null;
    }

    @Override
    public final void setProfilePath(String label, String relativePath, ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
        this.label = (profileLocation == null ? label : profileLocation.label()) + "_" + relativePath;
    }

    public final Query<T> setLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public final boolean isAutoTunable() {
        return this.nativeSql == null && this.beanDescriptor.isAutoTunable();
    }

    public final Query<T> setUseDocStore(boolean useDocStore) {
        this.useDocStore = useDocStore;
        return this;
    }

    @Override
    public final boolean isUseDocStore() {
        return this.useDocStore;
    }

    public final Query<T> apply(FetchPath fetchPath) {
        fetchPath.apply((Query)this);
        return this;
    }

    @Override
    public final void addSoftDeletePredicate(String softDeletePredicate) {
        if (this.softDeletePredicates == null) {
            this.softDeletePredicates = new ArrayList<String>();
        }
        this.softDeletePredicates.add(softDeletePredicate);
    }

    @Override
    public final List<String> getSoftDeletePredicates() {
        return this.softDeletePredicates;
    }

    @Override
    public final boolean isAsOfBaseTable() {
        return this.asOfBaseTable;
    }

    @Override
    public final void setAsOfBaseTable() {
        this.asOfBaseTable = true;
    }

    public final Query<T> setAllowLoadErrors() {
        this.allowLoadErrors = true;
        return this;
    }

    @Override
    public final void incrementAsOfTableCount() {
        ++this.asOfTableCount;
    }

    @Override
    public final void incrementAsOfTableCount(int increment) {
        this.asOfTableCount += increment;
    }

    @Override
    public final int getAsOfTableCount() {
        return this.asOfTableCount;
    }

    @Override
    public final Timestamp getAsOf() {
        return this.asOf;
    }

    public final Query<T> asOf(Timestamp asOfDateTime) {
        this.temporalMode = asOfDateTime != null ? SpiQuery.TemporalMode.AS_OF : SpiQuery.TemporalMode.CURRENT;
        this.asOf = asOfDateTime;
        return this;
    }

    public final Query<T> asDraft() {
        this.temporalMode = SpiQuery.TemporalMode.DRAFT;
        this.useBeanCache = CacheMode.OFF;
        return this;
    }

    public final Query<T> setIncludeSoftDeletes() {
        this.temporalMode = SpiQuery.TemporalMode.SOFT_DELETED;
        return this;
    }

    public final Query<T> setDocIndexName(String indexName) {
        this.docIndexName = indexName;
        this.useDocStore = true;
        return this;
    }

    @Override
    public final String getDocIndexName() {
        return this.docIndexName;
    }

    @Override
    public final SpiRawSql getRawSql() {
        return this.rawSql;
    }

    public final Query<T> setRawSql(RawSql rawSql) {
        this.rawSql = (SpiRawSql)rawSql;
        return this;
    }

    @Override
    public final String getOriginKey() {
        if (this.parentNode == null || this.parentNode.getOriginQueryPoint() == null) {
            return null;
        }
        return this.parentNode.getOriginQueryPoint().getKey();
    }

    @Override
    public final int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    public final Query<T> setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.lazyLoadBatchSize = lazyLoadBatchSize;
        return this;
    }

    @Override
    public final String getLazyLoadProperty() {
        return this.lazyLoadProperty;
    }

    @Override
    public final void setLazyLoadProperty(String lazyLoadProperty) {
        this.lazyLoadProperty = lazyLoadProperty;
    }

    public final ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    private final void createExtraJoinsToSupportManyWhereClause() {
        this.manyWhereJoins = new ManyWhereJoins();
        if (this.whereExpressions != null) {
            this.whereExpressions.containsMany(this.beanDescriptor, this.manyWhereJoins);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.containsMany(this.beanDescriptor, this.manyWhereJoins);
        }
        if (this.orderBy != null) {
            for (OrderBy.Property orderProperty : this.orderBy.getProperties()) {
                ElPropertyDeploy elProp = this.beanDescriptor.elPropertyDeploy(orderProperty.getProperty());
                if (elProp == null || !elProp.containsFormulaWithJoin()) continue;
                this.manyWhereJoins.addFormulaWithJoin(elProp.elPrefix(), elProp.name());
            }
        }
    }

    @Override
    public final ManyWhereJoins getManyWhereJoins() {
        return this.manyWhereJoins;
    }

    @Override
    public final boolean selectAllForLazyLoadProperty() {
        if (this.lazyLoadProperty != null && !this.detail.containsProperty(this.lazyLoadProperty)) {
            this.detail.select("*");
            return true;
        }
        return false;
    }

    private List<OrmQueryProperties> removeQueryJoins() {
        List<OrmQueryProperties> queryJoins = this.detail.removeSecondaryQueries();
        if (queryJoins != null && this.orderBy != null) {
            for (OrmQueryProperties joinPath : queryJoins) {
                List properties = this.orderBy.getProperties();
                Iterator it = properties.iterator();
                while (it.hasNext()) {
                    OrderBy.Property property = (OrderBy.Property)it.next();
                    if (!property.getProperty().startsWith(joinPath.getPath())) continue;
                    it.remove();
                    joinPath.addSecJoinOrderProperty(property);
                }
            }
        }
        return queryJoins;
    }

    private List<OrmQueryProperties> removeLazyJoins() {
        return this.detail.removeSecondaryLazyQueries();
    }

    @Override
    public final void setLazyLoadManyPath(String lazyLoadManyPath) {
        this.lazyLoadManyPath = lazyLoadManyPath;
    }

    @Override
    public final SpiQuerySecondary convertJoins() {
        if (!this.useDocStore) {
            this.createExtraJoinsToSupportManyWhereClause();
        }
        this.markQueryJoins();
        return new OrmQuerySecondary(this.removeQueryJoins(), this.removeLazyJoins());
    }

    private void markQueryJoins() {
        this.detail.markQueryJoins(this.beanDescriptor, this.lazyLoadManyPath, this.isAllowOneManyFetch(), this.type.defaultSelect());
    }

    private boolean isAllowOneManyFetch() {
        if (SpiQuery.Mode.LAZYLOAD_MANY == this.mode) {
            return false;
        }
        return this.singleAttribute || !this.hasMaxRowsOrFirstRow() || this.isRawSql();
    }

    @Override
    public final void setDefaultSelectClause() {
        if (this.type.defaultSelect()) {
            this.detail.setDefaultSelectClause(this.beanDescriptor);
        } else if (!this.detail.hasSelectClause()) {
            this.detail.setEmptyBase();
        }
    }

    @Override
    public final void setTenantId(Object tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public final Object getTenantId() {
        return this.tenantId;
    }

    @Override
    public final void setDetail(OrmQueryDetail detail) {
        this.detail = detail;
    }

    @Override
    public final boolean tuneFetchProperties(OrmQueryDetail tunedDetail) {
        return this.detail.tuneFetchProperties(tunedDetail);
    }

    @Override
    public final OrmQueryDetail getDetail() {
        return this.detail;
    }

    public final ExpressionList<T> filterMany(String prop) {
        OrmQueryProperties chunk = this.detail.getChunk(prop, true);
        return chunk.filterMany(this);
    }

    @Override
    public final void setFilterMany(String prop, ExpressionList<?> filterMany) {
        if (filterMany != null) {
            OrmQueryProperties chunk = this.detail.getChunk(prop, true);
            chunk.setFilterMany((SpiExpressionList)filterMany);
        }
    }

    @Override
    public final void prepareDocNested() {
        if (this.textExpressions != null) {
            this.textExpressions.prepareDocNested(this.beanDescriptor);
        }
        if (this.whereExpressions != null) {
            this.whereExpressions.prepareDocNested(this.beanDescriptor);
        }
    }

    @Override
    public final void setupForDeleteOrUpdate() {
        this.forUpdate = null;
        this.rootTableAlias = "${RTA}";
        this.setSelectId();
    }

    @Override
    public final CQueryPlanKey setDeleteByIdsPlan() {
        this.queryPlanKey = this.queryPlanKey.withDeleteByIds();
        return this.queryPlanKey;
    }

    @Override
    public final void setSelectId() {
        this.detail.clear();
        this.select(this.beanDescriptor.idSelect());
        this.singleAttribute = true;
    }

    @Override
    public final void setSingleAttribute() {
        this.singleAttribute = true;
    }

    @Override
    public final boolean isSingleAttribute() {
        return this.singleAttribute;
    }

    @Override
    public final CountDistinctOrder getCountDistinctOrder() {
        return this.countDistinctOrder;
    }

    @Override
    public final boolean isWithId() {
        return !this.manualId && !this.distinct && !this.singleAttribute;
    }

    @Override
    public final CacheIdLookup<T> cacheIdLookup() {
        if (this.whereExpressions == null) {
            return null;
        }
        List<SpiExpression> underlyingList = this.whereExpressions.getUnderlyingList();
        if (underlyingList.isEmpty()) {
            if (this.id != null) {
                return new CacheIdLookupSingle(this.id);
            }
        } else if (underlyingList.size() == 1) {
            InExpression in;
            SpiExpression singleExpression = underlyingList.get(0);
            if (singleExpression instanceof IdInExpression) {
                return new CacheIdLookupMany((IdInExpression)singleExpression);
            }
            if (singleExpression instanceof InExpression && (in = (InExpression)singleExpression).property().equals(this.beanDescriptor.idName())) {
                return new CacheIdLookupMany(in);
            }
        }
        return null;
    }

    @Override
    public final NaturalKeyQueryData<T> naturalKey() {
        if (this.whereExpressions == null) {
            return null;
        }
        BeanNaturalKey naturalKey = this.beanDescriptor.naturalKey();
        if (naturalKey == null) {
            return null;
        }
        NaturalKeyQueryData data = new NaturalKeyQueryData(naturalKey);
        for (SpiExpression expression : this.whereExpressions.getUnderlyingList()) {
            if (expression.naturalKey(data)) continue;
            return null;
        }
        return data;
    }

    @Override
    public final NaturalKeyBindParam getNaturalKeyBindParam() {
        NaturalKeyBindParam namedBind = null;
        if (this.bindParams != null && (namedBind = this.bindParams.getNaturalKeyBindParam()) == null) {
            return null;
        }
        if (this.whereExpressions != null) {
            SimpleExpression e;
            List<SpiExpression> exprList = this.whereExpressions.internalList();
            if (exprList.size() > 1) {
                return null;
            }
            if (exprList.isEmpty()) {
                return namedBind;
            }
            if (namedBind != null) {
                return null;
            }
            SpiExpression se = exprList.get(0);
            if (se instanceof SimpleExpression && (e = (SimpleExpression)se).isOpEquals()) {
                return new NaturalKeyBindParam(e.getPropName(), e.getValue());
            }
        }
        return null;
    }

    @Override
    public SpiQuery<T> copy() {
        return this.copy(this.server);
    }

    @Override
    public SpiQuery<T> copy(SpiEbeanServer server) {
        DefaultOrmQuery<T> copy = new DefaultOrmQuery<T>(this.beanDescriptor, server, this.expressionFactory);
        copy.transaction = this.transaction;
        copy.m2mIncludeJoin = this.m2mIncludeJoin;
        copy.profilingListener = this.profilingListener;
        copy.profileLocation = this.profileLocation;
        copy.baseTable = this.baseTable;
        copy.rootTableAlias = this.rootTableAlias;
        copy.distinct = this.distinct;
        copy.allowLoadErrors = this.allowLoadErrors;
        copy.timeout = this.timeout;
        copy.mapKey = this.mapKey;
        copy.id = this.id;
        copy.label = this.label;
        copy.nativeSql = this.nativeSql;
        copy.useBeanCache = this.useBeanCache;
        copy.useQueryCache = this.useQueryCache;
        copy.readOnly = this.readOnly;
        if (this.detail != null) {
            copy.detail = this.detail.copy();
        }
        copy.temporalMode = this.temporalMode;
        copy.firstRow = this.firstRow;
        copy.maxRows = this.maxRows;
        if (this.orderBy != null) {
            copy.orderBy = this.orderBy.copy();
        }
        copy.orderById = this.orderById;
        if (this.bindParams != null) {
            copy.bindParams = this.bindParams.copy();
        }
        if (this.whereExpressions != null) {
            copy.whereExpressions = this.whereExpressions.copy(copy);
        }
        if (this.havingExpressions != null) {
            copy.havingExpressions = this.havingExpressions.copy(copy);
        }
        copy.persistenceContextScope = this.persistenceContextScope;
        copy.usageProfiling = this.usageProfiling;
        copy.autoTune = this.autoTune;
        copy.parentNode = this.parentNode;
        copy.rawSql = this.rawSql;
        this.setCancelableQuery(copy);
        return copy;
    }

    public final Query<T> setPersistenceContextScope(PersistenceContextScope scope) {
        this.persistenceContextScope = scope;
        return this;
    }

    @Override
    public final PersistenceContextScope getPersistenceContextScope() {
        return this.persistenceContextScope;
    }

    @Override
    public final SpiQuery.Type getType() {
        return this.type;
    }

    @Override
    public final void setType(SpiQuery.Type type) {
        this.type = type;
    }

    @Override
    public final String getLoadDescription() {
        return this.loadDescription;
    }

    @Override
    public final String getLoadMode() {
        return this.loadMode;
    }

    @Override
    public final void setLoadDescription(String loadMode, String loadDescription) {
        this.loadMode = loadMode;
        this.loadDescription = loadDescription;
    }

    @Override
    public final PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public final void setPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @Override
    public final void setLazyLoadForParents(BeanPropertyAssocMany<?> many) {
        this.lazyLoadForParentsProperty = many;
    }

    @Override
    public final BeanPropertyAssocMany<?> getLazyLoadMany() {
        return this.lazyLoadForParentsProperty;
    }

    @Override
    public final boolean isDetailEmpty() {
        return this.detail.isEmpty();
    }

    public final boolean isAutoTuned() {
        return this.autoTuned;
    }

    @Override
    public final void setAutoTuned(boolean autoTuned) {
        this.autoTuned = autoTuned;
    }

    @Override
    public final Boolean isAutoTune() {
        return this.autoTune;
    }

    @Override
    public final void setDefaultRawSqlIfRequired() {
        if (this.beanDescriptor.isRawSqlBased() && this.rawSql == null) {
            this.rawSql = this.beanDescriptor.namedRawSql(DEFAULT_QUERY_NAME);
        }
    }

    public final Query<T> setAutoTune(boolean autoTune) {
        this.autoTune = autoTune;
        return this;
    }

    public final Query<T> withLock(Query.LockType lockType) {
        return this.setForUpdateWithMode(Query.LockWait.WAIT, lockType);
    }

    public final Query<T> withLock(Query.LockType lockType, Query.LockWait lockWait) {
        return this.setForUpdateWithMode(lockWait, lockType);
    }

    public final Query<T> forUpdate() {
        return this.setForUpdateWithMode(Query.LockWait.WAIT, Query.LockType.DEFAULT);
    }

    public final Query<T> forUpdateNoWait() {
        return this.setForUpdateWithMode(Query.LockWait.NOWAIT, Query.LockType.DEFAULT);
    }

    public final Query<T> forUpdateSkipLocked() {
        return this.setForUpdateWithMode(Query.LockWait.SKIPLOCKED, Query.LockType.DEFAULT);
    }

    private Query<T> setForUpdateWithMode(Query.LockWait mode, Query.LockType lockType) {
        this.forUpdate = mode;
        this.lockType = lockType;
        this.useBeanCache = CacheMode.OFF;
        return this;
    }

    public final boolean isForUpdate() {
        return this.forUpdate != null;
    }

    @Override
    public final Query.LockWait getForUpdateLockWait() {
        return this.forUpdate;
    }

    public final Query.LockType getForUpdateLockType() {
        return this.lockType;
    }

    @Override
    public final ProfilingListener getProfilingListener() {
        return this.profilingListener;
    }

    @Override
    public final void setProfilingListener(ProfilingListener profilingListener) {
        this.profilingListener = profilingListener;
    }

    public final QueryType getQueryType() {
        if (this.type != null) {
            switch (this.type) {
                case DELETE: {
                    return QueryType.DELETE;
                }
                case UPDATE: {
                    return QueryType.UPDATE;
                }
            }
        }
        return QueryType.FIND;
    }

    @Override
    public final SpiQuery.Mode getMode() {
        return this.mode;
    }

    @Override
    public final SpiQuery.TemporalMode getTemporalMode() {
        return this.temporalMode;
    }

    @Override
    public final boolean isAsOfQuery() {
        return this.asOf != null;
    }

    @Override
    public final boolean isAsDraft() {
        return SpiQuery.TemporalMode.DRAFT == this.temporalMode;
    }

    @Override
    public final boolean isIncludeSoftDeletes() {
        return SpiQuery.TemporalMode.SOFT_DELETED == this.temporalMode;
    }

    @Override
    public final void setMode(SpiQuery.Mode mode) {
        this.mode = mode;
    }

    @Override
    public final boolean isUsageProfiling() {
        return this.usageProfiling;
    }

    @Override
    public final void setUsageProfiling(boolean usageProfiling) {
        this.usageProfiling = usageProfiling;
    }

    @Override
    public final void setParentNode(ObjectGraphNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public final ObjectGraphNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public final ObjectGraphNode setOrigin(CallOrigin callOrigin) {
        ObjectGraphOrigin o = new ObjectGraphOrigin(this.calculateOriginQueryHash(), callOrigin, this.beanType.getName());
        this.parentNode = new ObjectGraphNode(o, null);
        return this.parentNode;
    }

    private int calculateOriginQueryHash() {
        int hc = this.beanType.getName().hashCode();
        hc = hc * 92821 + (this.type == null ? 0 : this.type.ordinal());
        return hc;
    }

    final CQueryPlanKey createQueryPlanKey() {
        if (this.isNativeSql()) {
            String bindHash = this.bindParams == null ? "" : this.bindParams.calcQueryPlanHash();
            this.queryPlanKey = new NativeSqlQueryPlanKey(this.type.ordinal() + this.nativeSql + "-" + this.firstRow + "-" + this.maxRows + "-" + bindHash);
        } else {
            this.queryPlanKey = new OrmQueryPlanKey(this.planDescription(), this.maxRows, this.firstRow, this.rawSql);
        }
        return this.queryPlanKey;
    }

    private String planDescription() {
        StringBuilder sb = new StringBuilder(300);
        if (this.type != null) {
            sb.append(this.type.ordinal());
        }
        if (this.useDocStore) {
            sb.append("/ds");
        }
        if (this.beanDescriptor.discValue() != null) {
            sb.append("/dv").append(this.beanDescriptor.discValue());
        }
        if (this.temporalMode != SpiQuery.TemporalMode.CURRENT) {
            sb.append("/tm").append(this.temporalMode.ordinal());
            if (this.versionsStart != null) {
                sb.append("v");
            }
        }
        if (this.forUpdate != null) {
            sb.append("/fu").append(this.forUpdate.ordinal());
            if (this.lockType != null) {
                sb.append("t").append(this.lockType.ordinal());
            }
        }
        if (this.id != null) {
            sb.append("/id");
        }
        if (this.manualId) {
            sb.append("/md");
        }
        if (this.distinct) {
            sb.append("/dt");
        }
        if (this.allowLoadErrors) {
            sb.append("/ae");
        }
        if (this.disableLazyLoading) {
            sb.append("/dl");
        }
        if (this.baseTable != null) {
            sb.append("/bt").append(this.baseTable);
        }
        if (this.rootTableAlias != null) {
            sb.append("/ra").append(this.rootTableAlias);
        }
        if (this.orderBy != null) {
            sb.append("/ob").append(this.orderBy.toStringFormat());
        }
        if (this.m2mIncludeJoin != null) {
            sb.append("/m2").append(this.m2mIncludeJoin.getTable());
        }
        if (this.mapKey != null) {
            sb.append("/mk").append(this.mapKey);
        }
        if (this.countDistinctOrder != null) {
            sb.append("/cd").append(this.countDistinctOrder.name());
        }
        if (this.detail != null) {
            sb.append("/d[");
            this.detail.queryPlanHash(sb);
            sb.append("]");
        }
        if (this.bindParams != null) {
            sb.append("/b[");
            this.bindParams.buildQueryPlanHash(sb);
            sb.append("]");
        }
        if (this.whereExpressions != null) {
            sb.append("/w[");
            this.whereExpressions.queryPlanHash(sb);
            sb.append("]");
        }
        if (this.havingExpressions != null) {
            sb.append("/h[");
            this.havingExpressions.queryPlanHash(sb);
            sb.append("]");
        }
        if (this.updateProperties != null) {
            sb.append("/u[");
            this.updateProperties.buildQueryPlanHash(sb);
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public final boolean isNativeSql() {
        return this.nativeSql != null;
    }

    @Override
    public final String getNativeSql() {
        return this.nativeSql;
    }

    @Override
    public final Object getQueryPlanKey() {
        return this.queryPlanKey;
    }

    @Override
    public final CQueryPlanKey prepare(SpiOrmQueryRequest<T> request) {
        this.prepareExpressions(request);
        this.prepareForPaging();
        this.queryPlanKey = this.createQueryPlanKey();
        return this.queryPlanKey;
    }

    private void prepareExpressions(BeanQueryRequest<?> request) {
        this.detail.prepareExpressions(request);
        if (this.whereExpressions != null) {
            this.whereExpressions.prepareExpression(request);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.prepareExpression(request);
        }
    }

    private void prepareForPaging() {
        if (this.orderByIsEmpty() && this.rawSql != null && this.rawSql.getSql() != null) {
            this.order(this.rawSql.getSql().getOrderBy());
        }
        if (this.checkPagingOrderBy()) {
            this.beanDescriptor.appendOrderById(this);
        }
    }

    @Override
    public final void queryBindKey(BindValuesKey key) {
        key.add(this.id);
        if (this.whereExpressions != null) {
            this.whereExpressions.queryBindKey(key);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.queryBindKey(key);
        }
        if (this.bindParams != null) {
            this.bindParams.queryBindHash(key);
        }
        key.add(this.asOf).add(this.versionsStart).add(this.versionsEnd);
    }

    @Override
    public final HashQuery queryHash() {
        BindValuesKey bindKey = new BindValuesKey();
        this.queryBindKey(bindKey);
        return new HashQuery(this.queryPlanKey, bindKey);
    }

    @Override
    public final boolean isRawSql() {
        return this.rawSql != null;
    }

    @Override
    public final int getTimeout() {
        return this.timeout;
    }

    @Override
    public final boolean hasMaxRowsOrFirstRow() {
        return this.maxRows > 0 || this.firstRow > 0;
    }

    @Override
    public final boolean isVersionsBetween() {
        return this.versionsStart != null;
    }

    @Override
    public final Timestamp getVersionStart() {
        return this.versionsStart;
    }

    @Override
    public final Timestamp getVersionEnd() {
        return this.versionsEnd;
    }

    @Override
    public final Boolean isReadOnly() {
        return this.readOnly;
    }

    public final Query<T> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public final boolean isBeanCachePut() {
        return this.useBeanCache.isPut() && this.beanDescriptor.isBeanCaching();
    }

    @Override
    public final boolean isBeanCacheGet() {
        return this.useBeanCache.isGet() && this.beanDescriptor.isBeanCaching();
    }

    @Override
    public final boolean isForceHitDatabase() {
        return this.forUpdate != null || CacheMode.PUT == this.useBeanCache;
    }

    @Override
    public final void resetBeanCacheAutoMode(boolean findOne) {
        if (this.useBeanCache == CacheMode.AUTO && this.useQueryCache != CacheMode.OFF) {
            this.useBeanCache = CacheMode.OFF;
        }
    }

    @Override
    public final CacheMode getUseBeanCache() {
        return this.useBeanCache;
    }

    @Override
    public final CacheMode getUseQueryCache() {
        return this.useQueryCache;
    }

    public final Query<T> setBeanCacheMode(CacheMode beanCacheMode) {
        this.useBeanCache = beanCacheMode;
        return this;
    }

    public final Query<T> setUseQueryCache(CacheMode useQueryCache) {
        this.useQueryCache = useQueryCache;
        return this;
    }

    public final Query<T> setLoadBeanCache(boolean loadBeanCache) {
        this.useBeanCache = loadBeanCache ? CacheMode.PUT : CacheMode.OFF;
        return this;
    }

    public final Query<T> setTimeout(int secs) {
        this.timeout = secs;
        return this;
    }

    @Override
    public final void selectProperties(Set<String> props) {
        this.detail.selectProperties(props);
    }

    @Override
    public final void fetchProperties(String property, Set<String> columns, FetchConfig config) {
        this.detail.fetchProperties(property, columns, config);
    }

    @Override
    public final void selectProperties(OrmQueryProperties properties) {
        this.detail.selectProperties(properties);
    }

    @Override
    public final void fetchProperties(String path, OrmQueryProperties other) {
        this.detail.fetchProperties(path, other);
    }

    @Override
    public final void addNested(String name, OrmQueryDetail nestedDetail, FetchConfig config) {
        this.detail.addNested(name, nestedDetail, config);
    }

    public final Query<T> select(String columns) {
        this.detail.select(columns);
        return this;
    }

    public final Query<T> select(FetchGroup<T> fetchGroup) {
        this.detail = ((SpiFetchGroup)fetchGroup).detail();
        return this;
    }

    public final Query<T> fetch(String path) {
        return this.fetch(path, null, null);
    }

    public final Query<T> fetch(String path, FetchConfig joinConfig) {
        return this.fetch(path, null, joinConfig);
    }

    public final Query<T> fetch(String path, String properties) {
        return this.fetch(path, properties, null);
    }

    public final Query<T> fetch(String path, String properties, FetchConfig config) {
        if (this.nativeSql != null && (config == null || config.isJoin())) {
            config = FETCH_QUERY;
        }
        return this.fetchInternal(path, properties, config);
    }

    public final Query<T> fetchQuery(String path) {
        return this.fetchInternal(path, null, FETCH_QUERY);
    }

    public final Query<T> fetchCache(String path) {
        return this.fetchInternal(path, null, FETCH_CACHE);
    }

    public final Query<T> fetchLazy(String path) {
        return this.fetchInternal(path, null, FETCH_LAZY);
    }

    public final Query<T> fetchQuery(String path, String properties) {
        return this.fetchInternal(path, properties, FETCH_QUERY);
    }

    public final Query<T> fetchCache(String path, String properties) {
        return this.fetchInternal(path, properties, FETCH_CACHE);
    }

    public final Query<T> fetchLazy(String path, String properties) {
        return this.fetchInternal(path, properties, FETCH_LAZY);
    }

    private Query<T> fetchInternal(String path, String properties, FetchConfig config) {
        this.detail.fetch(path, properties, config);
        return this;
    }

    public final Query<T> usingTransaction(Transaction transaction) {
        this.transaction = (SpiTransaction)transaction;
        return this;
    }

    public final Query<T> usingConnection(Connection connection) {
        this.transaction = new ExternalJdbcTransaction(connection);
        return this;
    }

    public final Query<T> usingDatabase(Database database) {
        this.server = (SpiEbeanServer)database;
        return this;
    }

    public final int delete() {
        return this.server.delete(this, this.transaction);
    }

    public final int delete(Transaction transaction) {
        return this.server.delete(this, transaction);
    }

    public final int update() {
        return this.server.update(this, this.transaction);
    }

    public final int update(Transaction transaction) {
        return this.server.update(this, transaction);
    }

    public final <A> List<A> findIds() {
        return this.server.findIds(this, this.transaction);
    }

    public final boolean exists() {
        return this.server.exists(this, this.transaction);
    }

    public final int findCount() {
        return this.server.findCount(this, this.transaction);
    }

    public final void findEachWhile(Predicate<T> consumer) {
        this.server.findEachWhile(this, consumer, this.transaction);
    }

    public final void findEach(Consumer<T> consumer) {
        this.server.findEach(this, consumer, this.transaction);
    }

    public final void findEach(int batch, Consumer<List<T>> consumer) {
        this.server.findEach(this, batch, consumer, this.transaction);
    }

    public final QueryIterator<T> findIterate() {
        return this.server.findIterate(this, this.transaction);
    }

    public final Stream<T> findStream() {
        return this.server.findStream(this, this.transaction);
    }

    public final List<Version<T>> findVersions() {
        this.temporalMode = SpiQuery.TemporalMode.VERSIONS;
        return this.server.findVersions(this, this.transaction);
    }

    public final List<Version<T>> findVersionsBetween(Timestamp start, Timestamp end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("start and end must not be null");
        }
        this.temporalMode = SpiQuery.TemporalMode.VERSIONS;
        this.versionsStart = start;
        this.versionsEnd = end;
        return this.server.findVersions(this, this.transaction);
    }

    public final List<T> findList() {
        return this.server.findList(this, this.transaction);
    }

    public final Set<T> findSet() {
        return this.server.findSet(this, this.transaction);
    }

    public final <K> Map<K, T> findMap() {
        return this.server.findMap(this, this.transaction);
    }

    public final <A> List<A> findSingleAttributeList() {
        return this.server.findSingleAttributeList(this, this.transaction);
    }

    public final <A> Set<A> findSingleAttributeSet() {
        return this.server.findSingleAttributeSet(this, this.transaction);
    }

    public final <A> A findSingleAttribute() {
        List<A> list = this.findSingleAttributeList();
        return !list.isEmpty() ? (A)list.get(0) : null;
    }

    public final T findOne() {
        return (T)this.server.findOne(this, this.transaction);
    }

    public final Optional<T> findOneOrEmpty() {
        return this.server.findOneOrEmpty(this, this.transaction);
    }

    public final FutureIds<T> findFutureIds() {
        return this.server.findFutureIds(this, this.transaction);
    }

    public final FutureList<T> findFutureList() {
        return this.server.findFutureList(this, this.transaction);
    }

    public final FutureRowCount<T> findFutureCount() {
        return this.server.findFutureCount(this, this.transaction);
    }

    public final PagedList<T> findPagedList() {
        return this.server.findPagedList(this, this.transaction);
    }

    public final Query<T> setParameter(Object value) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setNextParameter(value);
        return this;
    }

    public final Query<T> setParameters(Object ... values) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setNextParameters(values);
        return this;
    }

    public final Query<T> setParameter(int position, Object value) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(position, value);
        return this;
    }

    public final Query<T> setParameter(String name, Object value) {
        ONamedParam param;
        if (this.namedParams != null && (param = this.namedParams.get(name)) != null) {
            param.setValue(value);
            return this;
        }
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(name, value);
        return this;
    }

    @Override
    public final void setArrayParameter(String name, Collection<?> values) {
        if (this.namedParams != null) {
            throw new IllegalStateException("setArrayParameter() not supported when EQL parsed query");
        }
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setArrayParameter(name, values);
    }

    @Override
    public final boolean checkPagingOrderBy() {
        return this.orderById && !this.useDocStore;
    }

    @Override
    public final boolean orderByIsEmpty() {
        return this.orderBy == null || this.orderBy.isEmpty();
    }

    @Override
    public final OrderBy<T> getOrderBy() {
        return this.orderBy;
    }

    public final OrderBy<T> orderBy() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy((Query)this, null);
        }
        return this.orderBy;
    }

    public final Query<T> orderBy(String orderByClause) {
        this.orderBy = orderByClause == null || orderByClause.trim().isEmpty() ? null : new OrderBy((Query)this, orderByClause);
        return this;
    }

    public final Query<T> setOrderBy(OrderBy<T> orderBy) {
        this.orderBy = orderBy;
        if (orderBy != null) {
            orderBy.setQuery((Query)this);
        }
        return this;
    }

    @Override
    public final boolean isManualId() {
        return this.manualId;
    }

    @Override
    public final void setManualId() {
        if (this.detail != null && this.detail.hasSelectClause()) {
            this.manualId = true;
        }
    }

    @Override
    public final boolean isDistinct() {
        return this.distinct;
    }

    public final Query<T> setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public final Query<T> setCountDistinct(CountDistinctOrder countDistinctOrder) {
        this.countDistinctOrder = countDistinctOrder;
        return this;
    }

    public final boolean isCountDistinct() {
        return this.countDistinctOrder != null;
    }

    public final Class<T> getBeanType() {
        return this.beanType;
    }

    public final Class<? extends T> getInheritType() {
        return this.beanDescriptor.type();
    }

    public final Query<T> setInheritType(Class<? extends T> type) {
        if (type == this.beanType) {
            return this;
        }
        InheritInfo inheritInfo = this.rootBeanDescriptor.inheritInfo();
        InheritInfo inheritInfo2 = inheritInfo = inheritInfo == null ? null : inheritInfo.readType(type);
        if (inheritInfo == null) {
            throw new IllegalArgumentException("Given type " + type + " is not a subtype of " + this.beanType);
        }
        this.beanDescriptor = this.rootBeanDescriptor.descriptor(type);
        return this;
    }

    public final String toString() {
        return "Query [" + this.whereExpressions + "]";
    }

    @Override
    public final TableJoin getM2mIncludeJoin() {
        return this.m2mIncludeJoin;
    }

    @Override
    public final void setM2MIncludeJoin(TableJoin m2mIncludeJoin) {
        this.m2mIncludeJoin = m2mIncludeJoin;
    }

    public final Query<T> setDisableLazyLoading(boolean disableLazyLoading) {
        this.disableLazyLoading = disableLazyLoading;
        return this;
    }

    @Override
    public final boolean isDisableLazyLoading() {
        return this.disableLazyLoading;
    }

    @Override
    public final int getFirstRow() {
        return this.firstRow;
    }

    public final Query<T> setFirstRow(int firstRow) {
        this.firstRow = firstRow;
        return this;
    }

    @Override
    public final int getMaxRows() {
        return this.maxRows;
    }

    public final Query<T> setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public final String getMapKey() {
        return this.mapKey;
    }

    public final Query<T> setMapKey(String mapKey) {
        this.mapKey = mapKey;
        return this;
    }

    public final Object getId() {
        return this.id;
    }

    public final Query<T> setId(Object id) {
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        this.id = id;
        return this;
    }

    @Override
    public final BindParams getBindParams() {
        return this.bindParams;
    }

    public final Query<T> where(Expression expression) {
        this.where().add(expression);
        return this;
    }

    public final ExpressionList<T> text() {
        if (this.textExpressions == null) {
            this.useDocStore = true;
            this.textExpressions = new DefaultExpressionList(this);
        }
        return this.textExpressions;
    }

    public final ExpressionList<T> where() {
        if (this.whereExpressions == null) {
            this.whereExpressions = new DefaultExpressionList(this, null);
        }
        return this.whereExpressions;
    }

    @Override
    public final void simplifyExpressions() {
        if (this.whereExpressions != null) {
            this.whereExpressions.simplify();
        }
    }

    public final Query<T> having(Expression expression) {
        this.having().add(expression);
        return this;
    }

    public final ExpressionList<T> having() {
        if (this.havingExpressions == null) {
            this.havingExpressions = new DefaultExpressionList(this, null);
        }
        return this.havingExpressions;
    }

    @Override
    public final SpiExpressionList<T> getHavingExpressions() {
        return this.havingExpressions;
    }

    @Override
    public final SpiExpressionList<T> getWhereExpressions() {
        return this.whereExpressions;
    }

    @Override
    public final SpiExpressionList<T> getTextExpression() {
        return this.textExpressions;
    }

    public final String getGeneratedSql() {
        return this.generatedSql;
    }

    @Override
    public final void setGeneratedSql(String generatedSql) {
        this.generatedSql = generatedSql;
    }

    @Override
    public final void checkNamedParameters() {
        if (this.namedParams != null) {
            for (ONamedParam value : this.namedParams.values()) {
                value.checkValueSet();
            }
        }
    }

    @Override
    public final SpiNamedParam createNamedParameter(String name) {
        if (this.namedParams == null) {
            this.namedParams = new HashMap<String, ONamedParam>();
        }
        return this.namedParams.computeIfAbsent(name, ONamedParam::new);
    }

    @Override
    public final void setDefaultFetchBuffer(int fetchSize) {
        if (this.bufferFetchSizeHint == 0) {
            this.bufferFetchSizeHint = fetchSize;
        }
    }

    public final Query<T> setBufferFetchSizeHint(int bufferFetchSizeHint) {
        this.bufferFetchSizeHint = bufferFetchSizeHint;
        return this;
    }

    @Override
    public final int getBufferFetchSizeHint() {
        return this.bufferFetchSizeHint;
    }

    public final Query<T> setDisableReadAuditing() {
        this.disableReadAudit = true;
        return this;
    }

    @Override
    public final boolean isDisableReadAudit() {
        return this.disableReadAudit;
    }

    @Override
    public final boolean isFutureFetch() {
        return this.futureFetch;
    }

    @Override
    public final void setFutureFetch(boolean backgroundFetch) {
        this.futureFetch = backgroundFetch;
    }

    @Override
    public final void setFutureFetchAudit(ReadEvent event) {
        this.futureFetchAudit = event;
    }

    @Override
    public final ReadEvent getFutureFetchAudit() {
        return this.futureFetchAudit;
    }

    public final Query<T> setBaseTable(String baseTable) {
        this.baseTable = baseTable;
        return this;
    }

    @Override
    public final String getBaseTable() {
        return this.baseTable;
    }

    public final Query<T> alias(String alias) {
        this.rootTableAlias = alias;
        return this;
    }

    @Override
    public final String getAlias() {
        return this.rootTableAlias;
    }

    @Override
    public final String getAlias(String defaultAlias) {
        return this.rootTableAlias != null ? this.rootTableAlias : defaultAlias;
    }

    public final Set<String> validate() {
        return this.server.validateQuery(this);
    }

    @Override
    public final Set<String> validate(BeanType<T> desc) {
        SpiExpressionValidation validation = new SpiExpressionValidation(desc);
        if (this.whereExpressions != null) {
            this.whereExpressions.validate(validation);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.validate(validation);
        }
        if (this.orderBy != null) {
            for (OrderBy.Property property : this.orderBy.getProperties()) {
                validation.validate(property.getProperty());
            }
        }
        return validation.getUnknownProperties();
    }

    final void setUpdateProperties(OrmUpdateProperties updateProperties) {
        this.updateProperties = updateProperties;
    }

    @Override
    public final OrmUpdateProperties getUpdateProperties() {
        return this.updateProperties;
    }

    @Override
    public final ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    @Override
    public final void handleLoadError(String fullName, Exception e) {
        if (!this.allowLoadErrors) {
            throw new PersistenceException("Error loading on " + fullName, (Throwable)e);
        }
    }

    public final Query<T> orderById(boolean orderById) {
        this.orderById = orderById;
        return this;
    }
}

