/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.config.JsonConfig;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebeaninternal.server.type.DecimalUtils;
import io.ebeaninternal.server.type.IsoJsonDateTimeParser;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;

abstract class ScalarTypeBaseDateTime<T>
extends ScalarTypeBase<T> {
    protected final JsonConfig.DateTime mode;

    ScalarTypeBaseDateTime(JsonConfig.DateTime mode, Class<T> type, boolean jdbcNative, int jdbcType) {
        super(type, jdbcNative, jdbcType);
        this.mode = mode;
    }

    public long asVersion(T value) {
        return this.convertToMillis(value);
    }

    public abstract Timestamp convertToTimestamp(T var1);

    public abstract T convertFromTimestamp(Timestamp var1);

    public abstract T convertFromInstant(Instant var1);

    public abstract T convertFromMillis(long var1);

    public abstract long convertToMillis(T var1);

    protected abstract String toJsonNanos(T var1);

    protected abstract String toJsonISO8601(T var1);

    protected T fromJsonISO8601(String value) {
        return this.convertFromInstant(IsoJsonDateTimeParser.parseIso(value));
    }

    public void bind(DataBinder binder, T value) throws SQLException {
        if (value == null) {
            binder.setNull(93);
        } else {
            binder.setTimestamp(this.convertToTimestamp(value));
        }
    }

    public T read(DataReader reader) throws SQLException {
        Timestamp ts = reader.getTimestamp();
        if (ts == null) {
            return null;
        }
        return this.convertFromTimestamp(ts);
    }

    protected String toJsonNanos(long epochSecs, int nanos) {
        return DecimalUtils.toDecimal(epochSecs, nanos);
    }

    public T jsonRead(JsonParser parser) throws IOException {
        switch (parser.getCurrentToken()) {
            case VALUE_NUMBER_INT: {
                return this.convertFromMillis(parser.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                BigDecimal value = parser.getDecimalValue();
                Timestamp timestamp = DecimalUtils.toTimestamp(value);
                return this.convertFromTimestamp(timestamp);
            }
        }
        return this.fromJsonISO8601(parser.getText());
    }

    public void jsonWrite(JsonGenerator writer, T value) throws IOException {
        switch (this.mode) {
            case ISO8601: {
                writer.writeString(this.toJsonISO8601(value));
                break;
            }
            case NANOS: {
                writer.writeNumber(this.toJsonNanos(value));
                break;
            }
            default: {
                writer.writeNumber(this.convertToMillis(value));
            }
        }
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.DATETIME;
    }

    public String formatValue(T value) {
        long epochMillis = this.convertToMillis(value);
        return Long.toString(epochMillis);
    }

    public T parse(String value) {
        try {
            long epochMillis = Long.parseLong(value);
            return this.convertFromMillis(epochMillis);
        }
        catch (NumberFormatException e) {
            return this.convertFromTimestamp(Timestamp.valueOf(value));
        }
    }

    public boolean isDateTimeCapable() {
        return true;
    }

    public T readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        long val = dataInput.readLong();
        Timestamp ts = new Timestamp(val);
        return this.convertFromTimestamp(ts);
    }

    public void writeData(DataOutput dataOutput, T value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            Timestamp ts = this.convertToTimestamp(value);
            dataOutput.writeLong(ts.getTime());
        }
    }
}

