/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBaseVarchar;
import java.sql.SQLException;

final class ScalarTypeChar
extends ScalarTypeBaseVarchar<Character> {
    ScalarTypeChar() {
        super(Character.TYPE, false, 12);
    }

    @Override
    public Character convertFromDbString(String dbValue) {
        return Character.valueOf(dbValue.charAt(0));
    }

    @Override
    public String convertToDbString(Character beanValue) {
        return beanValue.toString();
    }

    @Override
    public void bind(DataBinder binder, Character value) throws SQLException {
        if (value == null) {
            binder.setNull(12);
        } else {
            String s = BasicTypeConverter.toString(value);
            binder.setString(s);
        }
    }

    @Override
    public Character read(DataReader reader) throws SQLException {
        String string = reader.getString();
        if (string == null || string.isEmpty()) {
            return null;
        }
        return Character.valueOf(string.charAt(0));
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toString(value);
    }

    @Override
    public Character toBeanType(Object value) {
        if (value == null) {
            return null;
        }
        String s = BasicTypeConverter.toString(value);
        return Character.valueOf(s.charAt(0));
    }

    @Override
    public String formatValue(Character t) {
        return t.toString();
    }

    @Override
    public Character parse(String value) {
        return Character.valueOf(value.charAt(0));
    }
}

