/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DocPropertyType;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeaninternal.server.type.ScalarTypeLogicalType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;

abstract class ScalarTypeUUIDBase
extends ScalarTypeBase<UUID>
implements ScalarTypeLogicalType {
    ScalarTypeUUIDBase(boolean jdbcNative, int jdbcType) {
        super(UUID.class, jdbcNative, jdbcType);
    }

    @Override
    public int getLogicalType() {
        return 5010;
    }

    @Override
    public String format(Object value) {
        return String.valueOf(value);
    }

    public String formatValue(UUID value) {
        return value.toString();
    }

    public UUID parse(String value) {
        return UUID.fromString(value);
    }

    public UUID toBeanType(Object value) {
        return BasicTypeConverter.toUUID(value, false);
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.convert(value, this.jdbcType);
    }

    public UUID readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.parse(dataInput.readUTF());
    }

    public void writeData(DataOutput dataOutput, UUID value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(value));
        }
    }

    public void jsonWrite(JsonGenerator writer, UUID value) throws IOException {
        writer.writeString(this.formatValue(value));
    }

    public UUID jsonRead(JsonParser parser) throws IOException {
        return this.parse(parser.getValueAsString());
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.UUID;
    }
}

