/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.bind;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.InputStreamInfo;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DataBind
implements DataBinder {
    private final DataTimeZone dataTimeZone;
    private final PreparedStatement pstmt;
    private final Connection connection;
    private final StringBuilder bindLog = new StringBuilder();
    private List<InputStream> inputStreams;
    protected int pos;
    private String json;
    private Object lastObject = null;

    public DataBind(DataTimeZone dataTimeZone, PreparedStatement pstmt, Connection connection) {
        this.dataTimeZone = dataTimeZone;
        this.pstmt = pstmt;
        this.connection = connection;
    }

    public final void pushJson(String json) {
        assert (this.json == null);
        this.json = json;
    }

    public final String popJson() {
        String ret = this.json;
        this.json = null;
        return ret;
    }

    public final StringBuilder append(Object entry) {
        return this.bindLog.append(entry);
    }

    public final StringBuilder log() {
        return this.bindLog;
    }

    public final void close() throws SQLException {
        this.pstmt.close();
    }

    public final int currentPos() {
        return this.pos;
    }

    public void setObject(Object value) throws SQLException {
        this.pstmt.setObject(++this.pos, value);
        this.lastObject = value;
    }

    public final void setObject(Object value, int sqlType) throws SQLException {
        this.pstmt.setObject(++this.pos, value, sqlType);
        this.lastObject = value;
    }

    public void setNull(int jdbcType) throws SQLException {
        this.pstmt.setNull(++this.pos, jdbcType);
        this.lastObject = null;
    }

    public final int nextPos() {
        return ++this.pos;
    }

    public final void decrementPos() {
        --this.pos;
    }

    public final int executeUpdate() throws SQLException {
        try {
            int n = this.pstmt.executeUpdate();
            return n;
        }
        finally {
            this.closeInputStreams();
        }
    }

    public void closeInputStreams() {
        if (this.inputStreams != null) {
            for (InputStream inputStream : this.inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    CoreLog.log.log(System.Logger.Level.WARNING, "Error closing InputStream that was bound to PreparedStatement", (Throwable)e);
                }
            }
            this.inputStreams = null;
        }
    }

    public final PreparedStatement getPstmt() {
        return this.pstmt;
    }

    public void setString(String value) throws SQLException {
        this.pstmt.setString(++this.pos, value);
        this.lastObject = value;
    }

    public final void setInt(int value) throws SQLException {
        this.pstmt.setInt(++this.pos, value);
        this.lastObject = null;
    }

    public final void setLong(long value) throws SQLException {
        this.pstmt.setLong(++this.pos, value);
        this.lastObject = null;
    }

    public final void setShort(short value) throws SQLException {
        this.pstmt.setShort(++this.pos, value);
        this.lastObject = null;
    }

    public final void setFloat(float value) throws SQLException {
        this.pstmt.setFloat(++this.pos, value);
        this.lastObject = null;
    }

    public final void setDouble(double value) throws SQLException {
        this.pstmt.setDouble(++this.pos, value);
        this.lastObject = null;
    }

    public final void setBigDecimal(BigDecimal value) throws SQLException {
        this.pstmt.setBigDecimal(++this.pos, value);
        this.lastObject = null;
    }

    public final void setDate(Date value) throws SQLException {
        Calendar timeZone = this.dataTimeZone.getTimeComponentTimeZone();
        if (timeZone != null) {
            this.pstmt.setDate(++this.pos, value, timeZone);
        } else {
            this.pstmt.setDate(++this.pos, value);
        }
        this.lastObject = null;
    }

    public final void setTimestamp(Timestamp value) throws SQLException {
        Calendar timeZone = this.dataTimeZone.getTimeZone();
        if (timeZone != null) {
            this.pstmt.setTimestamp(++this.pos, value, timeZone);
        } else {
            this.pstmt.setTimestamp(++this.pos, value);
        }
        this.lastObject = null;
    }

    public final void setTime(Time value) throws SQLException {
        Calendar timeZone = this.dataTimeZone.getTimeComponentTimeZone();
        if (timeZone != null) {
            this.pstmt.setTime(++this.pos, value, timeZone);
        } else {
            this.pstmt.setTime(++this.pos, value);
        }
        this.lastObject = null;
    }

    public void setBoolean(boolean value) throws SQLException {
        this.pstmt.setBoolean(++this.pos, value);
        this.lastObject = null;
    }

    public void setBytes(byte[] value) throws SQLException {
        this.pstmt.setBytes(++this.pos, value);
        this.lastObject = value;
    }

    public void setByte(byte value) throws SQLException {
        this.pstmt.setByte(++this.pos, value);
        this.lastObject = null;
    }

    public void setChar(char value) throws SQLException {
        this.pstmt.setString(++this.pos, String.valueOf(value));
        this.lastObject = null;
    }

    public List<InputStream> getInputStreams() {
        return this.inputStreams;
    }

    public void setBinaryStream(InputStream inputStream, long length) throws SQLException {
        if (this.inputStreams == null) {
            this.inputStreams = new ArrayList<InputStream>();
        }
        this.inputStreams.add(inputStream);
        this.pstmt.setBinaryStream(++this.pos, inputStream, length);
        this.lastObject = new InputStreamInfo(inputStream, length);
    }

    public void setBlob(byte[] bytes) throws SQLException {
        this.pstmt.setBinaryStream(++this.pos, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        this.lastObject = bytes;
    }

    public void setClob(String content) throws SQLException {
        this.pstmt.setCharacterStream(++this.pos, (Reader)new StringReader(content), content.length());
        this.lastObject = content;
    }

    public void setArray(String arrayType, Object[] elements) throws SQLException {
        this.pstmt.setArray(++this.pos, this.connection.createArrayOf(arrayType, elements));
        this.lastObject = null;
    }

    public Object popLastObject() {
        Object ret = this.lastObject;
        this.lastObject = null;
        return ret;
    }
}

