/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebeaninternal.server.deploy.BeanCascadeInfo;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.parse.AnnotationBase;
import io.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import io.ebeaninternal.server.deploy.parse.ReadAnnotationConfig;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;

public abstract class AnnotationParser
extends AnnotationBase {
    final DeployBeanInfo<?> info;
    final DeployBeanDescriptor<?> descriptor;
    final Class<?> beanType;
    final ReadAnnotationConfig readConfig;

    AnnotationParser(DeployBeanInfo<?> info, ReadAnnotationConfig readConfig) {
        super(info.getUtil());
        this.readConfig = readConfig;
        this.info = info;
        this.beanType = info.getDescriptor().getBeanType();
        this.descriptor = info.getDescriptor();
    }

    @Override
    public abstract void parse();

    void readIdAssocOne(DeployBeanPropertyAssoc<?> prop) {
        prop.setNullable(false);
        if (prop.isIdClass()) {
            prop.setImportedPrimaryKey();
        } else {
            prop.setId();
            prop.setEmbedded();
            this.info.setEmbeddedId(prop);
        }
    }

    void readIdScalar(DeployBeanProperty prop) {
        prop.setNullable(false);
        if (prop.isIdClass()) {
            prop.setImportedPrimaryKey();
        } else {
            prop.setId();
            if (prop.getPropertyType().equals(UUID.class) && this.readConfig.isIdGeneratorAutomatic()) {
                this.descriptor.setUuidGenerator();
            }
        }
    }

    void setCascadeTypes(CascadeType[] cascadeTypes, BeanCascadeInfo cascadeInfo) {
        if (cascadeTypes != null && cascadeTypes.length > 0) {
            cascadeInfo.setTypes(cascadeTypes);
        }
    }

    void readEmbeddedAttributeOverrides(DeployBeanPropertyAssocOne<?> prop) {
        Set<AttributeOverride> attrOverrides = this.annotationAttributeOverrides(prop);
        if (!attrOverrides.isEmpty()) {
            HashMap<String, Column> propMap = new HashMap<String, Column>(attrOverrides.size());
            for (AttributeOverride attrOverride : attrOverrides) {
                propMap.put(attrOverride.name(), attrOverride.column());
            }
            prop.getDeployEmbedded().putAll(propMap);
        }
    }

    void readColumn(Column columnAnn, DeployBeanProperty prop) {
        this.setColumnName(prop, columnAnn.name());
        prop.setDbInsertable(columnAnn.insertable());
        prop.setDbUpdateable(columnAnn.updatable());
        prop.setNullable(columnAnn.nullable());
        prop.setUnique(columnAnn.unique());
        if (columnAnn.precision() > 0) {
            prop.setDbLength(columnAnn.precision());
        } else if (columnAnn.length() != 255) {
            prop.setDbLength(columnAnn.length());
        }
        prop.setDbScale(columnAnn.scale());
        prop.setDbColumnDefn(columnAnn.columnDefinition());
        String baseTable = this.descriptor.getBaseTable();
        String tableName = columnAnn.table();
        if (!"".equals(tableName) && !tableName.equalsIgnoreCase(baseTable)) {
            prop.setSecondaryTable(tableName);
        }
    }

    protected void setColumnName(DeployBeanProperty prop, String name) {
        if (!this.isEmpty(name)) {
            prop.setDbColumn(this.databasePlatform.convertQuotedIdentifiers(name));
        }
    }

    String[] convertColumnNames(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this.databasePlatform.convertQuotedIdentifiers(columnNames[i]);
        }
        return columnNames;
    }

    protected String processFormula(String source) {
        return source == null ? null : source.replace("${dbTableName}", this.descriptor.getBaseTable());
    }
}

