/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.avaje.applog.AppLog;
import io.ebean.CallableSql;
import io.ebean.InsertOptions;
import io.ebean.Lists;
import io.ebean.MergeOptions;
import io.ebean.Query;
import io.ebean.SqlUpdate;
import io.ebean.Transaction;
import io.ebean.Update;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.event.BeanDeleteIdRequest;
import io.ebean.event.BeanPersistController;
import io.ebean.meta.MetricVisitor;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiPersistenceContext;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiUpdate;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.core.PersistRequestCallableSql;
import io.ebeaninternal.server.core.PersistRequestOrmUpdate;
import io.ebeaninternal.server.core.PersistRequestUpdateSql;
import io.ebeaninternal.server.core.Persister;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorManager;
import io.ebeaninternal.server.deploy.BeanManager;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.IntersectionRow;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.persist.DefaultPersistExecute;
import io.ebeaninternal.server.persist.DeleteIdRequest;
import io.ebeaninternal.server.persist.DeleteMode;
import io.ebeaninternal.server.persist.DeleteUnloadedForeignKeys;
import io.ebeaninternal.server.persist.Flags;
import io.ebeaninternal.server.persist.MergeHandler;
import io.ebeaninternal.server.persist.PersistExecute;
import io.ebeaninternal.server.persist.SaveManyBase;
import io.ebeaninternal.server.persist.SaveManyBeans;
import io.ebeaninternal.server.persist.SaveManyElementCollection;
import io.ebeaninternal.server.persist.SaveManyElementCollectionMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultPersister
implements Persister {
    private static final System.Logger PUB = AppLog.getLogger((String)"io.ebean.PUB");
    private static final System.Logger log = CoreLog.internal;
    private final PersistExecute persistExecute;
    private final SpiEbeanServer server;
    private final BeanDescriptorManager beanDescriptorManager;
    private final int maxDeleteBatch;

    public DefaultPersister(SpiEbeanServer server, Binder binder, BeanDescriptorManager descMgr) {
        this.server = server;
        this.beanDescriptorManager = descMgr;
        this.persistExecute = new DefaultPersistExecute(binder, server.config().getPersistBatchSize());
        this.maxDeleteBatch = this.initMaxDeleteBatch(server.databasePlatform().maxInBinding());
    }

    private int initMaxDeleteBatch(int maxInBinding) {
        return maxInBinding == 0 ? 1000 : Math.min(1000, maxInBinding);
    }

    @Override
    public void visitMetrics(MetricVisitor visitor) {
        this.persistExecute.visitMetrics(visitor);
    }

    @Override
    public int executeCallable(CallableSql callSql, Transaction t) {
        return this.executeOrQueue(new PersistRequestCallableSql(this.server, callSql, (SpiTransaction)t, this.persistExecute));
    }

    @Override
    public int executeOrmUpdate(Update<?> update, Transaction t) {
        SpiUpdate ormUpdate = (SpiUpdate)update;
        BeanManager mgr = this.beanManager(ormUpdate.beanType());
        return this.executeOrQueue(new PersistRequestOrmUpdate(this.server, mgr, ormUpdate, (SpiTransaction)t, this.persistExecute));
    }

    private int executeOrQueue(PersistRequest request) {
        try {
            request.initTransIfRequired();
            int rc = request.executeOrQueue();
            request.commitTransIfRequired();
            int n = rc;
            return n;
        }
        catch (Throwable e) {
            request.rollbackTransIfRequired();
            throw e;
        }
        finally {
            request.clearTransIfRequired();
        }
    }

    @Override
    public void addBatch(SpiSqlUpdate sqlUpdate, SpiTransaction transaction) {
        new PersistRequestUpdateSql(this.server, sqlUpdate, transaction, this.persistExecute).addBatch();
    }

    @Override
    public int[] executeBatch(SpiSqlUpdate sqlUpdate, SpiTransaction transaction) {
        BatchControl batchControl = transaction.batchControl();
        try {
            return batchControl.execute(sqlUpdate.getGeneratedSql(), sqlUpdate.isGetGeneratedKeys());
        }
        catch (SQLException e) {
            throw transaction.translate(e.getMessage(), e);
        }
    }

    @Override
    public void executeOrQueue(SpiSqlUpdate update, SpiTransaction t, boolean queue, int queuePosition) {
        if (queue) {
            this.addToFlushQueue(update, t, queuePosition);
        } else {
            this.executeSqlUpdate(update, t);
        }
    }

    @Override
    public void addToFlushQueue(SpiSqlUpdate update, SpiTransaction t, int pos) {
        new PersistRequestUpdateSql(this.server, update, t, this.persistExecute).addToFlushQueue(pos);
    }

    @Override
    public int executeSqlUpdate(SqlUpdate updSql, Transaction t) {
        return this.executeOrQueue(new PersistRequestUpdateSql(this.server, (SpiSqlUpdate)updSql, (SpiTransaction)t, this.persistExecute));
    }

    @Override
    public int executeSqlUpdateNow(SpiSqlUpdate updSql, Transaction t) {
        return this.executeOrQueue(new PersistRequestUpdateSql(this.server, updSql, (SpiTransaction)t, this.persistExecute, true));
    }

    @Override
    public <T> List<T> draftRestore(Query<T> query, Transaction transaction) {
        Class beanType = query.getBeanType();
        BeanDescriptor desc = this.server.descriptor(beanType);
        DraftHandler draftHandler = new DraftHandler(desc, transaction);
        query.usingTransaction(transaction);
        List liveBeans = draftHandler.fetchSourceBeans((SpiQuery)query, false);
        PUB.log(System.Logger.Level.DEBUG, "draftRestore [{0}] count[{1}]", desc.name(), liveBeans.size());
        if (liveBeans.isEmpty()) {
            return Collections.emptyList();
        }
        draftHandler.fetchDestinationBeans(liveBeans, true);
        BeanManager mgr = this.beanDescriptorManager.beanManager(beanType);
        for (Object liveBean : liveBeans) {
            Object draftBean = draftHandler.publishToDestinationBean(liveBean);
            draftHandler.resetDraft(draftBean);
            PUB.log(System.Logger.Level.TRACE, "draftRestore bean [{0}] id[{1}]", desc.name(), draftHandler.getId());
            this.update(this.createRequest(draftBean, transaction, null, mgr, PersistRequest.Type.UPDATE, 2));
        }
        PUB.log(System.Logger.Level.DEBUG, "draftRestore - complete for [{0}]", desc.name());
        return draftHandler.getDrafts();
    }

    private <T> List<Object> getBeanIds(BeanDescriptor<T> desc, List<T> beans) {
        ArrayList<Object> idList = new ArrayList<Object>(beans.size());
        for (T liveBean : beans) {
            idList.add(desc.id(liveBean));
        }
        return idList;
    }

    @Override
    public <T> List<T> publish(Query<T> query, Transaction transaction) {
        Class beanType = query.getBeanType();
        BeanDescriptor desc = this.server.descriptor(beanType);
        DraftHandler draftHandler = new DraftHandler(desc, transaction);
        query.usingTransaction(transaction);
        List draftBeans = draftHandler.fetchSourceBeans((SpiQuery)query, true);
        PUB.log(System.Logger.Level.DEBUG, "publish [{0}] count[{1}]", desc.name(), draftBeans.size());
        if (draftBeans.isEmpty()) {
            return Collections.emptyList();
        }
        draftHandler.fetchDestinationBeans(draftBeans, false);
        BeanManager mgr = this.beanDescriptorManager.beanManager(beanType);
        ArrayList livePublish = new ArrayList(draftBeans.size());
        for (Object draftBean : draftBeans) {
            Object liveBean = draftHandler.publishToDestinationBean(draftBean);
            livePublish.add(liveBean);
            draftHandler.resetDraft(draftBean);
            PersistRequest.Type persistType = draftHandler.isInsert() ? PersistRequest.Type.INSERT : PersistRequest.Type.UPDATE;
            PUB.log(System.Logger.Level.TRACE, "publish bean [{0}] id[{1}] type[{2}]", new Object[]{desc.name(), draftHandler.getId(), persistType});
            PersistRequestBean request = this.createRequest(liveBean, transaction, null, mgr, persistType, 6);
            if (persistType == PersistRequest.Type.INSERT) {
                this.insert(request);
            } else {
                this.update(request);
            }
            request.resetDepth();
        }
        draftHandler.updateDrafts(transaction, mgr);
        PUB.log(System.Logger.Level.DEBUG, "publish - complete for [{0}]", desc.name());
        return livePublish;
    }

    private int deleteRecurse(EntityBean detailBean, Transaction t, DeleteMode deleteMode) {
        return this.deleteRequest(this.createDeleteCascade(detailBean, t, deleteMode.persistType()));
    }

    private int delete(EntityBean detailBean, Transaction t, DeleteMode deleteMode) {
        return this.deleteRequest(this.createDeleteRequest(detailBean, t, deleteMode.persistType()));
    }

    @Override
    public int merge(BeanDescriptor<?> desc, EntityBean bean, MergeOptions options, SpiTransaction transaction) {
        MergeHandler merge = new MergeHandler(this.server, desc, bean, options, transaction);
        List<EntityBean> deleteBeans = merge.merge();
        if (!deleteBeans.isEmpty()) {
            for (EntityBean deleteBean : deleteBeans) {
                this.delete(deleteBean, (Transaction)transaction, options.isDeletePermanent());
            }
        }
        PersistRequestBean<EntityBean> request = this.createRequestRecurse(bean, transaction, null, 8);
        request.checkBatchEscalationOnCascade();
        this.saveRecurse(request);
        request.flushBatchOnCascade();
        return 0;
    }

    @Override
    public void update(EntityBean entityBean, Transaction t) {
        PersistRequestBean<EntityBean> req = this.createRequest(entityBean, t, PersistRequest.Type.UPDATE);
        req.checkDraft();
        try {
            req.initTransIfRequiredWithBatchCascade();
            if (req.isReference()) {
                if (req.isPersistCascade()) {
                    this.saveAssocMany(req);
                }
                req.completeUpdate();
            } else {
                this.update(req);
            }
            req.resetDepth();
            req.commitTransIfRequired();
            req.flushBatchOnCascade();
        }
        catch (Throwable ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
        finally {
            req.clearTransIfRequired();
        }
    }

    @Override
    public void save(EntityBean bean, Transaction t) {
        if (bean._ebean_getIntercept().isUpdate()) {
            this.update(bean, t);
        } else {
            this.insert(bean, null, t);
        }
    }

    @Override
    public void insert(EntityBean bean, InsertOptions insertOptions, Transaction t) {
        PersistRequestBean<EntityBean> req = this.createRequest(bean, t, PersistRequest.Type.INSERT);
        if (req.isSkipReference()) {
            return;
        }
        if (insertOptions != null) {
            req.setInsertOptions(insertOptions);
        }
        try {
            req.initTransIfRequiredWithBatchCascade();
            this.insert(req);
            req.resetDepth();
            req.commitTransIfRequired();
            req.flushBatchOnCascade();
        }
        catch (Throwable ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
        finally {
            req.clearTransIfRequired();
        }
    }

    void saveRecurse(EntityBean bean, Transaction t, Object parentBean, int flags) {
        this.saveRecurse(this.createRequestRecurse(bean, t, parentBean, flags));
    }

    private void saveRecurse(PersistRequestBean<?> request) {
        request.setSaveRecurse();
        if (request.isReference()) {
            if (request.isPersistCascade()) {
                request.flagUpdate();
                this.saveAssocMany(request);
            }
            request.completeUpdate();
        } else if (request.isInsert()) {
            this.insert(request);
        } else {
            this.update(request);
        }
    }

    private void insert(PersistRequestBean<?> request) {
        if (request.isRegisteredBean()) {
            return;
        }
        request.flagInsert();
        try {
            if (request.isPersistCascade()) {
                this.saveAssocOne(request);
            }
            request.executeOrQueue();
            if (request.isPersistCascade()) {
                this.saveAssocMany(request);
            }
            request.complete();
        }
        finally {
            request.unRegisterBean();
        }
    }

    private void update(PersistRequestBean<?> request) {
        if (request.isRegisteredBean()) {
            return;
        }
        request.flagUpdate();
        try {
            if (request.isPersistCascade()) {
                this.saveAssocOne(request);
            }
            if (request.isDirty()) {
                request.executeOrQueue();
            } else if (log.isLoggable(System.Logger.Level.DEBUG)) {
                log.log(System.Logger.Level.DEBUG, "Update skipped as bean is unchanged: {0}", request.bean());
            }
            if (request.isPersistCascade()) {
                this.saveAssocMany(request);
            }
            request.completeUpdate();
        }
        finally {
            request.unRegisterBean();
        }
    }

    @Override
    public int delete(EntityBean bean, Transaction t, boolean permanent) {
        PersistRequest.Type deleteType = permanent ? PersistRequest.Type.DELETE_PERMANENT : PersistRequest.Type.DELETE;
        PersistRequestBean originalRequest = this.createDeleteRequest(bean, t, deleteType);
        if (originalRequest.isHardDeleteDraft()) {
            return this.deleteRequest(this.createDeleteRequest(originalRequest.createReference(), t, PersistRequest.Type.DELETE_PERMANENT, 4), originalRequest);
        }
        return this.deleteRequest(originalRequest);
    }

    int deleteRequest(PersistRequestBean<?> req) {
        return this.deleteRequest(req, null);
    }

    private int deleteRequest(PersistRequestBean<?> req, PersistRequestBean<?> draftReq) {
        if (req.isRegisteredForDeleteBean()) {
            if (log.isLoggable(System.Logger.Level.DEBUG)) {
                log.log(System.Logger.Level.DEBUG, "skipping delete on alreadyRegistered {0}", req.bean());
            }
            return 0;
        }
        try {
            req.initTransIfRequiredWithBatchCascade();
            int rows = this.delete(req);
            if (draftReq != null) {
                draftReq.setTrans((SpiTransaction)req.transaction());
                rows = this.delete(draftReq);
            }
            req.commitTransIfRequired();
            req.flushBatchOnCascade();
            int n = rows;
            return n;
        }
        catch (Throwable ex) {
            req.rollbackTransIfRequired();
            throw ex;
        }
        finally {
            req.clearTransIfRequired();
        }
    }

    private void deleteCascade(List<?> beanList, SpiTransaction t, DeleteMode deleteMode, boolean children) {
        if (children) {
            t.depth(-1);
            t.checkBatchEscalationOnCollection();
        }
        for (Object bean : beanList) {
            this.deleteRecurse((EntityBean)bean, t, deleteMode);
        }
        if (children) {
            t.flushBatchOnCollection();
            t.depth(1);
        }
    }

    @Override
    public int deleteMany(Class<?> beanType, Collection<?> ids, Transaction transaction, boolean permanent) {
        DeleteMode deleteMode;
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.descriptor(beanType);
        DeleteMode deleteMode2 = deleteMode = permanent || !descriptor.isSoftDelete() ? DeleteMode.HARD : DeleteMode.SOFT;
        if (descriptor.isMultiTenant()) {
            return this.deleteAsBeans(ids, transaction, deleteMode, descriptor);
        }
        ArrayList<Object> idList = new ArrayList<Object>(ids.size());
        for (Object id : ids) {
            idList.add(descriptor.convertId(id));
        }
        return this.delete(descriptor, idList, transaction, deleteMode);
    }

    private int deleteAsBeans(Collection<?> ids, Transaction transaction, DeleteMode deleteMode, BeanDescriptor<?> descriptor) {
        int total = 0;
        for (Object id : ids) {
            EntityBean bean = descriptor.createEntityBean();
            descriptor.convertSetId(id, bean);
            int rowCount = this.delete(bean, transaction, deleteMode);
            if (rowCount == -1) {
                total = -1;
                continue;
            }
            if (total == -1) continue;
            total += rowCount;
        }
        return total;
    }

    @Override
    public int delete(Class<?> beanType, Object id, Transaction transaction, boolean permanent) {
        BeanDescriptor<?> descriptor = this.beanDescriptorManager.descriptor(beanType);
        if (descriptor.isMultiTenant()) {
            EntityBean bean = descriptor.createEntityBean();
            descriptor.convertSetId(id, bean);
            return this.delete(bean, transaction, permanent);
        }
        id = descriptor.convertId(id);
        DeleteMode deleteMode = permanent || !descriptor.isSoftDelete() ? DeleteMode.HARD : DeleteMode.SOFT;
        return this.delete(descriptor, id, transaction, deleteMode);
    }

    @Override
    public int deleteByIds(BeanDescriptor<?> descriptor, List<Object> idList, Transaction transaction, boolean permanent) {
        DeleteMode deleteMode = permanent || !descriptor.isSoftDelete() ? DeleteMode.HARD : DeleteMode.SOFT;
        return this.delete(descriptor, idList, transaction, deleteMode);
    }

    private int delete(BeanDescriptor<?> descriptor, List<Object> idList, Transaction transaction, DeleteMode deleteMode) {
        int batch = this.maxDeleteBatch / descriptor.idBinder().size();
        int rows = 0;
        for (List batchOfIds : Lists.partition(idList, (int)batch)) {
            rows += new DeleteBatchHelpMultiple(descriptor, batchOfIds, transaction, deleteMode).deleteBatch();
        }
        return rows;
    }

    private int delete(BeanDescriptor<?> descriptor, Object id, Transaction transaction, DeleteMode deleteMode) {
        return new DeleteBatchHelpSingle(descriptor, id, transaction, deleteMode).deleteBatch();
    }

    private void notifyDeleteById(BeanDescriptor<?> descriptor, Object id, List<Object> idList, Transaction transaction) {
        BeanPersistController controller = descriptor.persistController();
        if (controller != null) {
            DeleteIdRequest request = new DeleteIdRequest(this.server, transaction, descriptor.type(), id);
            if (idList == null) {
                controller.preDelete((BeanDeleteIdRequest)request);
            } else {
                for (Object idValue : idList) {
                    request.setId(idValue);
                    controller.preDelete((BeanDeleteIdRequest)request);
                }
            }
        }
    }

    private SpiQuery<?> deleteRequiresQuery(BeanDescriptor<?> desc, BeanPropertyAssocOne<?>[] propImportDelete, DeleteMode deleteMode) {
        Query q = this.server.createQuery((Class)desc.type());
        StringBuilder sb = new StringBuilder(30);
        for (BeanPropertyAssocOne<?> aPropImportDelete : propImportDelete) {
            sb.append(aPropImportDelete.name()).append(',');
        }
        q.setAutoTune(false);
        q.select(sb.toString());
        if (deleteMode.isHard() && desc.isSoftDelete()) {
            q.setIncludeSoftDeletes();
        }
        return q;
    }

    private int delete(PersistRequestBean<?> request) {
        DeleteUnloadedForeignKeys unloadedForeignKeys = null;
        if (request.isPersistCascade()) {
            request.registerDeleteBean();
            this.deleteAssocMany(request);
            unloadedForeignKeys = this.getDeleteUnloadedForeignKeys(request);
            if (unloadedForeignKeys != null) {
                unloadedForeignKeys.queryForeignKeys();
            }
        }
        int count = request.executeOrQueue();
        request.removeFromPersistenceContext();
        if (request.isPersistCascade()) {
            this.deleteAssocOne(request);
            if (unloadedForeignKeys != null) {
                unloadedForeignKeys.deleteCascade();
            }
        }
        request.complete();
        return count;
    }

    private void saveAssocMany(PersistRequestBean<?> request) {
        EntityBean parentBean = request.entityBean();
        BeanDescriptor<?> desc = request.descriptor();
        Transaction t = request.transaction();
        EntityBean orphanForRemoval = request.importedOrphanForRemoval();
        if (orphanForRemoval != null) {
            this.delete(orphanForRemoval, request.transaction(), false);
        }
        for (BeanPropertyAssocOne<?> prop : desc.propertiesOneExportedSave()) {
            EntityBean detailBean;
            if (!request.isLoadedProperty(prop) || (detailBean = prop.valueAsEntityBean(parentBean)) == null || prop.isSaveRecurseSkippable(detailBean)) continue;
            t.depth(1);
            prop.setParentBeanToChild(parentBean, detailBean);
            this.saveRecurse(detailBean, t, parentBean, request.flags());
            t.depth(-1);
        }
        boolean insertedParent = request.isInsertedParent();
        for (BeanPropertyAssocMany<?> many : desc.propertiesManySave()) {
            if (!request.isLoadedProperty(many) || many.isSkipSaveBeanCollection(parentBean, insertedParent)) continue;
            this.saveMany(insertedParent, many, parentBean, request);
        }
    }

    private void saveMany(boolean insertedParent, BeanPropertyAssocMany<?> many, EntityBean parentBean, PersistRequestBean<?> request) {
        this.saveManyRequest(insertedParent, many, parentBean, request).save();
    }

    private SaveManyBase saveManyRequest(boolean insertedParent, BeanPropertyAssocMany<?> many, EntityBean parentBean, PersistRequestBean<?> request) {
        if (!many.isElementCollection()) {
            return new SaveManyBeans(this, insertedParent, many, parentBean, request);
        }
        if (many.manyType().isMap()) {
            return new SaveManyElementCollectionMap(this, insertedParent, many, parentBean, request);
        }
        return new SaveManyElementCollection(this, insertedParent, many, parentBean, request);
    }

    void deleteManyIntersection(EntityBean bean, BeanPropertyAssocMany<?> many, SpiTransaction t, boolean publish, boolean queue) {
        SpiSqlUpdate sqlDelete = this.deleteAllIntersection(bean, many, publish);
        if (queue) {
            this.addToFlushQueue(sqlDelete, t, 0);
        } else {
            this.executeSqlUpdate(sqlDelete, t);
        }
    }

    private SpiSqlUpdate deleteAllIntersection(EntityBean bean, BeanPropertyAssocMany<?> many, boolean publish) {
        IntersectionRow intRow = many.buildManyToManyDeleteChildren(bean, publish);
        return intRow.createDeleteChildren(this.server);
    }

    private void deleteAssocMany(PersistRequestBean<?> request) {
        Transaction t = request.transaction();
        t.depth(-1);
        BeanDescriptor<?> desc = request.descriptor();
        EntityBean parentBean = request.entityBean();
        DeleteMode deleteMode = request.deleteMode();
        BeanPropertyAssocOne<?>[] expOnes = desc.propertiesOneExportedDelete();
        if (expOnes.length > 0) {
            DeleteUnloadedForeignKeys unloaded = null;
            BeanPropertyAssocOne<?>[] beanPropertyAssocOneArray = expOnes;
            int n = beanPropertyAssocOneArray.length;
            for (int i = 0; i < n; ++i) {
                BeanPropertyAssocOne<?> prop = beanPropertyAssocOneArray[i];
                if (!deleteMode.isHard() && !prop.isTargetSoftDelete()) continue;
                if (request.isLoadedProperty(prop)) {
                    Object detailBean = prop.getValue(parentBean);
                    if (detailBean == null) continue;
                    this.deleteRecurse((EntityBean)detailBean, t, deleteMode);
                    continue;
                }
                if (unloaded == null) {
                    unloaded = new DeleteUnloadedForeignKeys(this.server, request);
                }
                unloaded.add(prop);
            }
            if (unloaded != null) {
                unloaded.queryForeignKeys();
                unloaded.deleteCascade();
            }
        }
        for (BeanPropertyAssocMany<?> many : desc.propertiesManyDelete()) {
            Set modifyRemovals;
            Object details;
            if (many.hasJoinTable()) {
                if (!deleteMode.isHard()) continue;
                this.deleteManyIntersection(parentBean, many, (SpiTransaction)t, request.isPublish(), false);
                continue;
            }
            if (BeanCollection.ModifyListenMode.REMOVALS == many.modifyListenMode() && (deleteMode.isHard() || many.isTargetSoftDelete()) && (details = many.getValue(parentBean)) instanceof BeanCollection && (modifyRemovals = ((BeanCollection)details).modifyRemovals()) != null && !modifyRemovals.isEmpty()) {
                for (Object detail : modifyRemovals) {
                    EntityBean detailBean = (EntityBean)detail;
                    if (!many.hasId(detailBean)) continue;
                    this.deleteRecurse(detailBean, t, deleteMode);
                }
            }
            this.deleteManyDetails((SpiTransaction)t, desc, parentBean, many, null, deleteMode);
        }
        t.depth(1);
    }

    void deleteManyDetails(SpiTransaction t, BeanDescriptor<?> desc, EntityBean parentBean, BeanPropertyAssocMany<?> many, Set<Object> excludeDetailIds, DeleteMode deleteMode) {
        if (many.cascadeInfo().isDelete()) {
            BeanDescriptor targetDesc = many.targetDescriptor();
            int batch = this.maxDeleteBatch / targetDesc.idBinder().size();
            if (deleteMode.isHard() || targetDesc.isSoftDelete()) {
                if (targetDesc.isDeleteByStatement() && (excludeDetailIds == null || excludeDetailIds.size() <= batch)) {
                    IntersectionRow intRow = many.buildManyDeleteChildren(parentBean, excludeDetailIds);
                    SpiSqlUpdate sqlDelete = intRow.createDelete(this.server, deleteMode);
                    this.executeSqlUpdate(sqlDelete, t);
                } else {
                    List<Object> idsByParentId;
                    Object parentId = desc.getId(parentBean);
                    if (excludeDetailIds == null || excludeDetailIds.size() <= batch) {
                        idsByParentId = many.findIdsByParentId(parentId, t, deleteMode.isHard(), excludeDetailIds);
                    } else {
                        idsByParentId = many.findIdsByParentId(parentId, t, deleteMode.isHard(), null);
                        idsByParentId.removeIf(excludeDetailIds::contains);
                    }
                    if (!idsByParentId.isEmpty()) {
                        this.deleteChildrenById(t, targetDesc, idsByParentId, deleteMode);
                    }
                }
            }
        }
    }

    private void deleteChildrenById(SpiTransaction t, BeanDescriptor<?> targetDesc, List<Object> childIds, DeleteMode deleteMode) {
        if (!targetDesc.isDeleteByBulk()) {
            ArrayList refList = new ArrayList(childIds.size());
            for (Object id : childIds) {
                refList.add(targetDesc.createReference(id, null));
            }
            this.deleteCascade(refList, t, deleteMode, true);
        } else {
            this.delete(targetDesc, childIds, (Transaction)t, deleteMode);
        }
    }

    private void saveAssocOne(PersistRequestBean<?> request) {
        BeanDescriptor<?> desc = request.descriptor();
        for (BeanPropertyAssocOne<?> prop : desc.propertiesOneImportedSave()) {
            EntityBean detailBean;
            if (prop.isOrphanRemoval() && request.isDirtyProperty(prop)) {
                request.setImportedOrphanForRemoval(prop);
            }
            if (!request.isLoadedProperty(prop) || (detailBean = prop.valueAsEntityBean(request.entityBean())) == null || prop.isSaveRecurseSkippable(detailBean) || prop.isReference(detailBean) || request.isParent(detailBean)) continue;
            Transaction t = request.transaction();
            t.depthDecrement();
            this.saveRecurse(detailBean, t, null, request.flags());
            t.depth(1);
        }
        for (BeanPropertyAssocOne<?> prop : desc.propertiesOneExportedSave()) {
            if (!prop.isOrphanRemoval() || !request.isDirtyProperty(prop)) continue;
            this.deleteOrphan(request, prop);
        }
    }

    private void deleteOrphan(PersistRequestBean<?> request, BeanPropertyAssocOne<?> prop) {
        Object origValue = request.origValue(prop);
        if (origValue instanceof EntityBean) {
            this.delete((EntityBean)origValue, request.transaction(), false);
        }
    }

    private DeleteUnloadedForeignKeys getDeleteUnloadedForeignKeys(PersistRequestBean<?> request) {
        DeleteUnloadedForeignKeys fkeys = null;
        for (BeanPropertyAssocOne<?> one : request.descriptor().propertiesOneImportedDelete()) {
            if (request.isLoadedProperty(one)) continue;
            if (fkeys == null) {
                fkeys = new DeleteUnloadedForeignKeys(this.server, request);
            }
            fkeys.add(one);
        }
        return fkeys;
    }

    private void deleteAssocOne(PersistRequestBean<?> request) {
        DeleteMode deleteMode = request.deleteMode();
        for (BeanPropertyAssocOne<?> prop : request.descriptor().propertiesOneImportedDelete()) {
            EntityBean detail;
            Object detailBean;
            if (!deleteMode.isHard() && !prop.isTargetSoftDelete() || !request.isLoadedProperty(prop) || (detailBean = prop.getValue(request.entityBean())) == null || !prop.hasId(detail = (EntityBean)detailBean)) continue;
            this.deleteRecurse(detail, request.transaction(), deleteMode);
        }
    }

    private <T> PersistRequestBean<T> createRequest(T bean, Transaction t, PersistRequest.Type type) {
        return this.createRequestInternal(bean, t, type);
    }

    private <T> PersistRequestBean<T> createRequestInternal(T bean, Transaction t, PersistRequest.Type type) {
        BeanManager<T> mgr = this.beanManager(bean.getClass());
        return this.createRequest(bean, t, null, mgr, type, 0);
    }

    private <T> PersistRequestBean<T> createRequestRecurse(T bean, Transaction t, Object parentBean, int flags) {
        PersistRequest.Type type;
        BeanManager<T> mgr = this.beanManager(bean.getClass());
        BeanDescriptor<T> desc = mgr.getBeanDescriptor();
        EntityBean entityBean = (EntityBean)bean;
        if (Flags.isPublishMergeOrNormal(flags)) {
            type = entityBean._ebean_getIntercept().isUpdate() ? PersistRequest.Type.UPDATE : PersistRequest.Type.INSERT;
        } else {
            boolean insertMode = Flags.isInsert(flags);
            type = desc.isInsertMode(entityBean._ebean_getIntercept(), insertMode) ? PersistRequest.Type.INSERT : PersistRequest.Type.UPDATE;
        }
        return this.createRequest(bean, t, parentBean, mgr, type, Flags.setRecurse(flags));
    }

    private <T> PersistRequestBean<T> createRequest(T bean, Transaction t, Object parentBean, BeanManager<?> mgr, PersistRequest.Type type, int flags) {
        return new PersistRequestBean<T>(this.server, bean, parentBean, mgr, (SpiTransaction)t, this.persistExecute, type, flags);
    }

    <T> PersistRequestBean<T> createDeleteRemoved(T bean, Transaction t, int flags) {
        return this.createDeleteRequest(bean, t, PersistRequest.Type.DELETE, Flags.unsetRecurse(flags));
    }

    private <T> PersistRequestBean<T> createDeleteRequest(EntityBean bean, Transaction t, PersistRequest.Type type) {
        return this.createDeleteRequest(bean, t, type, 0);
    }

    private <T> PersistRequestBean<T> createDeleteCascade(EntityBean bean, Transaction t, PersistRequest.Type type) {
        return this.createDeleteRequest(bean, t, type, 2);
    }

    private <T> PersistRequestBean<T> createDeleteRequest(Object bean, Transaction t, PersistRequest.Type type, int flags) {
        BeanManager<T> mgr = this.beanManager(bean.getClass());
        if (type == PersistRequest.Type.DELETE_PERMANENT) {
            type = PersistRequest.Type.DELETE;
        } else if (type == PersistRequest.Type.DELETE && mgr.getBeanDescriptor().isSoftDelete()) {
            type = PersistRequest.Type.DELETE_SOFT;
        }
        PersistRequestBean<Object> request = new PersistRequestBean<Object>(this.server, bean, null, mgr, (SpiTransaction)t, this.persistExecute, type, flags);
        request.initForSoftDelete();
        return request;
    }

    private <T> BeanManager<T> beanManager(Class<?> cls) {
        return this.beanDescriptorManager.beanManager(cls);
    }

    class DraftHandler<T> {
        final BeanDescriptor<T> desc;
        final Transaction transaction;
        final List<T> draftUpdates = new ArrayList<T>();
        Object id;
        boolean insert;
        Map<?, T> destBeans;

        DraftHandler(BeanDescriptor<T> desc, Transaction transaction) {
            this.desc = desc;
            this.transaction = transaction;
        }

        List<T> getDrafts() {
            return this.draftUpdates;
        }

        void resetDraft(T draftBean) {
            if (this.desc.draftReset(draftBean)) {
                this.draftUpdates.add(draftBean);
            }
        }

        void updateDrafts(Transaction transaction, BeanManager<T> mgr) {
            if (!this.draftUpdates.isEmpty()) {
                PUB.log(System.Logger.Level.DEBUG, "publish - update dirty status on [{0}] drafts", this.draftUpdates.size());
                for (T draftUpdate : this.draftUpdates) {
                    DefaultPersister.this.update(DefaultPersister.this.createRequest(draftUpdate, transaction, null, mgr, PersistRequest.Type.UPDATE, 0));
                }
            }
        }

        List<T> fetchSourceBeans(SpiQuery<T> query, boolean asDraft) {
            this.desc.draftQueryOptimise(query);
            if (asDraft) {
                query.asDraft();
            }
            return DefaultPersister.this.server.findList(query);
        }

        void fetchDestinationBeans(List<T> sourceBeans, boolean asDraft) {
            List<Object> ids = DefaultPersister.this.getBeanIds(this.desc, sourceBeans);
            Query destQuery = DefaultPersister.this.server.createQuery((Class)this.desc.type());
            destQuery.usingTransaction(this.transaction);
            destQuery.where().idIn(ids);
            if (asDraft) {
                destQuery.asDraft();
            }
            this.desc.draftQueryOptimise(destQuery);
            this.destBeans = DefaultPersister.this.server.findMap(destQuery);
        }

        T publishToDestinationBean(T sourceBean) {
            this.id = this.desc.id(sourceBean);
            T destBean = this.destBeans.get(this.id);
            this.insert = destBean == null;
            return this.desc.publish(sourceBean, destBean);
        }

        boolean isInsert() {
            return this.insert;
        }

        Object getId() {
            return this.id;
        }
    }

    private class DeleteBatchHelpMultiple
    extends DeleteBatchHelp {
        private final List<Object> idList;

        public DeleteBatchHelpMultiple(BeanDescriptor<?> descriptor, List<Object> idList, Transaction transaction, DeleteMode deleteMode) {
            super(descriptor, transaction, deleteMode);
            this.idList = idList;
        }

        @Override
        int deleteImported(BeanPropertyAssocOne<?>[] propImportDelete) {
            SpiQuery<?> q = DefaultPersister.this.deleteRequiresQuery(this.descriptor, propImportDelete, this.deleteMode);
            q.usingTransaction(this.transaction);
            q.where().idIn(this.idList);
            if (this.transaction.isLogSummary()) {
                this.transaction.logSummary("-- DeleteById of {0} ids[{1}] requires fetch of foreign key values", this.descriptor.name(), this.idList);
            }
            List<?> beanList = DefaultPersister.this.server.findList(q);
            DefaultPersister.this.deleteCascade(beanList, this.transaction, this.deleteMode, false);
            return beanList.size();
        }

        @Override
        SqlUpdate sqlDeleteChildren(BeanPropertyAssoc<?> prop) {
            return prop.deleteByParentIdList(this.idList);
        }

        @Override
        List<Object> findChildIds(BeanPropertyAssoc<?> prop, boolean includeSoftDeletes) {
            return prop.findIdsByParentIdList(this.idList, this.transaction, includeSoftDeletes);
        }

        @Override
        int deleteBeans() {
            SqlUpdate deleteById = this.descriptor.deleteById(null, this.idList, this.deleteMode);
            if (this.transaction.isLogSummary()) {
                this.transaction.logSummary("-- Deleting {0} Ids: {1}", this.descriptor.name(), this.idList);
            }
            DefaultPersister.this.notifyDeleteById(this.descriptor, null, this.idList, this.transaction);
            deleteById.setAutoTableMod(false);
            this.transaction.event().addDeleteByIdList(this.descriptor, this.idList);
            int rows = DefaultPersister.this.executeSqlUpdate(deleteById, this.transaction);
            SpiPersistenceContext persistenceContext = this.transaction.persistenceContext();
            for (Object idValue : this.idList) {
                this.descriptor.contextDeleted(persistenceContext, idValue);
            }
            return rows;
        }
    }

    private class DeleteBatchHelpSingle
    extends DeleteBatchHelp {
        private final Object id;

        public DeleteBatchHelpSingle(BeanDescriptor<?> descriptor, Object id, Transaction transaction, DeleteMode deleteMode) {
            super(descriptor, transaction, deleteMode);
            this.id = id;
        }

        @Override
        int deleteImported(BeanPropertyAssocOne<?>[] propImportDelete) {
            EntityBean bean;
            SpiQuery<?> q = DefaultPersister.this.deleteRequiresQuery(this.descriptor, propImportDelete, this.deleteMode);
            q.usingTransaction(this.transaction);
            q.where().idEq(this.id);
            if (this.transaction.isLogSummary()) {
                this.transaction.logSummary("-- DeleteById of {0} id[{1}] requires fetch of foreign key values", this.descriptor.name(), this.id);
            }
            if ((bean = (EntityBean)DefaultPersister.this.server.findOne(q)) == null) {
                return 0;
            }
            return DefaultPersister.this.deleteRecurse(bean, this.transaction, this.deleteMode);
        }

        @Override
        SqlUpdate sqlDeleteChildren(BeanPropertyAssoc<?> prop) {
            return prop.deleteByParentId(this.id);
        }

        @Override
        List<Object> findChildIds(BeanPropertyAssoc<?> prop, boolean includeSoftDeletes) {
            return prop.findIdsByParentId(this.id, this.transaction, includeSoftDeletes);
        }

        @Override
        int deleteBeans() {
            SqlUpdate deleteById = this.descriptor.deleteById(this.id, null, this.deleteMode);
            if (this.transaction.isLogSummary()) {
                this.transaction.logSummary("-- Deleting {0} Id: {1}", this.descriptor.name(), this.id);
            }
            DefaultPersister.this.notifyDeleteById(this.descriptor, this.id, null, this.transaction);
            deleteById.setAutoTableMod(false);
            this.transaction.event().addDeleteById(this.descriptor, this.id);
            int rows = DefaultPersister.this.executeSqlUpdate(deleteById, this.transaction);
            SpiPersistenceContext persistenceContext = this.transaction.persistenceContext();
            this.descriptor.contextDeleted(persistenceContext, this.id);
            return rows;
        }
    }

    private abstract class DeleteBatchHelp {
        final BeanDescriptor<?> descriptor;
        final SpiTransaction transaction;
        final DeleteMode deleteMode;

        public DeleteBatchHelp(BeanDescriptor<?> descriptor, Transaction transaction, DeleteMode deleteMode) {
            this.descriptor = descriptor;
            this.transaction = (SpiTransaction)transaction;
            this.deleteMode = deleteMode;
        }

        int deleteBatch() {
            if (this.transaction.isPersistCascade()) {
                BeanPropertyAssocMany<?>[] manys;
                BeanPropertyAssocOne<?>[] expOnes;
                BeanPropertyAssocOne<?>[] propImportDelete = this.descriptor.propertiesOneImportedDelete();
                if (propImportDelete.length > 0) {
                    return this.deleteImported(propImportDelete);
                }
                for (BeanPropertyAssocOne<?> expOne : expOnes = this.descriptor.propertiesOneExportedDelete()) {
                    BeanDescriptor targetDesc = expOne.targetDescriptor();
                    if (!this.deleteMode.isHard() && !targetDesc.isSoftDelete()) continue;
                    if (this.deleteMode.isHard() && targetDesc.isDeleteByStatement()) {
                        DefaultPersister.this.executeSqlUpdate(this.sqlDeleteChildren(expOne), this.transaction);
                        continue;
                    }
                    List<Object> childIds = this.findChildIds(expOne, this.deleteMode.isHard());
                    if (childIds == null || childIds.isEmpty()) continue;
                    DefaultPersister.this.deleteChildrenById(this.transaction, targetDesc, childIds, this.deleteMode);
                }
                for (BeanPropertyAssocMany<?> many : manys = this.descriptor.propertiesManyDelete()) {
                    if (many.isManyToMany()) continue;
                    BeanDescriptor targetDesc = many.targetDescriptor();
                    if (!this.deleteMode.isHard() && !targetDesc.isSoftDelete()) continue;
                    if (this.deleteMode.isHard() && targetDesc.isDeleteByStatement()) {
                        DefaultPersister.this.executeSqlUpdate(this.sqlDeleteChildren(many), this.transaction);
                        continue;
                    }
                    List<Object> childIds = this.findChildIds(many, this.deleteMode.isHard());
                    if (childIds.isEmpty()) continue;
                    DefaultPersister.this.delete(targetDesc, childIds, (Transaction)this.transaction, this.deleteMode);
                }
            }
            if (this.deleteMode.isHard()) {
                BeanPropertyAssocMany<?>[] manys;
                for (BeanPropertyAssocMany<?> many : manys = this.descriptor.propertiesManyToMany()) {
                    if (this.transaction.isLogSummary()) {
                        this.transaction.logSummary("-- Deleting intersection table entries: {0}", many.fullName());
                    }
                    DefaultPersister.this.executeSqlUpdate(this.sqlDeleteChildren(many), this.transaction);
                }
            }
            return this.deleteBeans();
        }

        abstract int deleteImported(BeanPropertyAssocOne<?>[] var1);

        abstract SqlUpdate sqlDeleteChildren(BeanPropertyAssoc<?> var1);

        abstract List<Object> findChildIds(BeanPropertyAssoc<?> var1, boolean var2);

        abstract int deleteBeans();
    }
}

