/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanCollectionUtil;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.IntersectionRow;
import io.ebeaninternal.server.persist.DefaultPersister;
import io.ebeaninternal.server.persist.DeleteMode;
import io.ebeaninternal.server.persist.DmlUtil;
import io.ebeaninternal.server.persist.SaveManyBase;
import jakarta.persistence.PersistenceException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class SaveManyBeans
extends SaveManyBase {
    private final boolean cascade;
    private final boolean publish;
    private final BeanDescriptor<?> targetDescriptor;
    private final boolean isMap;
    private final boolean saveRecurseSkippable;
    private final DeleteMode deleteMode;
    private final boolean untouchedBeanCollection;
    private final Collection<?> collection;
    private final boolean hasOrderColumn;
    private final boolean forcedUpdate;
    private int sortOrder;
    private boolean forceOrphanRemoval;

    SaveManyBeans(DefaultPersister persister, boolean insertedParent, BeanPropertyAssocMany<?> many, EntityBean parentBean, PersistRequestBean<?> request) {
        super(persister, insertedParent, many, parentBean, request);
        this.cascade = many.cascadeInfo().isSave();
        this.publish = request.isPublish();
        this.targetDescriptor = many.targetDescriptor();
        this.isMap = many.manyType().isMap();
        this.saveRecurseSkippable = many.isSaveRecurseSkippable();
        this.deleteMode = this.targetDescriptor.isSoftDelete() ? DeleteMode.SOFT : DeleteMode.HARD;
        this.untouchedBeanCollection = this.untouchedBeanCollection();
        this.collection = this.cascade ? BeanCollectionUtil.getActualEntries(this.value) : null;
        this.hasOrderColumn = many.hasOrderColumn();
        this.forcedUpdate = request.isForcedUpdate();
    }

    private boolean untouchedBeanCollection() {
        return this.value instanceof BeanCollection && !((BeanCollection)this.value).wasTouched();
    }

    @Override
    void save() {
        if (this.many.hasJoinTable()) {
            boolean saveIntersectionFromThisDirection = this.isSaveIntersection();
            if (this.cascade) {
                this.saveAssocManyDetails();
            }
            if (saveIntersectionFromThisDirection) {
                this.saveAssocManyIntersection();
            } else {
                this.resetModifyState();
            }
        } else {
            if (this.isModifyListenMode() || this.hasOrderColumn) {
                this.removeAssocManyOrphans();
            }
            if (this.cascade) {
                this.saveAssocManyDetails();
            }
        }
        if (!this.insertedParent && !this.untouchedBeanCollection) {
            this.request.addUpdatedManyForL2Cache(this.many);
        }
    }

    private boolean isSaveIntersection() {
        if (!this.many.isManyToMany()) {
            return true;
        }
        return this.transaction.isSaveAssocManyIntersection(this.many.intersectionTableJoin().getTable(), this.many.descriptor().rootName());
    }

    private boolean isModifyListenMode() {
        return BeanCollection.ModifyListenMode.REMOVALS == this.many.modifyListenMode();
    }

    private void saveAssocManyDetails() {
        if (this.collection != null) {
            this.processDetails();
        }
    }

    private void processDetails() {
        BeanProperty orderColumn = null;
        if (this.hasOrderColumn) {
            if (!this.insertedParent && this.canSkipForOrderColumn() && this.saveRecurseSkippable) {
                return;
            }
            orderColumn = this.targetDescriptor.orderColumn();
        }
        if (this.insertedParent) {
            this.targetDescriptor.preAllocateIds(this.collection.size());
        }
        if (this.forcedUpdateOrphanRemoval()) {
            this.persister.deleteManyDetails(this.transaction, this.many.descriptor(), this.parentBean, this.many, this.detailIds(), this.deleteMode);
        }
        this.transaction.depth(1);
        this.saveAllBeans(orderColumn);
        if (this.hasOrderColumn) {
            this.resetModifyState();
        }
        this.transaction.depth(-1);
    }

    private boolean forcedUpdateOrphanRemoval() {
        return !this.insertedParent && this.many.isOrphanRemoval() && (this.forceOrphanRemoval || this.forcedUpdate);
    }

    private void saveAllBeans(BeanProperty orderColumn) {
        Object mapKeyValue = null;
        boolean clearedParent = false;
        for (Object detailBean : this.collection) {
            boolean skipSavingThisBean;
            ++this.sortOrder;
            if (this.isMap) {
                Map.Entry entry = (Map.Entry)detailBean;
                mapKeyValue = entry.getKey();
                detailBean = entry.getValue();
            }
            if (!(detailBean instanceof EntityBean)) continue;
            EntityBean detail = (EntityBean)detailBean;
            EntityBeanIntercept ebi = detail._ebean_getIntercept();
            if (this.many.hasJoinTable()) {
                skipSavingThisBean = this.targetDescriptor.isReference(ebi);
            } else {
                int originalOrder = 0;
                if (orderColumn != null && this.sortOrder != (originalOrder = detail._ebean_getIntercept().sortOrder())) {
                    detail._ebean_intercept().setSortOrder(this.sortOrder);
                    ebi.setDirty(true);
                }
                if (originalOrder == 0 && this.targetDescriptor.isReference(ebi)) {
                    skipSavingThisBean = true;
                } else if (ebi.isNewOrDirty()) {
                    skipSavingThisBean = false;
                    this.many.setParentToChild(this.parentBean, detail, mapKeyValue);
                } else {
                    skipSavingThisBean = this.many.setParentToChild(this.parentBean, detail, mapKeyValue, this.request.descriptor()) ? false : this.saveRecurseSkippable;
                }
            }
            if (skipSavingThisBean) continue;
            this.persister.saveRecurse(detail, this.transaction, this.parentBean, this.request.flags());
            if (!this.hasOrderColumn || clearedParent) continue;
            BeanDescriptor<?> beanDescriptor = this.many.descriptor();
            beanDescriptor.contextClear(this.transaction.persistenceContext(), beanDescriptor.getId(this.parentBean));
            clearedParent = true;
        }
    }

    private boolean canSkipForOrderColumn() {
        return this.untouchedBeanCollection && this.noDirtyBeans();
    }

    private boolean noDirtyBeans() {
        for (Object bean : this.collection) {
            if (!(bean instanceof EntityBean) || !((EntityBean)bean)._ebean_getIntercept().isDirty()) continue;
            return false;
        }
        return true;
    }

    private Set<Object> detailIds() {
        HashSet<Object> detailIds = new HashSet<Object>();
        for (Object detailBean : this.collection) {
            Object id;
            if (this.isMap) {
                detailBean = ((Map.Entry)detailBean).getValue();
            }
            if (!(detailBean instanceof EntityBean) || DmlUtil.isNullOrZero(id = this.targetDescriptor.id(detailBean)) || !this.forcedUpdate && ((EntityBean)detailBean)._ebean_getIntercept().isNew()) continue;
            detailIds.add(id);
        }
        return detailIds.isEmpty() ? null : detailIds;
    }

    private void saveAssocManyIntersection() {
        if (this.value == null) {
            return;
        }
        if (this.request.isQueueSaveMany()) {
            this.request.addSaveMany(this);
        } else {
            this.saveAssocManyIntersection(false);
        }
    }

    @Override
    public void saveBatch() {
        this.saveAssocManyIntersection(true);
    }

    private void saveAssocManyIntersection(boolean queue) {
        IntersectionRow intRow;
        BeanCollection manyValue;
        Collection additions;
        boolean vanillaCollection;
        boolean bl = vanillaCollection = !(this.value instanceof BeanCollection);
        if (vanillaCollection || this.forcedUpdate) {
            this.persister.deleteManyIntersection(this.parentBean, this.many, this.transaction, this.publish, queue);
        }
        Collection deletions = null;
        if (this.insertedParent || vanillaCollection || this.forcedUpdate) {
            if (this.value instanceof Map) {
                additions = ((Map)this.value).values();
            } else if (this.value instanceof Collection) {
                additions = (Collection)this.value;
            } else {
                throw new PersistenceException("Unhandled ManyToMany type " + this.value.getClass().getName() + " for " + this.many.fullName());
            }
            if (!vanillaCollection) {
                manyValue = (BeanCollection)this.value;
                this.setListenMode(manyValue, this.many);
                manyValue.modifyReset();
            }
        } else {
            manyValue = (BeanCollection)this.value;
            if (this.setListenMode(manyValue, this.many)) {
                additions = manyValue.actualDetails();
            } else {
                additions = manyValue.modifyAdditions();
                deletions = manyValue.modifyRemovals();
            }
            manyValue.modifyReset();
        }
        this.transaction.depth(1);
        if (deletions != null && !deletions.isEmpty()) {
            for (Object other : deletions) {
                EntityBean otherDelete = (EntityBean)other;
                intRow = this.many.buildManyToManyMapBean(this.parentBean, otherDelete, this.publish);
                SpiSqlUpdate sqlDelete = intRow.createDelete(this.server, DeleteMode.HARD);
                this.persister.executeOrQueue(sqlDelete, this.transaction, queue, 0);
            }
        }
        if (additions != null && !additions.isEmpty()) {
            for (Object other : additions) {
                EntityBean otherBean = (EntityBean)other;
                if (deletions != null && deletions.remove(otherBean)) {
                    String msg = "Inserting and Deleting same object? " + String.valueOf(otherBean);
                    if (this.transaction.isLogSummary()) {
                        this.transaction.logSummary(msg, new Object[0]);
                    }
                    CoreLog.log.log(System.Logger.Level.WARNING, msg);
                    continue;
                }
                if (!this.many.hasImportedId(otherBean)) {
                    throw new PersistenceException("ManyToMany bean does not have an Id value? " + String.valueOf(otherBean));
                }
                intRow = this.many.buildManyToManyMapBean(this.parentBean, otherBean, this.publish);
                SpiSqlUpdate sqlInsert = intRow.createInsert(this.server);
                this.persister.executeOrQueue(sqlInsert, this.transaction, queue, 1);
            }
        }
        this.transaction.depth(-1);
    }

    private boolean isChangedProperty() {
        return this.request.isChangedProperty(this.many.propertyIndex());
    }

    private void removeAssocManyOrphans() {
        if (this.value == null) {
            return;
        }
        if (!(this.value instanceof BeanCollection)) {
            this.forceOrphanRemoval = !this.insertedParent && this.isChangedProperty();
        } else {
            BeanCollection c = (BeanCollection)this.value;
            Set modifyRemovals = c.modifyRemovals();
            if (this.insertedParent) {
                c.setModifyListening(this.many.modifyListenMode());
            }
            if (!this.hasOrderColumn) {
                c.modifyReset();
            }
            if (modifyRemovals == null || modifyRemovals.isEmpty()) {
                this.forceOrphanRemoval = !this.insertedParent && this.isChangedProperty();
            } else {
                for (Object removedBean : modifyRemovals) {
                    EntityBean eb;
                    if (!(removedBean instanceof EntityBean) || !(eb = (EntityBean)removedBean)._ebean_intercept().isOrphanDelete()) continue;
                    this.persister.deleteRequest(this.persister.createDeleteRemoved(removedBean, this.transaction, this.request.flags()));
                }
            }
        }
    }

    private boolean setListenMode(BeanCollection<?> manyValue, BeanPropertyAssocMany<?> prop) {
        BeanCollection.ModifyListenMode mode = manyValue.modifyListening();
        if (mode == null) {
            manyValue.setModifyListening(prop.modifyListenMode());
            return true;
        }
        return false;
    }
}

