/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.InsertOptions;
import io.ebean.annotation.Platform;
import io.ebean.bean.EntityBean;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.persist.dml.DmlHandler;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dml.InsertMetaOptions;
import io.ebeaninternal.server.persist.dml.InsertMetaPlatform;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableDiscriminator;
import io.ebeaninternal.server.persist.dmlbind.BindableId;
import io.ebeaninternal.server.persist.dmlbind.BindableList;
import java.sql.SQLException;

final class InsertMeta {
    private final String sqlNullId;
    private final String sqlWithId;
    private final String sqlDraftNullId;
    private final String sqlDraftWithId;
    private final BindableId id;
    private final Bindable discriminator;
    private final BindableList all;
    private final BindableList allExcludeDraftOnly;
    private final boolean supportsGetGeneratedKeys;
    private final boolean concatenatedKey;
    private final boolean supportsSelectLastInsertedId;
    private final Bindable shadowFKey;
    private final String[] identityDbColumns;
    private final Platform platform;
    private final InsertMetaOptions options;

    InsertMeta(DatabasePlatform dbPlatform, BeanDescriptor<?> desc, Bindable shadowFKey, BindableId id, BindableList all) {
        this.platform = dbPlatform.platform();
        this.options = InsertMetaPlatform.create(this.platform, desc, this);
        this.discriminator = InsertMeta.discriminator(desc);
        this.id = id;
        this.all = all;
        this.allExcludeDraftOnly = all.excludeDraftOnly();
        this.shadowFKey = shadowFKey;
        String tableName = desc.baseTable();
        String draftTableName = desc.draftTable();
        this.sqlWithId = this.sql(false, tableName, false);
        String string = this.sqlDraftWithId = desc.isDraftable() ? this.sql(false, draftTableName, true) : this.sqlWithId;
        if (id.isConcatenated()) {
            this.concatenatedKey = true;
            this.identityDbColumns = null;
            this.sqlNullId = null;
            this.sqlDraftNullId = null;
            this.supportsGetGeneratedKeys = false;
            this.supportsSelectLastInsertedId = false;
        } else {
            this.concatenatedKey = false;
            if (id.getIdentityColumn() == null) {
                this.identityDbColumns = new String[0];
                this.supportsGetGeneratedKeys = false;
                this.supportsSelectLastInsertedId = false;
            } else {
                this.identityDbColumns = new String[]{id.getIdentityColumn()};
                this.supportsGetGeneratedKeys = dbPlatform.dbIdentity().isSupportsGetGeneratedKeys();
                this.supportsSelectLastInsertedId = desc.supportsSelectLastInsertedId();
            }
            this.sqlNullId = this.sql(true, tableName, false);
            this.sqlDraftNullId = desc.isDraftable() ? this.sql(true, draftTableName, true) : this.sqlNullId;
        }
    }

    private static Bindable discriminator(BeanDescriptor<?> desc) {
        InheritInfo inheritInfo = desc.inheritInfo();
        return inheritInfo != null ? new BindableDiscriminator(inheritInfo) : null;
    }

    boolean isConcatenatedKey() {
        return this.concatenatedKey;
    }

    String[] identityDbColumns() {
        return this.identityDbColumns;
    }

    boolean supportsSelectLastInsertedId() {
        return this.supportsSelectLastInsertedId;
    }

    boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    boolean deriveConcatenatedId(PersistRequestBean<?> persist) {
        return this.id.deriveConcatenatedId(persist);
    }

    public void bind(DmlHandler request, EntityBean bean, boolean withId, boolean publish) throws SQLException {
        if (withId) {
            this.id.dmlBind(request, bean);
        }
        if (this.shadowFKey != null) {
            this.shadowFKey.dmlBind(request, bean);
        }
        if (this.discriminator != null) {
            this.discriminator.dmlBind(request, bean);
        }
        if (publish) {
            this.allExcludeDraftOnly.dmlBind(request, bean);
        } else {
            this.all.dmlBind(request, bean);
        }
    }

    public String sql(boolean withId, boolean publish, InsertOptions insertOptions) {
        if (insertOptions == null) {
            return this.sql(withId, publish);
        }
        return this.options.sql(withId, insertOptions);
    }

    String sqlFor(boolean withId) {
        return withId ? this.sqlWithId : this.sqlNullId;
    }

    private String sql(boolean withId, boolean publish) {
        if (withId) {
            return publish ? this.sqlWithId : this.sqlDraftWithId;
        }
        return publish ? this.sqlNullId : this.sqlDraftNullId;
    }

    private String sql(boolean nullId, String table, boolean draftTable) {
        GenerateDmlRequest request = new GenerateDmlRequest();
        this.sql(request, nullId, table, draftTable);
        return request.toString();
    }

    void sql(GenerateDmlRequest request, boolean nullId, String table, boolean draftTable) {
        request.setInsertSetMode();
        request.append("insert into ").append(table);
        if (nullId && this.noColumnsForInsert(draftTable)) {
            request.append(this.defaultValues());
            return;
        }
        request.append(" (");
        if (!nullId) {
            this.id.dmlAppend(request);
        }
        if (this.shadowFKey != null) {
            this.shadowFKey.dmlAppend(request);
        }
        if (this.discriminator != null) {
            this.discriminator.dmlAppend(request);
        }
        if (draftTable) {
            this.all.dmlAppend(request);
        } else {
            this.allExcludeDraftOnly.dmlAppend(request);
        }
        request.append(") values (");
        request.append(request.insertBindBuffer());
        request.append(")");
    }

    private String defaultValues() {
        switch (this.platform.base()) {
            case MYSQL: 
            case MARIADB: 
            case ORACLE: {
                return " values (default)";
            }
            case DB2: {
                return " (" + this.id.getIdentityColumn() + ") values (default)";
            }
        }
        return " default values";
    }

    private boolean noColumnsForInsert(boolean draftTable) {
        return this.shadowFKey == null && this.discriminator == null && (draftTable ? this.all.isEmpty() : this.allExcludeDraftOnly.isEmpty());
    }
}

