/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.rawsql;

import io.ebean.RawSql;
import io.ebean.util.CamelCaseHelper;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface SpiRawSql
extends RawSql {
    public static final String IGNORE_COLUMN = "$$_IGNORE_COLUMN_$$";

    public Sql getSql();

    public Key getKey();

    public ResultSet getResultSet();

    public ColumnMapping getColumnMapping();

    public String mapToColumn(String var1);

    public static final class Key {
        private final boolean parsed;
        private final ColumnMapping columnMapping;
        private final String unParsedSql;

        Key(boolean parsed, String unParsedSql, ColumnMapping columnMapping) {
            this.parsed = parsed;
            this.unParsedSql = unParsedSql;
            this.columnMapping = columnMapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return this.parsed == that.parsed && this.columnMapping.equals(that.columnMapping) && this.unParsedSql.equals(that.unParsedSql);
        }

        public int hashCode() {
            int result = this.parsed ? 1 : 0;
            result = 92821 * result + this.columnMapping.hashCode();
            result = 92821 * result + this.unParsedSql.hashCode();
            return result;
        }
    }

    public static final class ColumnMapping
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final LinkedHashMap<String, Column> dbColumnMap;
        private final Map<String, String> propertyMap;
        private final Map<String, Column> propertyColumnMap;
        private final boolean parsed;
        private final boolean immutable;

        ColumnMapping(List<Column> columns) {
            this.immutable = false;
            this.parsed = true;
            this.propertyMap = null;
            this.propertyColumnMap = null;
            this.dbColumnMap = new LinkedHashMap();
            for (Column c : columns) {
                this.dbColumnMap.put(c.getDbColumnKey(), c);
            }
        }

        ColumnMapping() {
            this.immutable = false;
            this.parsed = false;
            this.propertyMap = null;
            this.propertyColumnMap = null;
            this.dbColumnMap = new LinkedHashMap();
        }

        ColumnMapping(String ... propertyNames) {
            this.immutable = false;
            this.parsed = false;
            this.propertyMap = null;
            this.dbColumnMap = new LinkedHashMap();
            int pos = 0;
            for (String prop : propertyNames) {
                this.dbColumnMap.put(prop, new Column(pos++, prop, null, prop));
            }
            this.propertyColumnMap = this.dbColumnMap;
        }

        ColumnMapping(boolean parsed, LinkedHashMap<String, Column> dbColumnMap) {
            this.immutable = true;
            this.parsed = parsed;
            this.dbColumnMap = dbColumnMap;
            HashMap<String, Column> pcMap = new HashMap<String, Column>();
            HashMap<String, String> pMap = new HashMap<String, String>();
            for (Column c : dbColumnMap.values()) {
                pMap.put(c.getPropertyName(), c.getDbColumn());
                pcMap.put(c.getPropertyName(), c);
            }
            this.propertyMap = Collections.unmodifiableMap(pMap);
            this.propertyColumnMap = Collections.unmodifiableMap(pcMap);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnMapping that = (ColumnMapping)o;
            return this.dbColumnMap.equals(that.dbColumnMap);
        }

        public int hashCode() {
            return this.dbColumnMap.hashCode();
        }

        public boolean contains(String property) {
            return this.propertyColumnMap.containsKey(property);
        }

        ColumnMapping createImmutableCopy() {
            for (Column c : this.dbColumnMap.values()) {
                c.checkMapping();
            }
            return new ColumnMapping(this.parsed, this.dbColumnMap);
        }

        void columnMapping(String dbColumn, String propertyName) {
            if (this.immutable) {
                throw new IllegalStateException("Should never happen");
            }
            if (!this.parsed) {
                int pos = this.dbColumnMap.size();
                this.dbColumnMap.put(dbColumn, new Column(pos, dbColumn, null, propertyName));
            } else {
                Column column = this.dbColumnMap.get(dbColumn);
                if (column == null) {
                    throw new IllegalArgumentException("DB Column " + dbColumn + " not found in mapping. Expecting one of " + String.valueOf(this.dbColumnMap.keySet()));
                }
                column.setPropertyName(propertyName);
            }
        }

        public boolean isParsed() {
            return this.parsed;
        }

        public int size() {
            return this.dbColumnMap.size();
        }

        Map<String, Column> mapping() {
            return this.dbColumnMap;
        }

        public Map<String, String> getMapping() {
            return this.propertyMap;
        }

        public int getIndexPosition(String property) {
            Column c = this.propertyColumnMap.get(property);
            return c == null ? -1 : c.getIndexPos();
        }

        public Iterator<Column> getColumns() {
            return this.dbColumnMap.values().iterator();
        }

        public void tableAliasMapping(String tableAlias, String path) {
            String startMatch = tableAlias + ".";
            for (Map.Entry<String, Column> entry : this.dbColumnMap.entrySet()) {
                if (!entry.getKey().startsWith(startMatch)) continue;
                entry.getValue().tableAliasMapping(path);
            }
        }

        public String mapToColumn(String property) {
            Column column = this.propertyColumnMap.get(property);
            return column == null ? null : column.getDbColumn();
        }

        public static class Column
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final int indexPos;
            private final String dbColumn;
            private final String dbAlias;
            private String propertyName;

            public Column(int indexPos, String dbColumn, String dbAlias) {
                this(indexPos, dbColumn, dbAlias, Column.derivePropertyName(dbAlias, dbColumn));
            }

            private Column(int indexPos, String dbColumn, String dbAlias, String propertyName) {
                this.indexPos = indexPos;
                this.dbColumn = dbColumn;
                this.dbAlias = dbAlias;
                this.propertyName = propertyName == null && dbAlias != null ? dbAlias : propertyName;
            }

            protected static String derivePropertyName(String dbAlias, String dbColumn) {
                if (dbAlias != null) {
                    return CamelCaseHelper.toCamelFromUnderscore((String)dbAlias);
                }
                int dotPos = dbColumn.indexOf(46);
                if (dotPos > -1) {
                    dbColumn = dbColumn.substring(dotPos + 1);
                }
                return CamelCaseHelper.toCamelFromUnderscore((String)dbColumn);
            }

            private void checkMapping() {
                if (this.propertyName == null) {
                    throw new IllegalStateException("No propertyName defined (Column mapping) for dbColumn " + this.dbColumn);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Column that = (Column)o;
                if (this.indexPos != that.indexPos) {
                    return false;
                }
                if (!this.dbColumn.equals(that.dbColumn)) {
                    return false;
                }
                if (!Objects.equals(this.dbAlias, that.dbAlias)) {
                    return false;
                }
                return Objects.equals(this.propertyName, that.propertyName);
            }

            public int hashCode() {
                int result = this.indexPos;
                result = 92821 * result + this.dbColumn.hashCode();
                result = 92821 * result + (this.dbAlias != null ? this.dbAlias.hashCode() : 0);
                result = 92821 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
                return result;
            }

            public String toString() {
                return this.dbColumn + "->" + this.propertyName;
            }

            public int getIndexPos() {
                return this.indexPos;
            }

            public String getDbColumnKey() {
                return this.dbAlias != null ? this.dbAlias : this.dbColumn;
            }

            public String getDbColumn() {
                return this.dbColumn;
            }

            public String getPropertyName() {
                return this.propertyName;
            }

            private void setPropertyName(String propertyName) {
                this.propertyName = propertyName;
            }

            public void tableAliasMapping(String path) {
                if (path != null) {
                    this.propertyName = path + "." + this.propertyName;
                }
            }
        }
    }

    public static final class Sql
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean parsed;
        private final String unparsedSql;
        private final String preFrom;
        private final String preWhere;
        private final boolean andWhereExpr;
        private final String preHaving;
        private final boolean andHavingExpr;
        private final String orderByPrefix;
        private final String orderBy;
        private final boolean distinct;

        Sql(String unparsedSql) {
            this.parsed = false;
            this.unparsedSql = unparsedSql;
            this.preFrom = null;
            this.preHaving = null;
            this.preWhere = null;
            this.andHavingExpr = false;
            this.andWhereExpr = false;
            this.orderByPrefix = null;
            this.orderBy = null;
            this.distinct = false;
        }

        Sql(String unparsedSql, String preFrom, String preWhere, boolean andWhereExpr, String preHaving, boolean andHavingExpr, String orderByPrefix, String orderBy, boolean distinct) {
            this.unparsedSql = unparsedSql;
            this.parsed = true;
            this.preFrom = preFrom;
            this.preHaving = preHaving;
            this.preWhere = preWhere;
            this.andHavingExpr = andHavingExpr;
            this.andWhereExpr = andWhereExpr;
            this.orderByPrefix = orderByPrefix;
            this.orderBy = orderBy;
            this.distinct = distinct;
        }

        public String toString() {
            if (!this.parsed) {
                return "unparsed " + this.unparsedSql;
            }
            return "select:" + this.preFrom + " preWhere:" + this.preWhere + " preHaving:" + this.preHaving + " orderBy:" + this.orderBy;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public boolean isParsed() {
            return this.parsed;
        }

        public String getUnparsedSql() {
            return this.unparsedSql;
        }

        public String getPreFrom() {
            return this.preFrom;
        }

        public String getPreWhere() {
            return this.preWhere;
        }

        public boolean isAndWhereExpr() {
            return this.andWhereExpr;
        }

        public String getPreHaving() {
            return this.preHaving;
        }

        public boolean isAndHavingExpr() {
            return this.andHavingExpr;
        }

        public String getOrderByPrefix() {
            return this.orderByPrefix == null ? "order by" : this.orderByPrefix;
        }

        public String getOrderBy() {
            return this.orderBy;
        }
    }
}

