/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.ProfileLocation;
import io.ebeaninternal.server.transaction.ProfileStream;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeaninternal.server.transaction.TransactionProfile;

public final class DefaultProfileStream
implements ProfileStream {
    private final long startNanos = System.nanoTime();
    private final StringBuilder buffer;
    private final TransactionProfile profile;
    private final TransactionProfile.Summary summary;

    DefaultProfileStream(ProfileLocation location, boolean verbose) {
        this.profile = new TransactionProfile(System.currentTimeMillis(), location);
        this.summary = this.profile.getSummary();
        this.buffer = verbose ? new StringBuilder(200) : null;
    }

    @Override
    public long offset() {
        return (System.nanoTime() - this.startNanos) / 1000L;
    }

    private long exeMicros(long offset) {
        return this.offset() - offset;
    }

    @Override
    public void addQueryEvent(String event, long offset, String beanName, int beanCount, String queryId) {
        long micros = this.exeMicros(offset);
        this.summary.addQuery(micros, beanCount);
        if (this.buffer != null) {
            this.add(micros, event, offset, beanName, beanCount, queryId);
        }
    }

    @Override
    public void addPersistEvent(String event, long offset, String beanName, int beanCount) {
        long micros = this.exeMicros(offset);
        this.summary.addPersist(micros, beanCount);
        if (this.buffer != null) {
            this.add(micros, event, offset, beanName, beanCount, "");
        }
    }

    @Override
    public void addEvent(String event, long offset) {
        long micros;
        this.summary.commitMicros = micros = this.exeMicros(offset);
        if (this.buffer != null) {
            this.buffer.append(event).append(',');
            this.buffer.append(offset).append(',');
            this.buffer.append(micros).append(';');
        }
    }

    private void add(long micros, String event, long offset, String beanName, int beanCount, String queryId) {
        this.buffer.append(event).append(',');
        this.buffer.append(offset).append(',');
        this.buffer.append(micros).append(',');
        this.buffer.append(beanName).append(',');
        this.buffer.append(beanCount).append(',');
        this.buffer.append(queryId).append(';');
    }

    @Override
    public void end(TransactionManager manager) {
        this.profile.setTotalMicros(this.offset());
        if (this.buffer != null) {
            this.profile.setData(this.buffer.toString());
        }
        manager.profileCollect(this.profile);
    }
}

