/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.ScalarTypeBaseDateTime;
import io.ebean.core.type.ScalarTypeUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;

final class ScalarTypeCalendar
extends ScalarTypeBaseDateTime<Calendar> {
    ScalarTypeCalendar(JsonConfig.DateTime mode, int jdbcType) {
        super(mode, Calendar.class, false, jdbcType);
    }

    public void bind(DataBinder binder, Calendar value) throws SQLException {
        if (value == null) {
            binder.setNull(93);
        } else if (this.jdbcType == 93) {
            Timestamp timestamp = new Timestamp(value.getTimeInMillis());
            binder.setTimestamp(timestamp);
        } else {
            Date d = new Date(value.getTimeInMillis());
            binder.setDate(d);
        }
    }

    public Calendar convertFromMillis(long systemTimeMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(systemTimeMillis);
        return calendar;
    }

    public Calendar convertFromTimestamp(Timestamp ts) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(ts.getTime());
        return calendar;
    }

    public Calendar convertFromInstant(Instant ts) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(ts.toEpochMilli());
        return calendar;
    }

    protected String toJsonNanos(Calendar value) {
        return String.valueOf(value.getTime().getTime());
    }

    protected String toJsonISO8601(Calendar value) {
        return ScalarTypeUtils.formatInstant((Instant)value.toInstant());
    }

    public long convertToMillis(Calendar value) {
        return value.getTimeInMillis();
    }

    public Timestamp convertToTimestamp(Calendar t) {
        return new Timestamp(t.getTimeInMillis());
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.convert((Object)value, (int)this.jdbcType);
    }

    public Calendar toBeanType(Object value) {
        return BasicTypeConverter.toCalendar((Object)value);
    }
}

