/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.PostgresHelper;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.type.ScalarTypeString;
import io.ebeaninternal.server.type.ScalarTypeStringBase;
import java.sql.SQLException;

final class ScalarTypeJsonString {
    static final Postgres JSONB = new Postgres(5002, "jsonb");
    static final Postgres JSON = new Postgres(5001, "json");

    ScalarTypeJsonString() {
    }

    static ScalarType<?> typeFor(boolean postgres, int dbType) {
        if (postgres) {
            switch (dbType) {
                case 5002: {
                    return JSONB;
                }
                case 5001: {
                    return JSON;
                }
            }
        }
        return ScalarTypeString.INSTANCE;
    }

    private static class Postgres
    extends ScalarTypeStringBase {
        final String postgresType;

        Postgres(int jdbcType, String postgresType) {
            super(true, jdbcType);
            this.postgresType = postgresType;
        }

        @Override
        public void bind(DataBinder binder, String rawJson) throws SQLException {
            binder.setObject(PostgresHelper.asObject((String)this.postgresType, (String)rawJson));
        }
    }
}

