/*
 * Decompiled with CFR 0.152.
 */
package io.ebeanservice.docstore.api.mapping;

import io.ebean.annotation.DocMapping;
import io.ebean.annotation.DocProperty;

public final class DocPropertyOptions {
    private Boolean code;
    private Boolean sortable;
    private Boolean store;
    private Float boost;
    private String nullValue;
    private Boolean includeInAll;
    private Boolean enabled;
    private Boolean norms;
    private Boolean docValues;
    private String analyzer;
    private String searchAnalyzer;
    private String copyTo;
    private DocProperty.Option options;

    public DocPropertyOptions() {
    }

    DocPropertyOptions(DocPropertyOptions source) {
        this.code = source.code;
        this.sortable = source.sortable;
        this.store = source.store;
        this.boost = source.boost;
        this.nullValue = source.nullValue;
        this.includeInAll = source.includeInAll;
        this.analyzer = source.analyzer;
        this.searchAnalyzer = source.searchAnalyzer;
        this.options = source.options;
        this.docValues = source.docValues;
        this.norms = source.norms;
        this.copyTo = source.copyTo;
        this.enabled = source.enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.code != null) {
            sb.append("code:").append(this.code).append(' ');
        }
        if (this.sortable != null) {
            sb.append("sortable:").append(this.sortable).append(' ');
        }
        if (this.store != null) {
            sb.append("store:").append(this.store).append(' ');
        }
        if (this.boost != null) {
            sb.append("boost:").append(this.boost).append(' ');
        }
        if (this.nullValue != null) {
            sb.append("nullValue:").append(this.nullValue).append(' ');
        }
        return sb.toString();
    }

    public boolean isCode() {
        return Boolean.TRUE.equals(this.code);
    }

    public Boolean code() {
        return this.code;
    }

    public void code(Boolean code) {
        this.code = code;
    }

    public boolean isSortable() {
        return Boolean.TRUE.equals(this.sortable);
    }

    public Boolean sortable() {
        return this.sortable;
    }

    public void sortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public Float boost() {
        return this.boost;
    }

    public void boost(Float boost) {
        this.boost = boost;
    }

    public String nullValue() {
        return this.nullValue;
    }

    public void nullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public Boolean store() {
        return this.store;
    }

    public void store(Boolean store) {
        this.store = store;
    }

    public Boolean includeInAll() {
        return this.includeInAll;
    }

    public void includeInAll(Boolean includeInAll) {
        this.includeInAll = includeInAll;
    }

    public Boolean docValues() {
        return this.docValues;
    }

    public void docValues(Boolean docValues) {
        this.docValues = docValues;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public void analyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public String searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public void searchAnalyzer(String searchAnalyzer) {
        this.searchAnalyzer = searchAnalyzer;
    }

    public String copyTo() {
        return this.copyTo;
    }

    public void copyTo(String copyTo) {
        this.copyTo = copyTo;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public void enabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean norms() {
        return this.norms;
    }

    public void norms(Boolean norms) {
        this.norms = norms;
    }

    public boolean isOptionsSet() {
        return this.options != null && this.options != DocProperty.Option.DEFAULT;
    }

    public DocProperty.Option options() {
        return this.options;
    }

    public void options(DocProperty.Option options) {
        this.options = options;
    }

    public DocPropertyOptions copy() {
        return new DocPropertyOptions(this);
    }

    public void apply(DocMapping docMapping) {
        this.apply(docMapping.options());
    }

    public void apply(DocProperty docMapping) {
        this.options = docMapping.options();
        if (docMapping.code()) {
            this.code = true;
        }
        if (docMapping.sortable()) {
            this.sortable = true;
        }
        if (docMapping.store()) {
            this.store = true;
        }
        if (Float.compare(docMapping.boost(), 1.0f) != 0) {
            this.boost = Float.valueOf(docMapping.boost());
        }
        if (!"".equals(docMapping.nullValue())) {
            this.nullValue = docMapping.nullValue();
        }
        if (!docMapping.includeInAll()) {
            this.includeInAll = false;
        }
        if (!docMapping.docValues()) {
            this.docValues = false;
        }
        if (!docMapping.enabled()) {
            this.enabled = false;
        }
        if (!docMapping.norms()) {
            this.norms = false;
        }
        if (!"".equals(docMapping.analyzer())) {
            this.analyzer = docMapping.analyzer();
        }
        if (!"".equals(docMapping.searchAnalyzer())) {
            this.searchAnalyzer = docMapping.searchAnalyzer();
        }
        if (!"".equals(docMapping.copyTo())) {
            this.copyTo = docMapping.copyTo();
        }
    }
}

