/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebeaninternal.api.ScopeTrans;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiTransactionProxy;
import io.ebeaninternal.server.transaction.TransactionScopeManager;
import io.ebeaninternal.server.util.ArrayStack;
import javax.persistence.PersistenceException;

public final class ScopedTransaction
extends SpiTransactionProxy {
    private final TransactionScopeManager manager;
    private final ArrayStack<ScopeTrans> stack = new ArrayStack();
    private ScopeTrans current;
    private boolean scopeCleared;

    public ScopedTransaction(TransactionScopeManager manager) {
        this.manager = manager;
    }

    public String toString() {
        return "ScopedTransaction " + String.valueOf(this.current);
    }

    @Override
    public void setNestedUseSavepoint() {
        this.current.setNestedUseSavepoint();
    }

    @Override
    public boolean isNestedUseSavepoint() {
        return this.current.isNestedUseSavepoint();
    }

    public void push(ScopeTrans scopeTrans) {
        if (this.current != null) {
            this.stack.push(this.current);
            if (this.current.isNestedUseSavepoint()) {
                scopeTrans.setNestedUseSavepoint();
            }
        }
        this.current = scopeTrans;
        this.transaction = scopeTrans.getTransaction();
    }

    public void complete(Object returnOrThrowable, int opCode) {
        this.current.complete(returnOrThrowable, opCode);
        this.pop();
    }

    public void complete() {
        try {
            this.current.complete();
        }
        finally {
            this.pop();
        }
    }

    private void clearScopeOnce() {
        if (!this.scopeCleared) {
            this.manager.clear();
            this.scopeCleared = true;
        }
    }

    private boolean clearScope() {
        if (this.stack.isEmpty()) {
            this.clearScopeOnce();
            return true;
        }
        return false;
    }

    private void pop() {
        if (!this.clearScope()) {
            this.current = this.stack.pop();
            this.transaction = this.current.getTransaction();
        }
    }

    public void end() throws PersistenceException {
        try {
            this.current.end();
        }
        finally {
            this.pop();
        }
    }

    public void close() {
        this.end();
    }

    public void commit() {
        try {
            this.current.commitTransaction();
        }
        finally {
            this.clearScope();
        }
    }

    public void rollbackAndContinue() {
        this.transaction.rollbackAndContinue();
    }

    public void rollback() throws PersistenceException {
        try {
            this.current.rollback(null);
        }
        finally {
            this.clearScope();
        }
    }

    public void rollback(Throwable e) throws PersistenceException {
        try {
            this.current.rollback(e);
        }
        finally {
            this.clearScope();
        }
    }

    public void setRollbackOnly() {
        this.current.setRollbackOnly();
    }

    public SpiTransaction current() {
        return this.transaction;
    }

    public Error caughtError(Error e) {
        return this.current.caughtError(e);
    }

    public Exception caughtThrowable(Exception e) {
        return this.current.caughtThrowable(e);
    }

    @Override
    public void putUserObject(String name, Object value) {
        this.current.putUserObject(name, value);
    }

    @Override
    public Object getUserObject(String name) {
        Object obj = this.current.getUserObject(name);
        if (obj != null) {
            return obj;
        }
        for (ScopeTrans trans : this.stack) {
            obj = trans.getUserObject(name);
            if (obj == null) continue;
            return obj;
        }
        return this.transaction.getUserObject(name);
    }
}

