/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.CacheMode;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.LoadBeanRequest;
import io.ebeaninternal.api.LoadManyRequest;
import io.ebeaninternal.api.LoadRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.DefaultServer;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.List;
import javax.persistence.EntityNotFoundException;

final class DefaultBeanLoader {
    private static final System.Logger log = CoreLog.internal;
    private final DefaultServer server;
    private final boolean onIterateUseExtraTxn;

    DefaultBeanLoader(DefaultServer server) {
        this.server = server;
        this.onIterateUseExtraTxn = server.databasePlatform().useExtraTransactionOnIterateSecondaryQueries();
    }

    void loadMany(LoadManyRequest loadRequest) {
        this.executeQuery(loadRequest, loadRequest.createQuery(this.server));
        loadRequest.postLoad();
    }

    void loadMany(BeanCollection<?> bc, boolean onlyIds) {
        this.loadManyInternal(bc.owner(), bc.propertyName(), false, onlyIds);
    }

    void refreshMany(EntityBean parentBean, String propertyName) {
        this.loadManyInternal(parentBean, propertyName, true, false);
    }

    private void loadManyInternal(EntityBean parentBean, String propertyName, boolean refresh, boolean onlyIds) {
        String parentKey;
        boolean useManyIdCache;
        EntityBeanIntercept ebi = parentBean._ebean_getIntercept();
        PersistenceContext pc = ebi.persistenceContext();
        BeanDescriptor parentDesc = this.server.descriptor(parentBean.getClass());
        BeanPropertyAssocMany many = (BeanPropertyAssocMany)parentDesc.beanProperty(propertyName);
        BeanCollection beanCollection = null;
        ExpressionList filterMany = null;
        Object currentValue = many.getValue(parentBean);
        if (currentValue instanceof BeanCollection) {
            beanCollection = (BeanCollection)currentValue;
            filterMany = beanCollection.filterMany();
        }
        Object parentId = parentDesc.getId(parentBean);
        if (pc == null) {
            pc = new DefaultPersistenceContext();
        }
        parentDesc.contextPutIfAbsent(pc, parentId, parentBean);
        boolean bl = useManyIdCache = beanCollection != null && parentDesc.isManyPropCaching() && many.isUseCache();
        if (useManyIdCache) {
            Boolean readOnly = null;
            if (ebi.isReadOnly()) {
                readOnly = Boolean.TRUE;
            }
            if (parentDesc.cacheManyPropLoad(many, beanCollection, parentKey = parentDesc.cacheKey(parentId), readOnly)) {
                return;
            }
        }
        Query query = this.server.createQuery(parentDesc.type());
        if (refresh) {
            BeanCollection emptyCollection = many.createEmpty(parentBean);
            many.setValue(parentBean, emptyCollection);
            query.setLoadDescription("refresh", null);
        } else {
            query.setLoadDescription("lazy", null);
        }
        query.select(parentDesc.idBinder().idSelect());
        if (onlyIds) {
            query.fetch(many.name(), many.targetIdProperty());
        } else {
            query.fetch(many.name());
        }
        if (filterMany != null) {
            query.setFilterMany(many.name(), filterMany);
        }
        query.where().idEq(parentId);
        query.setBeanCacheMode(CacheMode.OFF);
        query.setMode(SpiQuery.Mode.LAZYLOAD_MANY);
        query.setLazyLoadManyPath(many.name());
        query.setPersistenceContext(pc);
        if (ebi.isReadOnly()) {
            query.setReadOnly(true);
        }
        if (many.hasOrderColumn()) {
            query.orderBy(many.path() + "." + many.fetchOrderBy());
        }
        this.server.findOne(query);
        if (beanCollection != null) {
            if (beanCollection.checkEmptyLazyLoad()) {
                if (log.isLoggable(System.Logger.Level.DEBUG)) {
                    log.log(System.Logger.Level.DEBUG, "BeanCollection after load was empty. Owner:{0}", beanCollection.owner());
                }
            } else if (useManyIdCache) {
                parentKey = parentDesc.cacheKey(parentId);
                parentDesc.cacheManyPropPut(many, beanCollection, parentKey);
            }
        }
    }

    void loadBean(LoadBeanRequest loadRequest) {
        if (loadRequest.checkEmpty()) {
            throw new RuntimeException("Nothing in batch?");
        }
        SpiQuery<?> query = loadRequest.createQuery(this.server);
        loadRequest.postLoad(this.executeQuery(loadRequest, query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> executeQuery(LoadRequest loadRequest, SpiQuery<?> query) {
        if (this.onIterateUseExtraTxn && loadRequest.isParentFindIterate()) {
            SpiTransaction extraTxn = this.server.createReadOnlyTransaction(query.tenantId(), query.isUseMaster());
            try {
                query.usingTransaction(extraTxn);
                List<?> list = this.server.findList(query);
                return list;
            }
            finally {
                extraTxn.end();
            }
        }
        return this.server.findList(query);
    }

    public void refresh(EntityBean bean) {
        this.refreshBeanInternal(bean, SpiQuery.Mode.REFRESH_BEAN, -1);
    }

    void loadBean(EntityBeanIntercept ebi) {
        this.refreshBeanInternal(ebi.owner(), SpiQuery.Mode.LAZYLOAD_BEAN, -1);
    }

    private void refreshBeanInternal(EntityBean bean, SpiQuery.Mode mode, int embeddedOwnerIndex) {
        Object dbBean;
        BeanDescriptor desc;
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        PersistenceContext pc = ebi.persistenceContext();
        if (SpiQuery.Mode.REFRESH_BEAN == mode) {
            pc = null;
        }
        if (BeanDescriptor.EntityType.EMBEDDED == (desc = this.server.descriptor(bean.getClass())).entityType()) {
            EntityBean embeddedOwner = (EntityBean)ebi.embeddedOwner();
            this.refreshBeanInternal(embeddedOwner, mode, ebi.embeddedOwnerIndex());
        }
        Object id = desc.getId(bean);
        if (pc == null) {
            pc = new DefaultPersistenceContext();
            desc.contextPut(pc, id, bean);
            ebi.setPersistenceContext(pc);
        }
        boolean draft = desc.isDraftInstance(bean);
        if (embeddedOwnerIndex == -1) {
            if (desc.lazyLoadMany(ebi)) {
                return;
            }
            if (!draft && SpiQuery.Mode.LAZYLOAD_BEAN == mode && desc.isBeanCaching() && desc.cacheBeanLoad(bean, ebi, id, pc)) {
                return;
            }
        }
        Query query = this.server.createQuery(desc.type());
        query.setLazyLoadProperty(ebi.lazyLoadProperty());
        if (draft) {
            query.asDraft();
        } else if (mode == SpiQuery.Mode.LAZYLOAD_BEAN && desc.isSoftDelete()) {
            query.setIncludeSoftDeletes();
        }
        if (embeddedOwnerIndex > -1) {
            query.select(ebi.property(embeddedOwnerIndex));
        }
        query.setUsageProfiling(false);
        query.setPersistenceContext(pc);
        query.setMode(mode);
        query.setId(id);
        if (embeddedOwnerIndex > -1 || mode == SpiQuery.Mode.REFRESH_BEAN) {
            query.setBeanCacheMode(CacheMode.OFF);
        }
        if (ebi.isReadOnly()) {
            query.setReadOnly(true);
        }
        if (SpiQuery.Mode.REFRESH_BEAN == mode) {
            query.select("*");
        }
        if ((dbBean = query.findOne()) == null) {
            throw new EntityNotFoundException("Bean not found during lazy load or refresh. Id:" + String.valueOf(id) + " type:" + String.valueOf(desc.type()));
        }
        desc.resetManyProperties(dbBean);
    }
}

