/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.TxnProfileEventCodes;
import io.ebeaninternal.server.core.BeanRequest;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.persist.BatchPostExecute;
import io.ebeaninternal.server.persist.BatchedSqlException;
import io.ebeaninternal.server.persist.PersistExecute;
import java.sql.SQLException;
import javax.persistence.PersistenceException;

public abstract class PersistRequest
extends BeanRequest
implements BatchPostExecute,
TxnProfileEventCodes {
    protected Type type;
    boolean persistCascade;
    final PersistExecute persistExecute;
    protected String label;
    protected long startNanos;

    PersistRequest(SpiEbeanServer server, SpiTransaction t, PersistExecute persistExecute) {
        super(server, t);
        this.persistExecute = persistExecute;
    }

    PersistRequest(SpiEbeanServer server, SpiTransaction t, PersistExecute persistExecute, String label) {
        this(server, t, persistExecute);
        this.label = label;
    }

    public void resetDepth() {
        this.transaction.depthReset();
    }

    @Override
    public void addTimingBatch(long startNanos, int size) {
    }

    public void addTimingNoBatch(long startNanos) {
    }

    public void startBind(boolean batchThisRequest) {
        if (!batchThisRequest && this.label != null) {
            this.startNanos = System.nanoTime();
        }
    }

    @Override
    public boolean isFlushQueue() {
        return false;
    }

    public abstract int executeOrQueue();

    public abstract int executeNow();

    void profileBase(String event, long offset, String beanName, int beanCount) {
        this.transaction.profileStream().addPersistEvent(event, offset, beanName, beanCount);
    }

    @Override
    public boolean logSql() {
        return this.transaction.isLogSql();
    }

    @Override
    public boolean logSummary() {
        return this.transaction.isLogSummary();
    }

    public boolean isBatchThisRequest() {
        return this.transaction.isBatchThisRequest();
    }

    public PersistenceException translateSqlException(SQLException e) {
        return this.transaction.translate(e.getMessage(), e);
    }

    int executeStatement() {
        return this.executeStatement(false);
    }

    int executeStatement(boolean addBatch) {
        boolean batch = this.isBatchThisRequest();
        try {
            int rows;
            BatchControl control = this.transaction.batchControl();
            if (control != null) {
                rows = control.executeStatementOrBatch(this, batch, addBatch);
            } else if (batch) {
                control = this.persistExecute.createBatchControl(this.transaction);
                rows = control.executeStatementOrBatch(this, true, addBatch);
            } else {
                rows = this.executeNow();
            }
            return rows;
        }
        catch (BatchedSqlException e) {
            throw this.transaction.translate(e.getMessage(), e.getCause());
        }
    }

    public void initTransIfRequired() {
        this.createImplicitTransIfRequired();
        this.persistCascade = this.transaction.isPersistCascade();
        this.transaction.markNotQueryOnly();
    }

    public Type type() {
        return this.type;
    }

    public boolean isPersistCascade() {
        return this.persistCascade;
    }

    public static enum Type {
        INSERT("i"),
        UPDATE("u"),
        DELETE("d"),
        DELETE_SOFT("ds"),
        DELETE_PERMANENT("dp"),
        UPDATESQL("su"),
        CALLABLESQL("sc");

        final String profileEventId;

        private Type(String profileEventId) {
            this.profileEventId = profileEventId;
        }
    }
}

