/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.Query;
import io.ebean.SqlUpdate;
import io.ebean.Transaction;
import io.ebean.ValuePair;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarDataReader;
import io.ebean.core.type.ScalarType;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.json.SpiJsonReader;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.cache.CachedBeanId;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.deploy.AssocOneHelp;
import io.ebeaninternal.server.deploy.AssocOneHelpEmbedded;
import io.ebeaninternal.server.deploy.AssocOneHelpRefExported;
import io.ebeaninternal.server.deploy.AssocOneHelpRefInherit;
import io.ebeaninternal.server.deploy.AssocOneHelpRefSimple;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorInitContext;
import io.ebeaninternal.server.deploy.BeanDescriptorMap;
import io.ebeaninternal.server.deploy.BeanEmbeddedMeta;
import io.ebeaninternal.server.deploy.BeanEmbeddedMetaFactory;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyOverride;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.ExportedProperty;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.TableJoinColumn;
import io.ebeaninternal.server.deploy.id.ImportedId;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.el.ElPropertyChainBuilder;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.query.STreePropertyAssocOne;
import io.ebeaninternal.server.query.SqlBeanLoad;
import io.ebeaninternal.server.query.SqlJoinType;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;

public class BeanPropertyAssocOne<T>
extends BeanPropertyAssoc<T>
implements STreePropertyAssocOne {
    private final boolean oneToOne;
    private final boolean oneToOneExported;
    private final boolean orphanRemoval;
    private final boolean primaryKeyExport;
    private final boolean primaryKeyJoin;
    private AssocOneHelp localHelp;
    final BeanProperty[] embeddedProps;
    private final HashMap<String, BeanProperty> embeddedPropsMap;
    ImportedId importedId;
    private String deleteByParentIdSql;
    private String deleteByParentIdInSql;
    private BeanPropertyAssocMany<?> relationshipProperty;
    private boolean cacheNotifyRelationship;

    public BeanPropertyAssocOne(BeanDescriptorMap owner, DeployBeanPropertyAssocOne<T> deploy) {
        this(owner, null, deploy);
    }

    public BeanPropertyAssocOne(BeanDescriptorMap owner, BeanDescriptor<?> descriptor, DeployBeanPropertyAssocOne<T> deploy) {
        super(descriptor, deploy);
        this.primaryKeyExport = deploy.isPrimaryKeyExport();
        this.primaryKeyJoin = deploy.isPrimaryKeyJoin();
        this.oneToOne = deploy.isOneToOne();
        this.oneToOneExported = deploy.isOneToOneExported();
        this.orphanRemoval = deploy.isOrphanRemoval();
        if (this.embedded) {
            BeanEmbeddedMeta overrideMeta = BeanEmbeddedMetaFactory.create(owner, deploy);
            this.embeddedProps = overrideMeta.getProperties();
            this.embeddedPropsMap = new HashMap();
            for (BeanProperty embeddedProp : this.embeddedProps) {
                this.embeddedPropsMap.put(embeddedProp.name(), embeddedProp);
            }
        } else {
            this.embeddedProps = null;
            this.embeddedPropsMap = null;
        }
    }

    @Override
    public BeanPropertyAssocOne<?> override(BeanPropertyOverride override) {
        return new BeanPropertyAssocOne<T>(this, override);
    }

    protected BeanPropertyAssocOne(BeanPropertyAssocOne<T> source, BeanPropertyOverride override) {
        super(source, override);
        this.primaryKeyExport = source.primaryKeyExport;
        this.primaryKeyJoin = source.primaryKeyJoin;
        this.oneToOne = source.oneToOne;
        this.oneToOneExported = source.oneToOneExported;
        this.orphanRemoval = source.orphanRemoval;
        this.embeddedProps = null;
        this.embeddedPropsMap = null;
    }

    @Override
    public void initialise(BeanDescriptorInitContext initContext) {
        super.initialise(initContext);
        this.initialiseAssocOne(initContext.getEmbeddedPrefix());
        if (this.embedded) {
            initContext.setEmbeddedPrefix(this.name);
            for (BeanProperty embeddedProp : this.embeddedProps) {
                embeddedProp.initialise(initContext);
            }
            initContext.setEmbeddedPrefix(null);
        }
    }

    private void initialiseAssocOne(String embeddedPrefix) {
        this.localHelp = this.createHelp(this.embedded, this.oneToOneExported, embeddedPrefix);
        if (!(this.isTransient || this.embedded || this.descriptor.isDocStoreOnly())) {
            if (!this.oneToOneExported) {
                String foreignIdColumn;
                TableJoinColumn[] columns;
                String foreignJoinColumn;
                this.importedId = this.createImportedId(this, this.targetDescriptor, this.tableJoin);
                if (this.importedId.isScalar() && !(foreignJoinColumn = (columns = this.tableJoin.columns())[0].getForeignDbColumn()).equalsIgnoreCase(foreignIdColumn = this.targetDescriptor.idProperty().dbColumn())) {
                    throw new PersistenceException("Mapping limitation - @JoinColumn on " + this.fullName() + " needs to map to a primary key as per Issue #529  - joining to " + foreignJoinColumn + " and not " + foreignIdColumn);
                }
            } else {
                this.exportedProperties = this.createExported();
                String delStmt = "delete from " + this.targetDescriptor.baseTable() + " where ";
                this.deleteByParentIdSql = delStmt + this.deriveWhereParentIdSql(false);
                this.deleteByParentIdInSql = delStmt + this.deriveWhereParentIdSql(true);
            }
        }
    }

    void initialisePostTarget() {
        this.cacheNotifyRelationship = this.isCacheNotifyRelationship();
    }

    @Override
    public EntityBean valueAsEntityBean(EntityBean owner) {
        return (EntityBean)this.getValue(owner);
    }

    void setRelationshipProperty(BeanPropertyAssocMany<?> relationshipProperty) {
        this.relationshipProperty = relationshipProperty;
    }

    boolean isCacheNotifyRelationship() {
        return this.relationshipProperty != null && this.targetDescriptor.isBeanCaching();
    }

    void cacheClear() {
        if (this.cacheNotifyRelationship) {
            this.targetDescriptor.cacheManyPropClear(this.relationshipProperty.name());
        }
    }

    void cacheClear(CacheChangeSet changeSet) {
        if (this.cacheNotifyRelationship) {
            changeSet.addManyClear(this.targetDescriptor, this.relationshipProperty.name());
        }
    }

    void cacheDelete(boolean clear, EntityBean bean, CacheChangeSet changeSet) {
        if (this.cacheNotifyRelationship) {
            if (clear) {
                changeSet.addManyClear(this.targetDescriptor, this.relationshipProperty.name());
            } else {
                Object parentId;
                Object assocBean = this.getValue(bean);
                if (assocBean != null && (parentId = this.targetDescriptor.id(assocBean)) != null) {
                    String parentKey = this.targetDescriptor.cacheKey(parentId);
                    changeSet.addManyRemove(this.targetDescriptor, this.relationshipProperty.name(), parentKey);
                }
            }
        }
    }

    @Override
    Object naturalKeyVal(Map<String, Object> values) {
        EntityBean bean = (EntityBean)values.get(this.name);
        if (bean == null) {
            return null;
        }
        return this.targetIdBinder.cacheKeyFromBean(bean);
    }

    @Override
    public ElPropertyValue buildElPropertyValue(String propName, String remainder, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        if (this.embedded) {
            BeanProperty embProp = this.embeddedPropsMap.get(remainder);
            if (embProp == null) {
                String msg = "Embedded Property " + remainder + " not found in " + this.fullName();
                throw new PersistenceException(msg);
            }
            if (chain == null) {
                chain = new ElPropertyChainBuilder(true, propName);
            }
            chain.add(this);
            chain.setEmbedded(true);
            return chain.add(embProp).build();
        }
        return this.createElPropertyValue(propName, remainder, chain, propertyDeploy);
    }

    @Override
    public String elPlaceholder(boolean encrypted) {
        return encrypted ? this.elPlaceHolderEncrypted : this.elPlaceHolder;
    }

    @Override
    public SqlUpdate deleteByParentIdList(List<Object> parentIds) {
        String sql = this.deleteByParentIdInSql + this.targetIdBinder.idInValueExpr(false, parentIds.size());
        DefaultSqlUpdate delete = new DefaultSqlUpdate(sql);
        this.bindParentIds(delete, parentIds);
        return delete;
    }

    @Override
    public SqlUpdate deleteByParentId(Object parentId) {
        DefaultSqlUpdate delete = new DefaultSqlUpdate(this.deleteByParentIdSql);
        this.bindParentId(delete, parentId);
        return delete;
    }

    @Override
    public List<Object> findIdsByParentId(Object parentId, Transaction t, boolean includeSoftDeletes) {
        String rawWhere = this.deriveWhereParentIdSql(false);
        SpiEbeanServer server = this.server();
        Query q = server.createQuery((Class)this.type());
        q.usingTransaction(t);
        this.bindParentIdEq(rawWhere, parentId, q);
        if (includeSoftDeletes) {
            q.setIncludeSoftDeletes();
        }
        return server.findIds(q);
    }

    @Override
    public List<Object> findIdsByParentIdList(List<Object> parentIds, Transaction t, boolean includeSoftDeletes) {
        String rawWhere = this.deriveWhereParentIdSql(true);
        String inClause = this.idBinder().idInValueExpr(false, parentIds.size());
        String expr = rawWhere + inClause;
        SpiEbeanServer server = this.server();
        Query q = server.createQuery((Class)this.type());
        q.usingTransaction(t);
        this.bindParentIdsIn(expr, parentIds, q);
        if (includeSoftDeletes) {
            q.setIncludeSoftDeletes();
        }
        return server.findIds(q);
    }

    void addFkey() {
        if (this.importedId != null) {
            this.importedId.addFkeys(this.name);
        }
    }

    @Override
    public void registerColumn(BeanDescriptor<?> desc, String prefix) {
        if (this.embedded) {
            for (BeanProperty prop : this.embeddedProps) {
                prop.registerColumn(desc, SplitName.add((String)prefix, (String)this.name));
            }
        } else if (this.targetIdProperty != null) {
            BeanDescriptor target = this.targetDescriptor();
            String basePath = SplitName.add((String)prefix, (String)this.name);
            if (this.dbColumn != null) {
                BeanProperty idProperty = target.idProperty();
                desc.registerColumn(this.dbColumn, SplitName.add((String)basePath, (String)idProperty.name()));
            }
            desc.registerTable(target.baseTable(), this);
        }
    }

    public BeanProperty[] properties() {
        return this.embeddedProps;
    }

    @Override
    public void buildRawSqlSelectChain(String prefix, List<String> selectChain) {
        prefix = SplitName.add((String)prefix, (String)this.name);
        if (!this.embedded) {
            InheritInfo inheritInfo = this.targetDescriptor.inheritInfo();
            if (inheritInfo != null) {
                String discriminatorColumn = inheritInfo.getDiscriminatorColumn();
                String discProperty = prefix + "." + discriminatorColumn;
                selectChain.add(discProperty);
            }
            if (this.targetIdBinder == null) {
                throw new IllegalStateException("No Id binding property for " + this.fullName() + ". Probably a missing @OneToOne mapping annotation on this relationship?");
            }
            this.targetIdBinder.buildRawSqlSelectChain(prefix, selectChain);
        } else {
            for (BeanProperty embeddedProp : this.embeddedProps) {
                embeddedProp.buildRawSqlSelectChain(prefix, selectChain);
            }
        }
    }

    @Override
    public boolean hasForeignKey() {
        return this.foreignKey == null || this.primaryKeyJoin || !this.foreignKey.isNoConstraint();
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public boolean isOneToOneExported() {
        return this.oneToOneExported;
    }

    public boolean isOrphanRemoval() {
        return this.orphanRemoval;
    }

    @Override
    public void diff(String prefix, Map<String, ValuePair> map, EntityBean newBean, EntityBean oldBean) {
        String nextPrefix;
        Object oldEmb;
        Object newEmb = newBean == null ? null : this.getValue(newBean);
        Object object = oldEmb = oldBean == null ? null : this.getValue(oldBean);
        if (newEmb == null && oldEmb == null) {
            return;
        }
        String string = nextPrefix = prefix == null ? this.name : prefix + "." + this.name;
        if (this.embedded) {
            BeanDescriptor targetDescriptor = this.targetDescriptor();
            targetDescriptor.diff(nextPrefix, map, (EntityBean)newEmb, (EntityBean)oldEmb);
        } else {
            Object oldId;
            newBean = (EntityBean)newEmb;
            oldBean = (EntityBean)oldEmb;
            BeanDescriptor targetDescriptor = this.targetDescriptor();
            BeanProperty idProperty = targetDescriptor.idProperty();
            Object newId = newBean == null ? null : idProperty.getValue(newBean);
            Object object2 = oldId = oldBean == null ? null : idProperty.getValue(oldBean);
            if (newId != null || oldId != null) {
                idProperty.diffVal(nextPrefix, map, newId, oldId);
            }
        }
    }

    @Override
    public Class<?> targetType() {
        return this.type();
    }

    @Override
    public Object getCacheDataValueOrig(EntityBeanIntercept ebi) {
        return this.cacheDataConvert(ebi.origValue(this.propertyIndex));
    }

    @Override
    public Object getCacheDataValue(EntityBean bean) {
        return this.cacheDataConvert(this.getValue(bean));
    }

    private Object cacheDataConvert(Object ap) {
        if (ap == null) {
            return null;
        }
        if (this.embedded) {
            return this.targetDescriptor.cacheEmbeddedBeanExtract((EntityBean)ap);
        }
        if (this.targetInheritInfo != null) {
            return this.createCacheBeanId(ap);
        }
        return this.targetDescriptor.idProperty().getCacheDataValue((EntityBean)ap);
    }

    private Object createCacheBeanId(Object bean) {
        BeanDescriptor<?> desc = this.targetDescriptor.descOf(bean.getClass());
        Object id = desc.idProperty().getCacheDataValue((EntityBean)bean);
        return new CachedBeanId(desc.discValue(), id);
    }

    @Override
    public String format(Object value) {
        return this.targetDescriptor.idBinder().cacheKey(value);
    }

    @Override
    public void setCacheDataValue(EntityBean bean, Object cacheData, PersistenceContext context) {
        if (cacheData == null) {
            this.setValue(bean, null);
        } else if (this.embedded) {
            this.setValue(bean, this.targetDescriptor.cacheEmbeddedBeanLoad((CachedBeanData)cacheData, context));
        } else if (cacheData instanceof CachedBeanId) {
            this.setValue(bean, this.refInheritBean((CachedBeanId)cacheData, context));
        } else {
            this.setValue(bean, this.refBean(this.targetDescriptor, cacheData, context));
        }
    }

    private Object refInheritBean(CachedBeanId cacheId, PersistenceContext context) {
        InheritInfo rowInheritInfo = this.targetInheritInfo.readType(cacheId.getDiscValue());
        return this.refBean(rowInheritInfo.desc(), cacheId.getId(), context);
    }

    private Object refBean(BeanDescriptor<?> desc, Object id, PersistenceContext context) {
        Object bean;
        if (id instanceof String) {
            id = desc.idProperty().scalarType.parse((String)id);
        }
        if ((bean = desc.contextGet(context, id)) == null) {
            bean = desc.createRef(id, context);
        }
        return bean;
    }

    @Override
    public ScalarDataReader<?> idReader() {
        return this.targetDescriptor.idProperty();
    }

    ScalarType<?> idScalarType() {
        return this.targetDescriptor.idProperty().scalarType;
    }

    @Override
    public Object[] assocIdValues(EntityBean bean) {
        return this.targetDescriptor.idBinder().values(bean);
    }

    @Override
    public String assocIdExpression(String prefix, String operator) {
        return this.targetDescriptor.idBinder().assocExpr(prefix, operator);
    }

    @Override
    public String assocIdInValueExpr(boolean not, int size) {
        return this.targetDescriptor.idBinder().idInValueExpr(not, size);
    }

    @Override
    public String assocIdInExpr(String prefix) {
        return this.targetDescriptor.idBinder().assocInExpr(prefix);
    }

    @Override
    public boolean isAssocId() {
        return !this.embedded;
    }

    @Override
    public boolean isAssocProperty() {
        return !this.embedded;
    }

    public Object createEmbeddedId() {
        return this.targetDescriptor().createEntityBean();
    }

    @Override
    public Object pathGetNested(Object bean) {
        Object value = this.getValueIntercept((EntityBean)bean);
        if (value == null) {
            value = this.targetDescriptor.createEntityBean();
            this.setValueIntercept((EntityBean)bean, value);
        }
        return value;
    }

    public ImportedId importedId() {
        return this.importedId;
    }

    public BeanProperty findMatchImport(String dbCol) {
        return this.importedId.findMatchImport(dbCol);
    }

    private String deriveWhereParentIdSql(boolean inClause) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            String fkColumn = this.exportedProperties[i].getForeignDbColumn();
            if (i > 0) {
                String s = inClause ? "," : " and ";
                sb.append(s);
            }
            sb.append(fkColumn);
            if (inClause) continue;
            sb.append("=? ");
        }
        return sb.toString();
    }

    private ExportedProperty[] createExported() {
        BeanProperty idProp = this.descriptor.idProperty();
        ArrayList<ExportedProperty> list = new ArrayList<ExportedProperty>();
        if (idProp != null && idProp.isEmbedded()) {
            BeanPropertyAssocOne one = (BeanPropertyAssocOne)idProp;
            BeanDescriptor targetDesc = one.targetDescriptor();
            BeanProperty[] emIds = targetDesc.propertiesBaseScalar();
            try {
                for (BeanProperty emId : emIds) {
                    list.add(this.findMatch(true, emId));
                }
            }
            catch (PersistenceException e) {
                e.printStackTrace();
            }
        } else if (idProp != null) {
            list.add(this.findMatch(false, idProp));
        }
        return list.toArray(new ExportedProperty[0]);
    }

    private ExportedProperty findMatch(boolean embeddedProp, BeanProperty prop) {
        return this.findMatch(embeddedProp, prop, prop.dbColumn(), this.tableJoin);
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
        if (!this.isTransient) {
            if (this.primaryKeyExport) {
                this.descriptor.idProperty().appendSelect(ctx, subQuery);
            } else {
                this.localHelp.appendSelect(ctx, subQuery);
            }
        }
    }

    @Override
    public SqlJoinType addJoin(SqlJoinType joinType, String a1, String a2, DbSqlContext ctx) {
        if (this.sqlFormulaJoin != null) {
            ctx.appendFormulaJoin(this.sqlFormulaJoin, joinType, a1);
        }
        return super.addJoin(joinType, a1, a2, ctx);
    }

    @Override
    public void appendFrom(DbSqlContext ctx, SqlJoinType joinType, String manyWhere) {
        if (!this.isTransient && !this.primaryKeyExport) {
            this.localHelp.appendFrom(ctx, joinType);
            if (this.sqlFormulaJoin != null) {
                String alias = ctx.tableAliasManyWhere(manyWhere);
                ctx.appendFormulaJoin(this.sqlFormulaJoin, joinType, alias);
            }
        }
    }

    @Override
    public Object readSet(DataReader reader, EntityBean bean) throws SQLException {
        return this.localHelp.readSet(reader, bean);
    }

    @Override
    public Object read(DataReader reader) throws SQLException {
        return this.localHelp.read(reader);
    }

    @Override
    public Object readSet(DbReadContext ctx, EntityBean bean) throws SQLException {
        return this.localHelp.readSet(ctx, bean);
    }

    @Override
    public Object read(DbReadContext ctx) throws SQLException {
        return this.localHelp.read(ctx);
    }

    @Override
    public void addTenant(SpiQuery<?> query, Object tenantId) {
        query.where().eq(this.name, this.targetDescriptor.createRef(tenantId, null));
    }

    @Override
    public void setTenantValue(EntityBean entityBean, Object tenantId) {
        this.setValue(entityBean, this.targetDescriptor.createRef(tenantId, null));
    }

    @Override
    public void setValue(EntityBean bean, Object value) {
        super.setValue(bean, value);
        if (!this.id && this.embedded && value instanceof EntityBean) {
            this.setEmbeddedOwner(bean, value);
        }
    }

    @Override
    public void setValueIntercept(EntityBean bean, Object value) {
        super.setValueIntercept(bean, value);
        if (!this.id && this.embedded && value instanceof EntityBean) {
            this.setEmbeddedOwner(bean, value);
        }
    }

    void setAllLoadedEmbedded(EntityBean owner) {
        Object emb = this.getValue(owner);
        if (emb != null) {
            EntityBean embeddedBean = (EntityBean)emb;
            this.targetDescriptor.setAllLoaded(embeddedBean);
            if (!this.id) {
                embeddedBean._ebean_getIntercept().setEmbeddedOwner(owner, this.propertyIndex);
            }
        }
    }

    private void setEmbeddedOwner(EntityBean bean, Object value) {
        ((EntityBean)value)._ebean_getIntercept().setEmbeddedOwner(bean, this.propertyIndex);
    }

    @Override
    public void loadIgnore(DbReadContext ctx) {
        this.localHelp.loadIgnore(ctx);
    }

    @Override
    public void load(SqlBeanLoad sqlBeanLoad) {
        Object dbVal = sqlBeanLoad.load(this);
        if (this.embedded && sqlBeanLoad.isLazyLoad() && dbVal instanceof EntityBean) {
            ((EntityBean)dbVal)._ebean_getIntercept().setLoaded();
        }
    }

    private AssocOneHelp createHelp(boolean embedded, boolean oneToOneExported, String embeddedPrefix) {
        if (embedded) {
            return new AssocOneHelpEmbedded(this);
        }
        if (oneToOneExported) {
            return new AssocOneHelpRefExported(this);
        }
        if (this.targetInheritInfo != null) {
            return new AssocOneHelpRefInherit(this);
        }
        return new AssocOneHelpRefSimple(this, embeddedPrefix);
    }

    @Override
    public void jsonWriteForInsert(SpiJsonWriter writeJson, EntityBean bean) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        this.jsonWriteBean(writeJson, this.getValue(bean));
    }

    @Override
    public void jsonWriteValue(SpiJsonWriter writeJson, Object value) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        this.jsonWriteBean(writeJson, value);
    }

    private void jsonWriteBean(SpiJsonWriter writeJson, Object value) throws IOException {
        if (value instanceof EntityBean) {
            if (this.embedded) {
                writeJson.writeFieldName(this.name);
                BeanDescriptor<?> refDesc = this.descriptor.descriptor(value.getClass());
                refDesc.jsonWriteForInsert(writeJson, (EntityBean)value);
            } else {
                this.jsonWriteTargetId(writeJson, (EntityBean)value);
            }
        }
    }

    private void jsonWriteTargetId(SpiJsonWriter writeJson, EntityBean childBean) throws IOException {
        BeanProperty idProperty = this.targetDescriptor.idProperty();
        if (idProperty != null) {
            writeJson.writeStartObject(this.name);
            idProperty.jsonWriteForInsert(writeJson, childBean);
            writeJson.writeEndObject();
        }
    }

    @Override
    public void jsonWrite(SpiJsonWriter writeJson, EntityBean bean) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        Object value = this.getValueIntercept(bean);
        if (value == null) {
            writeJson.writeNullField(this.name);
        } else if (!writeJson.parentBean(value) && value instanceof EntityBean) {
            writeJson.beginAssocOne(this.name, bean);
            BeanDescriptor<?> refDesc = this.descriptor.descriptor(value.getClass());
            refDesc.jsonWrite(writeJson, (EntityBean)value, this.name);
            writeJson.endAssocOne();
        }
    }

    @Override
    public void jsonRead(SpiJsonReader readJson, EntityBean bean) throws IOException {
        if (this.jsonDeserialize && this.targetDescriptor != null) {
            Object target = readJson.update() ? this.getValue(bean) : null;
            Object assocBean = this.targetDescriptor.jsonRead(readJson, this.name, target);
            if (readJson.update()) {
                this.setValueIntercept(bean, assocBean);
            } else {
                this.setValue(bean, assocBean);
            }
        }
    }

    @Override
    public Object jsonRead(SpiJsonReader readJson) throws IOException {
        return this.targetDescriptor.jsonRead(readJson, this.name, null);
    }

    public boolean isReference(Object detailBean) {
        EntityBean eb = (EntityBean)detailBean;
        return this.targetDescriptor.isReference(eb._ebean_getIntercept());
    }

    public void setParentBeanToChild(EntityBean parent, EntityBean child) {
        BeanProperty beanProperty;
        if (this.primaryKeyExport) {
            Object parentId = this.descriptor.getId(parent);
            this.targetDescriptor.convertSetId(parentId, child);
        }
        if (this.mappedBy != null && (beanProperty = this.targetDescriptor.beanProperty(this.mappedBy)) != null && beanProperty.getValue(child) == null) {
            beanProperty.setValue(child, parent);
        }
    }

    public boolean hasCircularImportedId(BeanDescriptor<?> sourceDesc) {
        return this.targetDescriptor.hasCircularImportedIdTo(sourceDesc);
    }
}

