/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.core.type.InputStreamInfo;
import java.nio.charset.StandardCharsets;
import org.postgresql.util.PGobject;

public interface BindMaxLength {
    public static BindMaxLength ofUtf8() {
        return new UTF8();
    }

    public static BindMaxLength ofStandard() {
        return new Standard();
    }

    public long length(int var1, Object var2);

    public static final class UTF8
    implements BindMaxLength {
        @Override
        public long length(int dbLength, Object obj) {
            if (obj == null) {
                return -1L;
            }
            if (obj instanceof String) {
                String s = (String)obj;
                return UTF8.utf8String(dbLength, s);
            }
            if (obj instanceof byte[]) {
                return ((byte[])obj).length;
            }
            if (obj instanceof InputStreamInfo) {
                return ((InputStreamInfo)obj).length();
            }
            if ("org.postgresql.util.PGobject".equals(obj.getClass().getCanonicalName())) {
                String value = ((PGobject)obj).getValue();
                return value == null ? -1L : (long)UTF8.utf8String(dbLength, value);
            }
            return -1L;
        }

        private static int utf8String(int dbLength, String s) {
            int stringLength = s.length();
            if (stringLength > dbLength) {
                return stringLength;
            }
            if (stringLength * 4 <= dbLength) {
                return -1;
            }
            return s.getBytes(StandardCharsets.UTF_8).length;
        }
    }

    public static final class Standard
    implements BindMaxLength {
        @Override
        public long length(int dbLength, Object obj) {
            if (obj == null) {
                return -1L;
            }
            if (obj instanceof String) {
                return ((String)obj).length();
            }
            if (obj instanceof byte[]) {
                return ((byte[])obj).length;
            }
            if (obj instanceof InputStreamInfo) {
                return ((InputStreamInfo)obj).length();
            }
            if ("org.postgresql.util.PGobject".equals(obj.getClass().getCanonicalName())) {
                String value = ((PGobject)obj).getValue();
                return value == null ? -1L : (long)value.length();
            }
            return -1L;
        }
    }
}

