/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;

final class DetermineAggPath {
    DetermineAggPath() {
    }

    static String manyPath(String aggregation, DeployBeanDescriptor<?> desc) {
        Path path = DetermineAggPath.paths(aggregation);
        if (path.length() == 1) {
            return null;
        }
        return path.getManyPath(desc);
    }

    static Path paths(String aggregation) {
        String aggPath = DetermineAggPath.path(aggregation);
        return new Path(aggPath.split("\\."), aggregation);
    }

    static String path(String aggregation) {
        int start = aggregation.indexOf(40);
        if (start == -1) {
            throw new IllegalArgumentException("Aggregation formula [" + aggregation + "] is expected to have a '(' ?");
        }
        for (int i = start + 1; i < aggregation.length(); ++i) {
            char ch = aggregation.charAt(i);
            if (DetermineAggPath.isNamePart(ch)) continue;
            return aggregation.substring(start + 1, i);
        }
        throw new IllegalArgumentException("Could not find path in aggregation formula " + aggregation);
    }

    private static boolean isNamePart(char ch) {
        return ch == '.' || Character.isJavaIdentifierPart(ch);
    }

    static class Path {
        final String aggregation;
        final String[] paths;

        Path(String[] paths, String aggregation) {
            this.paths = paths;
            this.aggregation = aggregation;
        }

        int length() {
            return this.paths.length;
        }

        String path(int pos) {
            if (pos == 0) {
                return this.paths[0];
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < pos; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(this.paths[i]);
            }
            return sb.toString();
        }

        String getManyPath(DeployBeanDescriptor<?> desc) {
            int pos = 0;
            while (true) {
                String path;
                DeployBeanProperty details;
                if ((details = desc.getBeanProperty(path = this.paths[pos])) instanceof DeployBeanPropertyAssocMany) {
                    return this.path(pos);
                }
                if (!(details instanceof DeployBeanPropertyAssocOne)) break;
                DeployBeanPropertyAssocOne one = (DeployBeanPropertyAssocOne)details;
                desc = one.getTargetDeploy();
                ++pos;
            }
            throw new IllegalArgumentException("Can not find path to many in aggregation formula " + this.aggregation);
        }
    }
}

