/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.util.SplitName;
import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.PropertyForeignKey;
import io.ebeaninternal.server.deploy.TableJoinColumn;
import io.ebeaninternal.server.deploy.meta.DeployTableJoin;
import io.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;
import io.ebeaninternal.server.query.SqlJoinType;

public final class TableJoin {
    private final String table;
    private final SqlJoinType type;
    private final InheritInfo inheritInfo;
    private final TableJoinColumn[] columns;
    private final int queryHash;
    private final PropertyForeignKey foreignKey;
    private final String extraWhere;

    public TableJoin(DeployTableJoin deploy) {
        this(deploy, null);
    }

    public TableJoin(DeployTableJoin deploy, PropertyForeignKey foreignKey) {
        this.foreignKey = foreignKey;
        this.extraWhere = deploy.getExtraWhere();
        this.table = InternString.intern(deploy.getTable());
        this.type = deploy.getType();
        this.inheritInfo = deploy.getInheritInfo();
        DeployTableJoinColumn[] deployCols = deploy.columns();
        this.columns = new TableJoinColumn[deployCols.length];
        for (int i = 0; i < deployCols.length; ++i) {
            this.columns[i] = new TableJoinColumn(deployCols[i]);
        }
        this.queryHash = this.calcQueryHash();
    }

    private TableJoin(TableJoin source, String overrideColumn) {
        this.foreignKey = null;
        this.extraWhere = source.extraWhere;
        this.table = source.table;
        this.type = source.type;
        this.inheritInfo = source.inheritInfo;
        this.columns = new TableJoinColumn[1];
        this.columns[0] = source.columns[0].withOverrideColumn(overrideColumn);
        this.queryHash = this.calcQueryHash();
    }

    private int calcQueryHash() {
        int hc = this.type.hashCode();
        hc = hc * 92821 + (this.table == null ? 0 : this.table.hashCode());
        for (TableJoinColumn column : this.columns) {
            hc = hc * 92821 + column.queryHash();
        }
        return hc;
    }

    public int hashCode() {
        return this.queryHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableJoin that = (TableJoin)o;
        if (!this.table.equals(that.table)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.columns.length != that.columns.length) {
            return false;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i].equals(that.columns[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append((Object)this.type).append(' ').append(this.table).append(' ');
        for (TableJoinColumn column : this.columns) {
            sb.append(column).append(' ');
        }
        return sb.toString();
    }

    public PropertyForeignKey getForeignKey() {
        return this.foreignKey;
    }

    public TableJoinColumn[] columns() {
        return this.columns;
    }

    public String getTable() {
        return this.table;
    }

    public void addJoin(SqlJoinType joinType, String prefix, DbSqlContext ctx, String predicate) {
        String[] names = SplitName.split((String)prefix);
        String a1 = ctx.tableAlias(names[0]);
        String a2 = ctx.tableAlias(prefix);
        this.addJoin(joinType, a1, a2, ctx);
        ctx.append(" and ").append(a2).append(predicate);
    }

    public SqlJoinType addJoin(SqlJoinType joinType, String prefix, DbSqlContext ctx) {
        String[] names = SplitName.split((String)prefix);
        String a1 = ctx.tableAlias(names[0]);
        String a2 = ctx.tableAlias(prefix);
        return this.addJoin(joinType, a1, a2, ctx);
    }

    public SqlJoinType addJoin(SqlJoinType joinType, String a1, String a2, DbSqlContext ctx) {
        String joinLiteral = joinType.literal(this.type);
        ctx.addJoin(joinLiteral, this.table, this.columns(), a1, a2, this.extraWhere);
        return joinType.autoToOuter(this.type);
    }

    public void addJoin(String a1, String a2, StringBuilder sb) {
        for (int i = 0; i < this.columns.length; ++i) {
            TableJoinColumn pair = this.columns[i];
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(a1).append('.').append(pair.getLocalDbColumn());
            sb.append(" = ");
            sb.append(a2).append('.').append(pair.getForeignDbColumn());
        }
    }

    TableJoin withOverrideColumn(String overrideColumn) {
        if (this.columns.length == 1 && overrideColumn != null && !overrideColumn.equals(this.columns[0].getLocalDbColumn())) {
            return new TableJoin(this, overrideColumn);
        }
        return this;
    }
}

