/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.meta;

import io.ebean.annotation.DocCode;
import io.ebean.annotation.DocProperty;
import io.ebean.annotation.DocSortable;
import io.ebean.annotation.Formula;
import io.ebean.annotation.MutationDetection;
import io.ebean.annotation.Platform;
import io.ebean.annotation.SoftDelete;
import io.ebean.annotation.WhenCreated;
import io.ebean.annotation.WhenModified;
import io.ebean.annotation.Where;
import io.ebean.annotation.WhoCreated;
import io.ebean.annotation.WhoModified;
import io.ebean.config.ScalarTypeConverter;
import io.ebean.config.dbplatform.DbDefaultValue;
import io.ebean.config.dbplatform.DbEncrypt;
import io.ebean.config.dbplatform.DbEncryptFunction;
import io.ebean.core.type.ScalarType;
import io.ebean.util.AnnotationUtil;
import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BindMaxLength;
import io.ebeaninternal.server.deploy.DbMigrationInfo;
import io.ebeaninternal.server.deploy.DeployDocPropertyOptions;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import io.ebeaninternal.server.deploy.meta.BeanPropertyElementSetter;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployTableJoin;
import io.ebeaninternal.server.properties.BeanPropertyGetter;
import io.ebeaninternal.server.properties.BeanPropertySetter;
import io.ebeaninternal.server.type.ScalarTypeWrapper;
import io.ebeanservice.docstore.api.mapping.DocPropertyOptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EmbeddedId;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Version;
import org.jspecify.annotations.Nullable;

public class DeployBeanProperty {
    private static final int ID_ORDER = 1000000;
    private static final int UNIDIRECTIONAL_ORDER = 100000;
    private static final int AUDITCOLUMN_ORDER = -1000000;
    private static final int VERSIONCOLUMN_ORDER = -1000000;
    private static final Set<Class<?>> PRIMITIVE_NUMBER_TYPES = new HashSet();
    private boolean id;
    boolean importedPrimaryKey;
    private boolean embedded;
    private boolean versionColumn;
    private boolean fetchEager = true;
    private boolean nullable = true;
    private boolean unique;
    private boolean discriminator;
    private int dbLength;
    private int dbScale;
    private String dbColumnDefn;
    private boolean isTransient;
    private boolean localEncrypted;
    private boolean jsonSerialize = true;
    private boolean jsonDeserialize = true;
    private MutationDetection mutationDetection;
    private boolean dbEncrypted;
    private DbEncryptFunction dbEncryptFunction;
    private int dbEncryptedType;
    private String dbBind = "?";
    private boolean dbRead;
    private boolean dbInsertable;
    private boolean dbUpdateable;
    private DeployTableJoin secondaryTableJoin;
    private String secondaryTableJoinPrefix;
    private String secondaryTable;
    private Class<?> owningType;
    private boolean lob;
    private boolean naturalKey;
    private String name;
    private Field field;
    private final Class<?> propertyType;
    private final Type genericType;
    private ScalarType<?> scalarType;
    private String dbColumn;
    private String aggregationPrefix;
    private String aggregation;
    private String aggregationParsed;
    private String sqlFormulaSelect;
    private String sqlFormulaJoin;
    private int dbType;
    private final DeployDocPropertyOptions docMapping = new DeployDocPropertyOptions();
    private int propertyIndex;
    private BeanPropertyGetter getter;
    private BeanPropertySetter setter;
    private GeneratedProperty generatedProperty;
    final DeployBeanDescriptor<?> desc;
    private boolean undirectionalShadow;
    private boolean elementProperty;
    private int sortOrder;
    private boolean excludedFromHistory;
    private boolean tenantId;
    private boolean draft;
    private boolean draftOnly;
    private boolean draftDirty;
    private boolean draftReset;
    private boolean softDelete;
    private boolean unmappedJson;
    private String dbComment;
    private String dbColumnDefault;
    private List<DbMigrationInfo> dbMigrationInfos;
    private Set<Annotation> metaAnnotations;

    public DeployBeanProperty(DeployBeanDescriptor<?> desc, Class<?> propertyType, ScalarType<?> scalarType, ScalarTypeConverter<?, ?> typeConverter) {
        this.desc = desc;
        this.propertyType = propertyType;
        this.genericType = null;
        this.scalarType = this.wrapScalarType(propertyType, scalarType, typeConverter);
        this.dbType = scalarType == null ? 0 : scalarType.jdbcType();
    }

    public DeployBeanProperty(DeployBeanDescriptor<?> desc, Class<?> propertyType, Type genericType) {
        this.desc = desc;
        this.propertyType = propertyType;
        this.genericType = genericType;
    }

    private ScalarType<?> wrapScalarType(Class<?> propertyType, ScalarType<?> scalarType, ScalarTypeConverter<?, ?> typeConverter) {
        if (typeConverter == null) {
            return scalarType;
        }
        return new ScalarTypeWrapper(propertyType, scalarType, typeConverter);
    }

    public int getSortOverride() {
        if (this.field == null) {
            return 0;
        }
        if (AnnotationUtil.get((AnnotatedElement)this.field, Id.class) != null) {
            return 1000000;
        }
        if (AnnotationUtil.get((AnnotatedElement)this.field, EmbeddedId.class) != null) {
            return 1000000;
        }
        if (this.undirectionalShadow) {
            return 100000;
        }
        if (this.isAuditProperty()) {
            return -1000000;
        }
        if (AnnotationUtil.get((AnnotatedElement)this.field, Version.class) != null) {
            return -1000000;
        }
        if (AnnotationUtil.get((AnnotatedElement)this.field, SoftDelete.class) != null) {
            return -1000000;
        }
        return 0;
    }

    private boolean isAuditProperty() {
        return AnnotationUtil.has((AnnotatedElement)this.field, WhenCreated.class) || AnnotationUtil.has((AnnotatedElement)this.field, WhenModified.class) || AnnotationUtil.has((AnnotatedElement)this.field, WhoModified.class) || AnnotationUtil.has((AnnotatedElement)this.field, WhoCreated.class);
    }

    public DeployBeanDescriptor<?> getDesc() {
        return this.desc;
    }

    public int getDbLength() {
        if (this.dbLength == 0 && this.scalarType != null) {
            return this.scalarType.length();
        }
        return this.dbLength;
    }

    public boolean isJsonSerialize() {
        return this.jsonSerialize;
    }

    public void setJsonSerialize(boolean jsonSerialize) {
        this.jsonSerialize = jsonSerialize;
    }

    public boolean isJsonDeserialize() {
        return this.jsonDeserialize;
    }

    public void setJsonDeserialize(boolean jsonDeserialize) {
        this.jsonDeserialize = jsonDeserialize;
    }

    public MutationDetection getMutationDetection() {
        return this.mutationDetection;
    }

    public void setMutationDetection(MutationDetection dirtyDetection) {
        this.mutationDetection = dirtyDetection;
    }

    int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean isUndirectionalShadow() {
        return this.undirectionalShadow;
    }

    public void setUndirectionalShadow() {
        this.undirectionalShadow = true;
    }

    void setDiscriminator() {
        this.discriminator = true;
    }

    public boolean isDiscriminator() {
        return this.discriminator;
    }

    public boolean isLocalEncrypted() {
        return this.localEncrypted;
    }

    public void setLocalEncrypted() {
        this.localEncrypted = true;
    }

    public void setDbLength(int dbLength) {
        this.dbLength = dbLength;
    }

    public int getDbScale() {
        return this.dbScale;
    }

    public void setDbScale(int dbScale) {
        this.dbScale = dbScale;
    }

    public String getDbColumnDefn() {
        return this.dbColumnDefn;
    }

    public void setDbColumnDefn(String dbColumnDefn) {
        this.dbColumnDefn = dbColumnDefn == null || dbColumnDefn.trim().isEmpty() ? null : InternString.intern(dbColumnDefn);
    }

    public ScalarType<?> getScalarType() {
        return this.scalarType;
    }

    public void setScalarType(ScalarType<?> scalarType) {
        this.scalarType = scalarType;
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }

    public void setPropertyIndex(int propertyIndex) {
        this.propertyIndex = propertyIndex;
    }

    public BeanPropertyGetter getGetter() {
        return this.getter;
    }

    public BeanPropertySetter getSetter() {
        if (this.elementProperty) {
            return new BeanPropertyElementSetter(this.sortOrder);
        }
        return this.setter;
    }

    public void setOwningType(Class<?> owningType) {
        this.owningType = owningType;
    }

    public Class<?> getOwningType() {
        return this.owningType;
    }

    public boolean isLocal() {
        return this.owningType == null || this.owningType.equals(this.desc.getBeanType());
    }

    public void setGetter(BeanPropertyGetter getter) {
        this.getter = getter;
    }

    public void setSetter(BeanPropertySetter setter) {
        this.setter = setter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = InternString.intern(name);
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public boolean isNaturalKey() {
        return this.naturalKey;
    }

    void setNaturalKey() {
        this.naturalKey = true;
    }

    public GeneratedProperty getGeneratedProperty() {
        return this.generatedProperty;
    }

    public void setGeneratedProperty(GeneratedProperty generatedValue) {
        this.generatedProperty = generatedValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean isNullable) {
        this.nullable = isNullable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn() {
        this.versionColumn = true;
    }

    public boolean isFetchEager() {
        return this.fetchEager;
    }

    public void setFetchType(FetchType fetchType) {
        this.fetchEager = FetchType.EAGER == fetchType;
    }

    public String getSqlFormulaSelect() {
        return this.sqlFormulaSelect;
    }

    public String getSqlFormulaJoin() {
        return this.sqlFormulaJoin;
    }

    public void setSqlFormula(String formulaSelect, String formulaJoin) {
        this.sqlFormulaSelect = formulaSelect;
        this.sqlFormulaJoin = formulaJoin.isEmpty() ? null : formulaJoin;
        this.dbRead = true;
        this.dbInsertable = false;
        this.dbUpdateable = false;
    }

    public void setImportedPrimaryKey() {
        this.importedPrimaryKey = true;
    }

    public void setImportedPrimaryKeyColumn(DeployBeanProperty primaryKey) {
        this.importedPrimaryKey = true;
    }

    public boolean isAggregation() {
        return this.aggregation != null;
    }

    public String getRawAggregation() {
        return this.aggregation;
    }

    public String parseAggregation() {
        if (this.aggregation != null) {
            int pos = this.aggregation.indexOf(40);
            if (pos > -1) {
                String maybePropertyName = this.aggregation.substring(pos + 1, this.aggregation.length() - 1);
                if (this.name.equals(maybePropertyName)) {
                    return this.aggregationJoin(pos, this.dbColumn);
                }
                DeployBeanProperty other = this.desc.getBeanProperty(maybePropertyName);
                if (other != null) {
                    return this.aggregationJoin(pos, other.getDbColumnRaw());
                }
            }
            this.aggregationParsed = this.desc.parse(this.aggregation);
        }
        return this.aggregationParsed;
    }

    private String aggregationJoin(int pos, String dbColumn) {
        String p0 = this.aggregation.substring(0, pos + 1);
        this.aggregationParsed = p0 + "${ta}." + dbColumn + this.aggregation.substring(this.aggregation.length() - 1);
        return this.aggregationParsed;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
        this.dbRead = true;
        this.dbInsertable = false;
        this.dbUpdateable = false;
    }

    public void setAggregationPrefix(String prefix) {
        this.aggregationPrefix = prefix;
    }

    public String getElPrefix() {
        if (this.aggregation != null) {
            return this.aggregationPrefix;
        }
        return this.secondaryTableJoinPrefix;
    }

    public String getElPlaceHolder() {
        if (this.aggregation != null) {
            return this.aggregationParsed;
        }
        if (this.sqlFormulaSelect != null) {
            return this.sqlFormulaSelect;
        }
        if (this.secondaryTableJoinPrefix != null) {
            return "${" + this.secondaryTableJoinPrefix + "}" + this.getDbColumn();
        }
        return "${}" + this.getDbColumn();
    }

    public String getDbColumn() {
        if (this.sqlFormulaSelect != null) {
            return this.sqlFormulaSelect;
        }
        if (this.aggregation != null) {
            return this.aggregationParsed == null ? this.dbColumn : this.aggregationParsed;
        }
        return this.dbColumn;
    }

    private String getDbColumnRaw() {
        return this.dbColumn;
    }

    public void setDbColumn(String dbColumn) {
        this.dbColumn = InternString.intern(dbColumn);
    }

    public int getDbType() {
        return this.dbType;
    }

    public void setDbType(int dbType) {
        this.dbType = dbType;
        this.lob = BeanProperty.isLobType(dbType);
    }

    public boolean isLob() {
        return this.lob;
    }

    boolean isDbNumberType() {
        return this.isNumericType(this.dbType);
    }

    private boolean isNumericType(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isSecondaryTable() {
        return this.secondaryTable != null;
    }

    public String getSecondaryTable() {
        return this.secondaryTable;
    }

    public void setSecondaryTable(String secondaryTable) {
        this.secondaryTable = secondaryTable;
        this.dbInsertable = false;
        this.dbUpdateable = false;
    }

    public String getSecondaryTableJoinPrefix() {
        return this.secondaryTableJoinPrefix;
    }

    public DeployTableJoin getSecondaryTableJoin() {
        return this.secondaryTableJoin;
    }

    public void setSecondaryTableJoin(DeployTableJoin secondaryTableJoin, String prefix) {
        this.secondaryTableJoin = secondaryTableJoin;
        this.secondaryTableJoinPrefix = prefix;
    }

    public String getDbBind() {
        return this.dbBind;
    }

    public boolean isDbEncrypted() {
        return this.dbEncrypted;
    }

    public DbEncryptFunction getDbEncryptFunction() {
        return this.dbEncryptFunction;
    }

    public void setDbEncryptFunction(DbEncryptFunction dbEncryptFunction, DbEncrypt dbEncrypt, int dbLen) {
        this.dbEncryptFunction = dbEncryptFunction;
        this.dbEncrypted = true;
        this.dbBind = dbEncryptFunction.getEncryptBindSql();
        int n = this.dbEncryptedType = this.isLob() ? 2004 : dbEncrypt.getEncryptDbType();
        if (dbLen > 0) {
            this.setDbLength(dbLen);
        }
    }

    public int getDbEncryptedType() {
        return this.dbEncryptedType;
    }

    public boolean isDbRead() {
        return this.dbRead;
    }

    public void setDbRead(boolean isDBRead) {
        this.dbRead = isDBRead;
    }

    public boolean isDbInsertable() {
        return this.dbInsertable;
    }

    public void setDbInsertable(boolean insertable) {
        this.dbInsertable = insertable;
    }

    public boolean isDbUpdateable() {
        return this.dbUpdateable;
    }

    public void setDbUpdateable(boolean updateable) {
        this.dbUpdateable = updateable;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient() {
        this.isTransient = true;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public boolean isImportedPrimaryKey() {
        return this.importedPrimaryKey;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId() {
        this.id = true;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded() {
        this.embedded = true;
    }

    public String toString() {
        return this.desc.getFullName() + "." + this.name;
    }

    public boolean isExcludedFromHistory() {
        return this.excludedFromHistory;
    }

    public void setExcludedFromHistory() {
        this.excludedFromHistory = true;
    }

    public void setDraft() {
        this.draft = true;
        this.isTransient = true;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraftOnly() {
        this.draftOnly = true;
    }

    public boolean isDraftOnly() {
        return this.draftOnly;
    }

    public void setDraftDirty() {
        this.draftOnly = true;
        this.draftDirty = true;
        this.nullable = false;
    }

    public boolean isDraftDirty() {
        return this.draftDirty;
    }

    public void setDraftReset() {
        this.draftReset = true;
    }

    public boolean isDraftReset() {
        return this.draftReset;
    }

    public void checkPrimitiveBoolean() {
        if (Boolean.TYPE.equals(this.propertyType) && !this.softDelete) {
            this.nullable = false;
            if (this.dbColumnDefault == null) {
                this.dbColumnDefault = "false";
            }
        } else if (!this.id && !this.versionColumn && PRIMITIVE_NUMBER_TYPES.contains(this.propertyType)) {
            this.nullable = false;
        }
    }

    public void setSoftDelete() {
        this.softDelete = true;
        this.nullable = false;
        this.dbColumnDefault = "false";
    }

    public boolean isSoftDelete() {
        return this.softDelete;
    }

    public void setUnmappedJson() {
        this.unmappedJson = true;
        this.isTransient = true;
    }

    public boolean isUnmappedJson() {
        return this.unmappedJson;
    }

    public void setDbComment(String dbComment) {
        this.dbComment = dbComment;
    }

    public String getDbComment() {
        return this.dbComment;
    }

    public void setDocProperty(DocProperty docProperty) {
        this.docMapping.setDocProperty(docProperty);
    }

    public void setDocSortable(DocSortable docSortable) {
        this.docMapping.setDocSortable(docSortable);
    }

    public void setDocCode(DocCode docCode) {
        this.docMapping.setDocCode(docCode);
    }

    public DocPropertyOptions getDocPropertyOptions() {
        return this.docMapping.create();
    }

    public String getDbColumnDefaultSqlLiteral() {
        return DbDefaultValue.toSqlLiteral((String)this.dbColumnDefault, this.propertyType, (int)this.dbType);
    }

    public void setDbColumnDefault(String dbColumnDefault) {
        this.dbColumnDefault = dbColumnDefault;
    }

    public void setTenantId() {
        this.tenantId = true;
        this.nullable = false;
        this.dbInsertable = true;
        this.dbUpdateable = false;
    }

    public boolean isTenantId() {
        return this.tenantId;
    }

    public boolean isIdClass() {
        return this.desc.isIdClass();
    }

    public void addDbMigrationInfo(DbMigrationInfo info) {
        if (this.dbMigrationInfos == null) {
            this.dbMigrationInfos = new ArrayList<DbMigrationInfo>();
        }
        this.dbMigrationInfos.add(info);
    }

    public List<DbMigrationInfo> getDbMigrationInfos() {
        return this.dbMigrationInfos;
    }

    public void setElementProperty() {
        this.elementProperty = true;
    }

    public void initMetaAnnotations(Set<Class<?>> metaAnnotationsFilter) {
        this.metaAnnotations = AnnotationUtil.metaFindAllFor((AnnotatedElement)this.field, metaAnnotationsFilter);
    }

    public <A extends Annotation> A getMetaAnnotation(Class<A> annotationType) {
        for (Annotation ann : this.metaAnnotations) {
            if (ann.annotationType() != annotationType) continue;
            return (A)ann;
        }
        return null;
    }

    public <A extends Annotation> List<A> getMetaAnnotations(Class<A> annotationType) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation ann : this.metaAnnotations) {
            if (ann.annotationType() != annotationType) continue;
            result.add(ann);
        }
        return result;
    }

    public Formula getMetaAnnotationFormula(Platform platform) {
        Formula fallback = null;
        for (Annotation ann : this.metaAnnotations) {
            if (ann.annotationType() == Formula.class) {
                Formula formula = (Formula)ann;
                Platform[] platforms = formula.platforms();
                if (platforms.length == 0) {
                    fallback = formula;
                    continue;
                }
                if (!this.matchPlatform(platforms, platform)) continue;
                return formula;
            }
            if (ann.annotationType() != Formula.List.class) continue;
            Formula.List formulaList = (Formula.List)ann;
            for (Formula formula : formulaList.value()) {
                Platform[] platforms = formula.platforms();
                if (platforms.length == 0) {
                    fallback = formula;
                    continue;
                }
                if (!this.matchPlatform(platforms, platform)) continue;
                return formula;
            }
        }
        return fallback;
    }

    public Where getMetaAnnotationWhere(Platform platform) {
        Where fallback = null;
        for (Annotation ann : this.metaAnnotations) {
            if (ann.annotationType() == Where.class) {
                Where where = (Where)ann;
                Platform[] platforms = where.platforms();
                if (platforms.length == 0) {
                    fallback = where;
                    continue;
                }
                if (!this.matchPlatform(where.platforms(), platform)) continue;
                return where;
            }
            if (ann.annotationType() != Where.List.class) continue;
            Where.List whereList = (Where.List)ann;
            for (Where where : whereList.value()) {
                Platform[] platforms = where.platforms();
                if (platforms.length == 0) {
                    fallback = where;
                    continue;
                }
                if (!this.matchPlatform(where.platforms(), platform)) continue;
                return where;
            }
        }
        return fallback;
    }

    private boolean matchPlatform(Platform[] platforms, Platform match) {
        for (Platform platform : platforms) {
            if (platform != match && platform != match.base()) continue;
            return true;
        }
        return false;
    }

    boolean isJsonMapper() {
        return this.scalarType != null && this.scalarType.jsonMapper();
    }

    boolean isJsonType() {
        return this.mutationDetection != null;
    }

    public @Nullable BindMaxLength bindMaxLength() {
        if (this.dbLength == 0) {
            return null;
        }
        switch (this.dbType) {
            case 12: 
            case 2004: 
            case 5001: {
                return this.desc.bindMaxLength();
            }
        }
        return null;
    }

    static {
        PRIMITIVE_NUMBER_TYPES.add(Float.TYPE);
        PRIMITIVE_NUMBER_TYPES.add(Double.TYPE);
        PRIMITIVE_NUMBER_TYPES.add(Long.TYPE);
        PRIMITIVE_NUMBER_TYPES.add(Integer.TYPE);
        PRIMITIVE_NUMBER_TYPES.add(Short.TYPE);
    }
}

