/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebean.annotation.Cache;
import io.ebean.annotation.DbComment;
import io.ebean.annotation.DbPartition;
import io.ebean.annotation.DocStore;
import io.ebean.annotation.Draftable;
import io.ebean.annotation.DraftableElement;
import io.ebean.annotation.History;
import io.ebean.annotation.Identity;
import io.ebean.annotation.Index;
import io.ebean.annotation.InvalidateQueryCache;
import io.ebean.annotation.ReadAudit;
import io.ebean.annotation.StorageEngine;
import io.ebean.annotation.Tablespace;
import io.ebean.annotation.View;
import io.ebean.config.TableName;
import io.ebean.util.AnnotationUtil;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.IndexDefinition;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.PartitionMeta;
import io.ebeaninternal.server.deploy.TablespaceMeta;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.parse.AnnotationParser;
import io.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import io.ebeaninternal.server.deploy.parse.ReadAnnotationConfig;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.IdClass;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

final class AnnotationClass
extends AnnotationParser {
    private final String asOfViewSuffix;
    private final String versionsBetweenSuffix;
    private final boolean disableL2Cache;

    AnnotationClass(DeployBeanInfo<?> info, ReadAnnotationConfig readConfig) {
        super(info, readConfig);
        this.asOfViewSuffix = readConfig.getAsOfViewSuffix();
        this.versionsBetweenSuffix = readConfig.getVersionsBetweenSuffix();
        this.disableL2Cache = readConfig.isDisableL2Cache();
    }

    void parseAttributeOverride() {
        Class cls = this.descriptor.getBeanType();
        AttributeOverride override = (AttributeOverride)AnnotationUtil.typeGet(cls, AttributeOverride.class);
        if (override != null) {
            String propertyName = override.name();
            Column column = override.column();
            DeployBeanProperty beanProperty = this.descriptor.getBeanProperty(propertyName);
            if (beanProperty == null) {
                CoreLog.log.log(System.Logger.Level.ERROR, "AttributeOverride property [" + propertyName + "] not found on " + this.descriptor.getFullName());
            } else {
                this.readColumn(column, beanProperty);
            }
        }
    }

    @Override
    public void parse() {
        this.read(this.descriptor.getBeanType());
        this.setTableName();
    }

    private void setTableName() {
        if (this.descriptor.isBaseTableType()) {
            Class<Object> beanType = this.descriptor.getBeanType();
            InheritInfo inheritInfo = this.descriptor.getInheritInfo();
            if (inheritInfo != null) {
                beanType = inheritInfo.getRoot().getType();
            }
            TableName tableName = this.namingConvention.getTableName(beanType);
            this.descriptor.setBaseTable(tableName, this.asOfViewSuffix, this.versionsBetweenSuffix);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void read(Class<?> cls) {
        DbComment comment;
        History history;
        ReadAudit readAudit;
        DraftableElement draftableElement;
        Draftable draftable;
        Tablespace tablespace;
        DbPartition partition;
        StorageEngine storage;
        Table table;
        View view;
        Embeddable embeddable;
        IdClass idClass;
        Identity identity;
        Entity entity;
        DocStore docStore = (DocStore)AnnotationUtil.typeGet(cls, DocStore.class);
        if (docStore != null) {
            this.descriptor.readDocStore(docStore);
            this.descriptor.setEntityType(BeanDescriptor.EntityType.DOC);
            this.descriptor.setName(cls.getSimpleName());
        }
        if ((entity = (Entity)AnnotationUtil.typeGet(cls, Entity.class)) != null) {
            this.descriptor.setEntityType(BeanDescriptor.EntityType.ORM);
            if (entity.name().isEmpty()) {
                this.descriptor.setName(cls.getSimpleName());
            } else {
                this.descriptor.setName(entity.name());
            }
        }
        if ((identity = (Identity)AnnotationUtil.typeGet(cls, Identity.class)) != null) {
            this.descriptor.setIdentityMode(identity);
        }
        if ((idClass = (IdClass)AnnotationUtil.typeGet(cls, IdClass.class)) != null) {
            this.descriptor.setIdClass(idClass.value());
        }
        if ((embeddable = (Embeddable)AnnotationUtil.typeGet(cls, Embeddable.class)) != null) {
            this.descriptor.setEntityType(BeanDescriptor.EntityType.EMBEDDED);
            this.descriptor.setName("Embeddable:" + cls.getSimpleName());
        }
        for (Index index : this.annotationClassIndexes(cls)) {
            this.descriptor.addIndex(new IndexDefinition(this.convertColumnNames(index.columnNames()), index.name(), index.unique(), index.platforms(), index.concurrent(), index.definition()));
        }
        UniqueConstraint uc = (UniqueConstraint)AnnotationUtil.typeGet(cls, UniqueConstraint.class);
        if (uc != null) {
            this.descriptor.addIndex(new IndexDefinition(uc.name(), this.convertColumnNames(uc.columnNames())));
        }
        if ((view = (View)AnnotationUtil.typeGet(cls, View.class)) != null) {
            this.descriptor.setView(view.name(), view.dependentTables());
        }
        if ((table = (Table)AnnotationUtil.typeGet(cls, Table.class)) != null) {
            UniqueConstraint[] uniqueConstraints;
            for (UniqueConstraint uniqueConstraint : uniqueConstraints = table.uniqueConstraints()) {
                this.descriptor.addIndex(new IndexDefinition(uniqueConstraint.name(), this.convertColumnNames(uniqueConstraint.columnNames())));
            }
            for (UniqueConstraint uniqueConstraint : table.indexes()) {
                String[] cols = uniqueConstraint.columnList().split(",");
                this.descriptor.addIndex(new IndexDefinition(uniqueConstraint.name(), this.convertColumnNames(cols), uniqueConstraint.unique()));
            }
        }
        if ((storage = (StorageEngine)AnnotationUtil.typeGet(cls, StorageEngine.class)) != null) {
            this.descriptor.setStorageEngine(storage.value());
        }
        if ((partition = (DbPartition)AnnotationUtil.typeGet(cls, DbPartition.class)) != null) {
            this.descriptor.setPartitionMeta(new PartitionMeta(partition.mode(), partition.property()));
        }
        if ((tablespace = (Tablespace)AnnotationUtil.typeGet(cls, Tablespace.class)) != null) {
            void var14_22;
            String string;
            String indexTs = tablespace.index();
            if ("".equals(indexTs)) {
                indexTs = tablespace.value();
            }
            if ("".equals(string = tablespace.lob())) {
                String string2 = tablespace.value();
            }
            this.descriptor.setTablespaceMeta(new TablespaceMeta(tablespace.value(), indexTs, (String)var14_22));
        }
        if ((draftable = (Draftable)AnnotationUtil.typeGet(cls, Draftable.class)) != null) {
            this.descriptor.setDraftable();
        }
        if ((draftableElement = (DraftableElement)AnnotationUtil.typeGet(cls, DraftableElement.class)) != null) {
            this.descriptor.setDraftableElement();
        }
        if ((readAudit = (ReadAudit)AnnotationUtil.typeGet(cls, ReadAudit.class)) != null) {
            this.descriptor.setReadAuditing();
        }
        if ((history = (History)AnnotationUtil.typeGet(cls, History.class)) != null) {
            this.descriptor.setHistorySupport();
        }
        if ((comment = (DbComment)AnnotationUtil.typeGet(cls, DbComment.class)) != null) {
            this.descriptor.setDbComment(comment.value());
        }
        if (!this.disableL2Cache) {
            Cache cache = (Cache)AnnotationUtil.typeGet(cls, Cache.class);
            if (cache != null) {
                this.descriptor.setCache(cache);
            } else {
                InvalidateQueryCache invalidateQueryCache = (InvalidateQueryCache)AnnotationUtil.typeGet(cls, InvalidateQueryCache.class);
                if (invalidateQueryCache != null) {
                    this.descriptor.setInvalidateQueryCache(invalidateQueryCache.region());
                }
            }
        }
        for (NamedQuery namedQuery : this.annotationClassNamedQuery(cls)) {
            this.descriptor.addNamedQuery(namedQuery.name(), namedQuery.query());
        }
    }
}

