/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.parse;

import io.ebeaninternal.server.deploy.InheritInfo;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.DiscriminatorType;

public final class DeployInheritInfo
implements Comparable<DeployInheritInfo> {
    private static final String DEFAULT_COLUMN_NAME = "dtype";
    private String discriminatorStringValue;
    private Object discriminatorObjectValue;
    private int columnType;
    private String columnName;
    private int columnLength;
    private String columnDefn;
    private final Class<?> type;
    private Class<?> parent;
    private final Set<DeployInheritInfo> children = new TreeSet<DeployInheritInfo>();

    DeployInheritInfo(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getParent() {
        return this.parent;
    }

    public void setParent(Class<?> parent) {
        this.parent = parent;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.type.getModifiers());
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Set<DeployInheritInfo> children() {
        return this.children;
    }

    public void addChild(DeployInheritInfo childInfo) {
        this.children.add(childInfo);
    }

    public String getColumnName(InheritInfo parent) {
        if (this.columnName == null) {
            this.columnName = parent == null ? DEFAULT_COLUMN_NAME : parent.getDiscriminatorColumn();
        }
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public int getColumnLength(InheritInfo parent) {
        if (this.columnLength == 0) {
            this.columnLength = parent == null ? 31 : parent.getColumnLength();
        }
        return this.columnLength;
    }

    public int getDiscriminatorType(InheritInfo parent) {
        if (this.columnType == 0) {
            this.columnType = parent == null ? 12 : parent.getDiscriminatorType();
        }
        return this.columnType;
    }

    void setColumnType(DiscriminatorType type) {
        this.columnType = type == DiscriminatorType.INTEGER ? 4 : 12;
    }

    void setColumnDefn(String columnDefn) {
        this.columnDefn = columnDefn;
    }

    public String getColumnDefn() {
        return this.columnDefn;
    }

    void setColumnLength(int columnLength) {
        this.columnLength = columnLength;
    }

    public Object getDiscriminatorObjectValue() {
        return this.discriminatorObjectValue;
    }

    public String getDiscriminatorStringValue() {
        return this.discriminatorStringValue;
    }

    public void setDiscriminatorDefaultValue(Class<?> cls) {
        if (this.columnType == 4) {
            this.discriminatorStringValue = "0";
            this.discriminatorObjectValue = 0;
        } else {
            this.discriminatorStringValue = cls.getSimpleName();
            this.discriminatorObjectValue = this.discriminatorStringValue;
        }
    }

    void setDiscriminatorValue(String value) {
        if (value != null && !(value = value.trim()).isEmpty()) {
            this.discriminatorStringValue = value;
            this.discriminatorObjectValue = this.columnType == 4 ? Integer.valueOf(value) : value;
        }
    }

    public String getWhere() {
        ArrayList<Object> discList = new ArrayList<Object>();
        this.appendDiscriminator(discList);
        return this.buildWhereLiteral(discList);
    }

    private void appendDiscriminator(List<Object> list) {
        if (!this.isAbstract()) {
            list.add(this.discriminatorObjectValue);
        }
        for (DeployInheritInfo child : this.children) {
            child.appendDiscriminator(list);
        }
    }

    private String buildWhereLiteral(List<Object> discList) {
        int size = discList.size();
        if (size == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.columnName);
        if (size == 1) {
            sb.append(" = ");
        } else {
            sb.append(" in (");
        }
        for (int i = 0; i < discList.size(); ++i) {
            this.appendSqlLiteralValue(i, discList.get(i), sb);
        }
        if (size > 1) {
            sb.append(')');
        }
        return sb.toString();
    }

    private void appendSqlLiteralValue(int count, Object value, StringBuilder sb) {
        if (count > 0) {
            sb.append(',');
        }
        if (value instanceof String) {
            sb.append('\'').append(value).append('\'');
        } else {
            sb.append(value);
        }
    }

    public String toString() {
        String root = this.parent == null ? null : this.parent.getName();
        String name = this.type == null ? null : this.type.getName();
        return "InheritInfo " + name + " root:" + root + " disc:" + this.discriminatorStringValue;
    }

    @Override
    public int compareTo(DeployInheritInfo other) {
        if (other == this) {
            return 0;
        }
        return this.type.getName().compareTo(other.type.getName());
    }
}

