/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.dto;

import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.dto.DtoReadSet;
import io.ebeaninternal.server.type.TypeManager;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.SQLException;

final class DtoMetaProperty
implements DtoReadSet {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final Class<?> dtoType;
    private final String name;
    private final MethodHandle setter;
    private final ScalarType<?> scalarType;

    DtoMetaProperty(TypeManager typeManager, Class<?> dtoType, Method writeMethod, String name) throws IllegalAccessException, NoSuchMethodException {
        this.dtoType = dtoType;
        this.name = name;
        if (writeMethod != null) {
            this.setter = DtoMetaProperty.lookupMethodHandle(dtoType, writeMethod);
            this.scalarType = typeManager.type(DtoMetaProperty.propertyType(writeMethod), DtoMetaProperty.propertyClass(writeMethod));
        } else {
            this.scalarType = null;
            this.setter = null;
        }
    }

    private static MethodHandle lookupMethodHandle(Class<?> dtoType, Method method) throws NoSuchMethodException, IllegalAccessException {
        return LOOKUP.findVirtual(dtoType, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()));
    }

    static Type propertyType(Method method) {
        return method.getParameters()[0].getParameterizedType();
    }

    static Class<?> propertyClass(Method method) {
        return method.getParameterTypes()[0];
    }

    String name() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return this.scalarType == null;
    }

    @Override
    public void readSet(Object bean, DataReader dataReader) throws SQLException {
        Object value = this.scalarType.read(dataReader);
        this.invoke(bean, value);
    }

    private void invoke(Object instance, Object arg) {
        try {
            this.setter.invoke(instance, arg);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error calling setter for property " + this.fullName() + " with arg: " + String.valueOf(arg), e);
        }
    }

    private String fullName() {
        return this.dtoType.getName() + "." + this.name;
    }
}

