/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.LikeType;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractValueExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

final class LikeExpression
extends AbstractValueExpression {
    private final boolean caseInsensitive;
    private final LikeType type;

    LikeExpression(String propertyName, Object value, boolean caseInsensitive, LikeType type) {
        super(propertyName, value);
        this.caseInsensitive = caseInsensitive;
        this.type = type;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeLike(this.propName, this.strValue(), this.type, this.caseInsensitive);
    }

    @Override
    public void addBindValues(SpiExpressionBind request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            String encryptKey = prop.beanProperty().encryptKey().getStringValue();
            request.addBindEncryptKey(encryptKey);
        }
        String bindValue = LikeExpression.getValue(this.strValue(), this.caseInsensitive, this.type, request);
        request.addBindValue(bindValue);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String pname = this.propName;
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            pname = prop.beanProperty().decryptProperty(this.propName);
        }
        if (this.caseInsensitive) {
            request.append("lower(").property(pname).append(')');
        } else {
            request.property(pname);
        }
        if (this.type == LikeType.EQUAL_TO) {
            request.append(" = ?");
        } else {
            request.appendLike(this.type == LikeType.RAW);
        }
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        if (this.caseInsensitive) {
            builder.append('I');
        }
        builder.append("Like[").append(this.type).append(' ').append(this.propName).append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.strValue());
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        LikeExpression that = (LikeExpression)other;
        return this.strValue().equals(that.strValue());
    }

    private static String getValue(String value, boolean caseInsensitive, LikeType type, SpiExpressionBind request) {
        if (caseInsensitive) {
            value = value.toLowerCase();
        }
        if (type == LikeType.RAW) {
            return value;
        }
        value = request.escapeLikeString(value);
        switch (type) {
            case STARTS_WITH: {
                return value + "%";
            }
            case ENDS_WITH: {
                return "%" + value;
            }
            case CONTAINS: {
                return "%" + value + "%";
            }
            case EQUAL_TO: {
                return value;
            }
        }
        throw new RuntimeException("LikeType " + String.valueOf(type) + " missed?");
    }
}

