/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.CacheMode;
import io.ebean.MergeOptions;
import io.ebean.PersistenceContextScope;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.persist.MergeContext;
import io.ebeaninternal.server.persist.MergeNode;
import io.ebeaninternal.server.persist.MergeNodeAssocManyToMany;
import io.ebeaninternal.server.persist.MergeNodeAssocOne;
import io.ebeaninternal.server.persist.MergeNodeAssocOneToMany;
import io.ebeaninternal.server.persist.MergeRequest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;

final class MergeHandler {
    private static final Pattern PATH_SPLIT = Pattern.compile("\\.");
    private final SpiEbeanServer server;
    private final BeanDescriptor<?> desc;
    private final EntityBean bean;
    private final MergeOptions options;
    private final SpiTransaction transaction;
    private final Map<String, MergeNode> nodes = new LinkedHashMap<String, MergeNode>();

    MergeHandler(SpiEbeanServer server, BeanDescriptor<?> desc, EntityBean bean, MergeOptions options, SpiTransaction transaction) {
        this.server = server;
        this.desc = desc;
        this.bean = bean;
        this.options = options;
        this.transaction = transaction;
    }

    List<EntityBean> merge() {
        Set paths = this.options.paths();
        if (this.desc.isIdGeneratedValue() && paths.isEmpty() && !this.options.isClientGeneratedIds()) {
            Object id = this.desc.getId(this.bean);
            if (id != null) {
                this.bean._ebean_getIntercept().setForceUpdate(true);
            }
            return Collections.emptyList();
        }
        EntityBean outline = this.fetchOutline(paths);
        if (outline == null) {
            return Collections.emptyList();
        }
        this.bean._ebean_getIntercept().setForceUpdate(true);
        MergeContext context = new MergeContext(this.server, this.transaction, this.options.isClientGeneratedIds());
        MergeRequest request = new MergeRequest(context, this.bean, outline);
        for (MergeNode value : this.nodes.values()) {
            value.merge(request);
        }
        return context.getDeletedBeans();
    }

    private EntityBean fetchOutline(Set<String> paths) {
        Query query = this.server.createQuery((Class)this.desc.type());
        query.setBeanCacheMode(CacheMode.OFF);
        query.setPersistenceContextScope(PersistenceContextScope.QUERY);
        query.setId(this.desc.getId(this.bean));
        query.select(this.desc.idProperty().name());
        for (String path : paths) {
            MergeNode node = this.buildNode(path);
            node.addSelectId(query);
        }
        query.usingTransaction((Transaction)this.transaction);
        return (EntityBean)this.server.findOne(query);
    }

    private MergeNode buildNode(String path) {
        String[] split = PATH_SPLIT.split(path);
        if (split.length == 1) {
            return this.addRootLevelNode(split[0]);
        }
        return this.addSubNode(path, split);
    }

    private MergeNode addSubNode(String fullPath, String[] split) {
        MergeNode parent = this.nodes.get(split[0]);
        if (parent == null) {
            throw new PersistenceException("Unable to find parent path " + split[0] + " in merge paths?");
        }
        for (int i = 1; i < split.length - 1; ++i) {
            if ((parent = parent.get(split[i])) != null) continue;
            throw new PersistenceException("Unable to find parent path " + split[0] + " in merge paths?");
        }
        return parent.addChild(fullPath, split[split.length - 1]);
    }

    private MergeNode addRootLevelNode(String rootPath) {
        MergeNode node = MergeHandler.createMergeNode(rootPath, this.desc, rootPath);
        this.nodes.put(rootPath, node);
        return node;
    }

    static MergeNode createMergeNode(String fullPath, BeanDescriptor<?> targetDesc, String path) {
        BeanProperty prop = targetDesc.beanProperty(path);
        if (!(prop instanceof BeanPropertyAssoc)) {
            throw new PersistenceException("merge path [" + path + "] is not a ToMany or ToOne property of " + targetDesc.fullName());
        }
        if (prop instanceof BeanPropertyAssocMany) {
            BeanPropertyAssocMany assocMany = (BeanPropertyAssocMany)prop;
            if (assocMany.isManyToMany()) {
                return new MergeNodeAssocManyToMany(fullPath, assocMany);
            }
            return new MergeNodeAssocOneToMany(fullPath, assocMany);
        }
        return new MergeNodeAssocOne(fullPath, (BeanPropertyAssocOne)prop);
    }
}

