/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dmlbind;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableRequest;
import java.sql.SQLException;
import java.util.List;

final class BindableEncryptedProperty
implements Bindable {
    private final BeanProperty prop;
    private final boolean bindEncryptDataFirst;

    BindableEncryptedProperty(BeanProperty prop, boolean bindEncryptDataFirst) {
        this.prop = prop;
        this.bindEncryptDataFirst = bindEncryptDataFirst;
    }

    @Override
    public boolean isDraftOnly() {
        return this.prop.isDraftOnly();
    }

    @Override
    public void addToUpdate(PersistRequestBean<?> request, List<Bindable> list) {
        if (request.isAddToUpdate(this.prop)) {
            list.add(this);
        }
    }

    @Override
    public void dmlAppend(GenerateDmlRequest request) {
        request.appendColumn(this.prop.dbColumn(), this.prop.dbBind());
    }

    @Override
    public void dmlBind(BindableRequest request, EntityBean bean) throws SQLException {
        Object value = null;
        if (bean != null) {
            value = this.prop.getValue(bean);
        }
        String encryptKeyValue = this.prop.encryptKey().getStringValue();
        if (!this.bindEncryptDataFirst) {
            request.bindNoLog(encryptKeyValue, 12, this.prop.name() + "=****");
        }
        request.bindNoLog(value, this.prop);
        if (this.bindEncryptDataFirst) {
            request.bindNoLog(encryptKeyValue, 12, this.prop.name() + "=****");
        }
    }
}

