/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.QueryPlanMetric;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricStats;
import io.ebeaninternal.server.profile.DQueryPlanMeta;
import io.ebeaninternal.server.profile.DTimeMetricStats;
import io.ebeaninternal.server.profile.DTimedMetric;

final class DQueryPlanMetric
implements QueryPlanMetric {
    private final DQueryPlanMeta meta;
    private final DTimedMetric metric;
    private boolean collected;
    private String reportName;

    DQueryPlanMetric(DQueryPlanMeta meta, DTimedMetric metric) {
        this.meta = meta;
        this.metric = metric;
    }

    public void visit(MetricVisitor visitor) {
        DTimeMetricStats stats = this.metric.collect(visitor.reset());
        if (stats != null) {
            String name = this.reportName != null ? this.reportName : this.reportName(visitor);
            visitor.visitQuery((MetaQueryMetric)new Stats(name, this.meta, stats, this.collected));
            this.collected = true;
        }
    }

    String reportName(MetricVisitor visitor) {
        String tmp;
        this.reportName = tmp = (String)visitor.namingConvention().apply(this.meta.getName());
        return tmp;
    }

    public TimedMetric metric() {
        return this.metric;
    }

    private static class Stats
    implements MetaQueryMetric {
        private final String name;
        private final DQueryPlanMeta meta;
        private final TimedMetricStats stats;
        private final boolean collected;

        private Stats(String name, DQueryPlanMeta meta, TimedMetricStats stats, boolean collected) {
            this.name = name;
            this.meta = meta;
            this.stats = stats;
            this.collected = collected;
        }

        public String toString() {
            return String.valueOf(this.meta) + " " + String.valueOf(this.stats) + " sql:" + this.sql();
        }

        public Class<?> type() {
            return this.meta.getType();
        }

        public boolean initialCollection() {
            return !this.collected;
        }

        public String hash() {
            return this.meta.getHash();
        }

        public String label() {
            return this.meta.getLabel();
        }

        public String sql() {
            return this.meta.getSql();
        }

        public String name() {
            return this.name;
        }

        public String location() {
            return this.meta.getLocation();
        }

        public long count() {
            return this.stats.count();
        }

        public long total() {
            return this.stats.total();
        }

        public long max() {
            return this.stats.max();
        }

        public long mean() {
            return this.stats.mean();
        }
    }
}

