/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.OrderBy;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiExpressionList;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQueryManyJoin;
import io.ebeaninternal.server.bind.DataBind;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.DeployParser;
import io.ebeaninternal.server.expression.DefaultExpressionRequest;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.CQueryBuilder;
import io.ebeaninternal.server.query.CQueryOrderBy;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.SqlTreeAlias;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import io.ebeaninternal.server.querydefn.OrmUpdateProperties;
import io.ebeaninternal.server.rawsql.SpiRawSql;
import io.ebeaninternal.server.util.BindParamsParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CQueryPredicates {
    private final Binder binder;
    private final OrmQueryRequest<?> request;
    private final SpiQuery<?> query;
    private final Object idValue;
    private final BindParams bindParams;
    private DefaultExpressionRequest filterMany;
    private DefaultExpressionRequest where;
    private DefaultExpressionRequest having;
    private String dbHaving;
    private String dbWhere;
    private String dbFilterMany;
    private String dbOrderBy;
    private String dbDistinctOn;
    private String dbUpdateClause;
    private Set<String> predicateIncludes;
    private Set<String> orderByIncludes;

    CQueryPredicates(Binder binder, OrmQueryRequest<?> request) {
        this.binder = binder;
        this.request = request;
        this.query = request.query();
        this.bindParams = this.query.bindParams();
        this.idValue = this.query.getId();
    }

    public String bind(PreparedStatement stmt, Connection connection) throws SQLException {
        return this.bind(this.binder.dataBind(stmt, connection));
    }

    public String bind(DataBind dataBind) throws SQLException {
        int asOfTableCount;
        CQueryPlan queryPlan;
        OrmUpdateProperties updateProperties = this.query.updateProperties();
        if (updateProperties != null) {
            updateProperties.bind(this.binder, dataBind);
        }
        if (this.query.isVersionsBetween() && this.binder.isAsOfStandardsBased()) {
            Timestamp start = this.query.versionStart();
            Timestamp end = this.query.versionEnd();
            dataBind.append("between ").append(start).append(" and ").append(end);
            this.binder.bindObject(dataBind, start);
            this.binder.bindObject(dataBind, end);
            dataBind.append(", ");
        }
        if ((queryPlan = this.request.queryPlan()) != null && (asOfTableCount = queryPlan.asOfTableCount()) > 0) {
            Timestamp asOf = this.query.getAsOf();
            dataBind.append("asOf ").append(asOf);
            for (int i = 0; i < asOfTableCount * this.binder.getAsOfBindCount(); ++i) {
                this.binder.bindObject(dataBind, asOf);
            }
            dataBind.append(", ");
        }
        if (this.idValue != null) {
            this.request.descriptor().bindId(dataBind, this.idValue);
            dataBind.append(this.idValue);
            dataBind.append(", ");
        }
        if (this.bindParams != null) {
            this.binder.bind(this.bindParams, dataBind, dataBind.log());
        }
        if (this.where != null) {
            this.where.bind(dataBind);
        }
        if (this.filterMany != null) {
            this.filterMany.bind(dataBind);
        }
        if (this.having != null) {
            this.having.bind(dataBind);
        }
        return dataBind.log().toString();
    }

    private void buildUpdateClause(boolean buildSql, DeployParser deployParser) {
        OrmUpdateProperties updateProperties;
        if (buildSql && (updateProperties = this.query.updateProperties()) != null) {
            this.dbUpdateClause = updateProperties.buildSetClause(deployParser);
        }
    }

    public String parseBindParams(String sql) {
        if (this.bindParams != null && this.bindParams.requiresNamedParamsPrepare()) {
            return BindParamsParser.parse(this.bindParams, sql);
        }
        return sql;
    }

    private void buildBindWhereRawSql(boolean buildSql) {
        if (!buildSql && this.bindParams != null && this.bindParams.requiresNamedParamsPrepare()) {
            if (this.query.isNativeSql()) {
                String sql = this.query.nativeSql();
                BindParamsParser.parse(this.bindParams, sql);
            } else if (this.query.isRawSql()) {
                SpiRawSql.Sql sql = this.query.rawSql().getSql();
                String s = sql.isParsed() ? sql.getPreWhere() : sql.getUnparsedSql();
                BindParamsParser.parse(this.bindParams, s);
            }
        }
    }

    public void prepare(boolean buildSql) {
        SpiExpressionList<?> havingExpr;
        SpiExpressionList<?> filterManyExpr;
        OrmQueryProperties chunk;
        SpiQueryManyJoin manyProperty;
        SpiExpressionList<?> whereExp;
        DeployParser deployParser = this.request.createDeployParser();
        this.buildUpdateClause(buildSql, deployParser);
        this.buildBindWhereRawSql(buildSql);
        if (buildSql) {
            this.dbOrderBy = this.deriveOrderByWithMany(deployParser);
            this.orderByIncludes = new HashSet<String>(deployParser.includes());
        }
        if ((whereExp = this.query.whereExpressions()) != null) {
            this.where = new DefaultExpressionRequest(this.request, deployParser, this.binder, whereExp);
            if (buildSql) {
                this.dbWhere = this.where.buildSql();
            }
        }
        if ((manyProperty = this.request.manyJoin()) != null && (chunk = this.query.detail().getChunk(manyProperty.path(), false)) != null && (filterManyExpr = chunk.getFilterMany()) != null) {
            this.filterMany = new DefaultExpressionRequest(this.request, deployParser, this.binder, filterManyExpr);
            if (buildSql) {
                this.dbFilterMany = manyProperty.idNullOr(this.filterMany.buildSql());
            }
        }
        if ((havingExpr = this.query.havingExpressions()) != null) {
            this.having = new DefaultExpressionRequest(this.request, deployParser, this.binder, havingExpr);
            if (buildSql) {
                this.dbHaving = this.having.buildSql();
            }
        }
        if (buildSql) {
            String distinctOn = this.query.distinctOn();
            if (distinctOn != null) {
                this.dbDistinctOn = deployParser.parse(distinctOn);
            }
            this.predicateIncludes = deployParser.includes();
        }
    }

    void parseTableAlias(SqlTreeAlias alias) {
        if (this.dbWhere != null) {
            this.dbWhere = alias.parseWhere(this.dbWhere);
        }
        if (this.dbFilterMany != null) {
            this.dbFilterMany = alias.parse(this.dbFilterMany);
        }
        if (this.dbHaving != null) {
            this.dbHaving = alias.parseWhere(this.dbHaving);
        }
        if (this.dbOrderBy != null) {
            this.dbOrderBy = alias.parse(this.dbOrderBy);
        }
        if (this.dbDistinctOn != null) {
            this.dbDistinctOn = alias.parse(this.dbDistinctOn);
        }
    }

    private String parseOrderBy(DeployParser parser) {
        OrderBy<?> orderBy = this.query.getOrderBy();
        if (orderBy == null) {
            return null;
        }
        return CQueryOrderBy.parse(parser, this.request.descriptor(), orderBy);
    }

    private String deriveOrderByWithMany(DeployParser parser) {
        SpiQueryManyJoin manyProp;
        String manyOrderBy;
        Object orderBy = this.parseOrderBy(parser);
        if (!this.request.includeManyJoin()) {
            return orderBy;
        }
        String orderById = parser.parse(this.request.descriptor().defaultOrderBy());
        if (orderBy == null) {
            orderBy = orderById;
        }
        if ((manyOrderBy = (manyProp = this.request.manyJoin()).fetchOrderBy()) != null) {
            orderBy = (String)orderBy + ", " + parser.parse(CQueryBuilder.prefixOrderByFields(manyProp.path(), manyOrderBy));
        }
        if (this.request.isFindById()) {
            return orderBy;
        }
        int idPos = ((String)orderBy).indexOf(orderById);
        if (idPos == 0) {
            return orderBy;
        }
        int manyPos = ((String)orderBy).indexOf("${" + manyProp.path() + "}");
        if (manyPos == -1) {
            if (idPos == -1) {
                return (String)orderBy + ", " + orderById;
            }
            return orderBy;
        }
        if (idPos == -1 || idPos >= manyPos) {
            if (idPos > manyPos) {
                String msg = "A Query on [" + String.valueOf(this.request.descriptor()) + "] includes a join to a 'many' association [" + manyProp.path() + "] with an incorrect orderBy [" + (String)orderBy + "]. The id property [" + orderById + "] must come before the many property [" + manyProp.path() + "] in the orderBy. Ebean has automatically modified the orderBy clause to do this.";
                CoreLog.log.log(System.Logger.Level.WARNING, msg);
            }
            orderBy = ((String)orderBy).substring(0, manyPos) + orderById + ", " + ((String)orderBy).substring(manyPos);
        }
        return orderBy;
    }

    public List<Object> whereExprBindValues() {
        if (this.idValue == null && this.where == null) {
            return Collections.emptyList();
        }
        if (this.where == null) {
            return List.of(this.idValue);
        }
        if (this.idValue == null) {
            return this.where.bindValues();
        }
        ArrayList<Object> bindValues = new ArrayList<Object>();
        bindValues.add(this.idValue);
        bindValues.addAll(this.where.bindValues());
        return Collections.unmodifiableList(bindValues);
    }

    String dbUpdateClause() {
        return this.dbUpdateClause;
    }

    String dbHaving() {
        return this.dbHaving;
    }

    String dbWhere() {
        return this.dbWhere;
    }

    String dbFilterMany() {
        return this.dbFilterMany;
    }

    String dbOrderBy() {
        return this.dbOrderBy;
    }

    String dbDistinctOn() {
        return this.dbDistinctOn;
    }

    Set<String> predicateIncludes() {
        return this.predicateIncludes;
    }

    Set<String> orderByIncludes() {
        return this.orderByIncludes;
    }

    String logWhereSql() {
        Object logPred;
        if (this.dbWhere == null && this.dbFilterMany == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.dbWhere != null) {
            sb.append(this.dbWhere);
        }
        if (this.dbFilterMany != null) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(this.dbFilterMany);
        }
        if (((String)(logPred = sb.toString())).length() > 400) {
            logPred = ((String)logPred).substring(0, 400) + " ...";
        }
        return logPred;
    }
}

