/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.ebean.FetchConfig;
import io.ebean.event.BeanQueryRequest;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiQueryManyJoin;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

public final class OrmQueryDetail
implements Serializable {
    private static final long serialVersionUID = -2510486880141461807L;
    private OrmQueryProperties baseProps = new OrmQueryProperties();
    private LinkedHashMap<String, OrmQueryProperties> fetchPaths = new LinkedHashMap();

    public OrmQueryDetail copy() {
        OrmQueryDetail copy = new OrmQueryDetail();
        copy.baseProps = this.baseProps.copy();
        for (Map.Entry<String, OrmQueryProperties> entry : this.fetchPaths.entrySet()) {
            copy.fetchPaths.put(entry.getKey(), entry.getValue().copy());
        }
        return copy;
    }

    public void addNested(String path, OrmQueryDetail other, FetchConfig config) {
        this.fetchProperties(path, other.baseProps, config);
        for (Map.Entry<String, OrmQueryProperties> entry : other.fetchPaths.entrySet()) {
            this.fetchProperties(path + "." + entry.getKey(), entry.getValue(), entry.getValue().getFetchConfig());
        }
    }

    public void queryPlanHash(StringBuilder builder) {
        this.baseProps.queryPlanHash(builder);
        if (this.fetchPaths != null) {
            for (OrmQueryProperties p : this.fetchPaths.values()) {
                p.queryPlanHash(builder);
            }
        }
    }

    public boolean isAutoTuneEqual(OrmQueryDetail otherDetail) {
        if (!this.isSameByAutoTune(this.baseProps, otherDetail.baseProps)) {
            return false;
        }
        if (this.fetchPaths == null) {
            return otherDetail.fetchPaths == null;
        }
        if (this.fetchPaths.size() != otherDetail.fetchPaths.size()) {
            return false;
        }
        for (Map.Entry<String, OrmQueryProperties> entry : this.fetchPaths.entrySet()) {
            OrmQueryProperties chunk = otherDetail.getChunk(entry.getKey(), false);
            if (this.isSameByAutoTune(entry.getValue(), chunk)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameByAutoTune(OrmQueryProperties p1, OrmQueryProperties p2) {
        return p1 == null ? p2 == null : p1.isSameByAutoTune(p2);
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        if (this.baseProps.hasProperties()) {
            this.baseProps.asStringDebug("select ", sb);
        }
        if (this.fetchPaths != null) {
            for (OrmQueryProperties join : this.fetchPaths.values()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                join.asStringDebug("fetch ", sb);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        throw new RuntimeException("should not use");
    }

    public void select(String properties) {
        this.baseProps = new OrmQueryProperties(null, properties, null);
    }

    public void selectProperties(Set<String> properties) {
        this.baseProps = new OrmQueryProperties(null, properties, OrmQueryProperties.DEFAULT_FETCH);
    }

    void selectProperties(OrmQueryProperties other) {
        this.baseProps = new OrmQueryProperties(null, other, OrmQueryProperties.DEFAULT_FETCH);
    }

    boolean containsProperty(String property) {
        return this.baseProps.isIncluded(property);
    }

    public void setEmptyBase() {
        this.baseProps = new OrmQueryProperties(null, Collections.emptySet());
    }

    public void setBase(OrmQueryProperties baseProps) {
        this.baseProps = baseProps;
    }

    List<OrmQueryProperties> removeSecondaryQueries() {
        return this.removeSecondaryQueries(false);
    }

    List<OrmQueryProperties> removeSecondaryLazyQueries() {
        return this.removeSecondaryQueries(true);
    }

    private List<OrmQueryProperties> removeSecondaryQueries(boolean lazyQuery) {
        ArrayList<String> matchingPaths = new ArrayList<String>(2);
        for (OrmQueryProperties chunk : this.fetchPaths.values()) {
            boolean match = lazyQuery ? chunk.isLazyFetch() : chunk.isQueryFetch();
            if (!match) continue;
            matchingPaths.add(chunk.getPath());
        }
        if (matchingPaths.isEmpty()) {
            return null;
        }
        Collections.sort(matchingPaths);
        ArrayList<OrmQueryProperties> props = new ArrayList<OrmQueryProperties>();
        for (String path : matchingPaths) {
            OrmQueryProperties secQuery = (OrmQueryProperties)this.fetchPaths.remove(path);
            if (secQuery == null) continue;
            props.add(secQuery);
            Iterator<OrmQueryProperties> pass2It = this.fetchPaths.values().iterator();
            while (pass2It.hasNext()) {
                OrmQueryProperties pass2Prop = pass2It.next();
                if (!secQuery.isChild(pass2Prop)) continue;
                pass2It.remove();
                secQuery.add(pass2Prop);
            }
        }
        for (OrmQueryProperties prop : props) {
            String path = prop.getPath();
            String[] split = SplitName.split((String)path);
            OrmQueryProperties chunk = this.getChunk(split[0], true);
            chunk.addSecondaryQueryJoin(split[1]);
        }
        return props;
    }

    boolean tuneFetchProperties(OrmQueryDetail tunedDetail) {
        boolean tuned = false;
        OrmQueryProperties tunedRoot = tunedDetail.getChunk(null, false);
        if (tunedRoot != null) {
            tuned = true;
            this.baseProps = tunedRoot;
            for (OrmQueryProperties tunedChunk : tunedDetail.fetchPaths.values()) {
                this.fetch(tunedChunk.copy());
            }
        }
        return tuned;
    }

    void fetch(OrmQueryProperties chunk) {
        String path = chunk.getPath();
        if (path == null) {
            this.baseProps = chunk;
        } else {
            this.fetchPaths.put(path, chunk);
        }
    }

    public void clear() {
        this.fetchPaths.clear();
    }

    public void fetch(String path, String partialProps, FetchConfig fetchConfig) {
        this.fetch(new OrmQueryProperties(path, partialProps, fetchConfig));
    }

    public void fetchProperties(String path, Set<String> properties, FetchConfig fetchConfig) {
        this.fetch(new OrmQueryProperties(path, properties, fetchConfig));
    }

    void fetchProperties(String path, OrmQueryProperties other) {
        this.fetchProperties(path, other, other.getFetchConfig());
    }

    void fetchProperties(String path, OrmQueryProperties other, FetchConfig fetchConfig) {
        this.fetch(new OrmQueryProperties(path, other, fetchConfig));
    }

    public void fetch(String path, LinkedHashSet<String> properties) {
        this.fetch(new OrmQueryProperties(path, properties));
    }

    public void sortFetchPaths(BeanDescriptor<?> d) {
        this.sortFetchPaths(d, true);
    }

    private void sortFetchPaths(BeanDescriptor<?> d, boolean addIds) {
        if (!this.fetchPaths.isEmpty()) {
            LinkedHashMap<String, OrmQueryProperties> sorted = new LinkedHashMap<String, OrmQueryProperties>();
            for (OrmQueryProperties p : this.fetchPaths.values()) {
                this.sortFetchPaths(d, p, sorted, addIds);
            }
            this.fetchPaths = sorted;
        }
    }

    private void sortFetchPaths(BeanDescriptor<?> d, OrmQueryProperties p, LinkedHashMap<String, OrmQueryProperties> sorted, boolean addId) {
        String path = p.getPath();
        if (!sorted.containsKey(path)) {
            String parentPath = p.getParentPath();
            if (parentPath == null || sorted.containsKey(parentPath)) {
                sorted.put(path, p);
            } else {
                OrmQueryProperties parentProp = this.fetchPaths.get(parentPath);
                if (parentProp == null) {
                    ElPropertyValue el = d.elGetValue(parentPath);
                    if (el == null) {
                        throw new PersistenceException("Path [" + parentPath + "] not valid from " + d.fullName());
                    }
                    BeanPropertyAssoc assocOne = (BeanPropertyAssoc)el.beanProperty();
                    parentProp = addId ? new OrmQueryProperties(parentPath, assocOne.targetIdProperty()) : new OrmQueryProperties(parentPath, Collections.emptySet());
                }
                this.sortFetchPaths(d, parentProp, sorted, addId);
                sorted.put(path, p);
            }
        }
    }

    SpiQueryManyJoin markQueryJoins(BeanDescriptor<?> beanDescriptor, String lazyLoadManyPath, boolean allowOne, boolean addIds) {
        if (this.fetchPaths.isEmpty()) {
            return null;
        }
        ElPropertyDeploy many = null;
        String manyFetchProperty = null;
        boolean fetchJoinFirstMany = allowOne;
        this.sortFetchPaths(beanDescriptor, addIds);
        List<FetchEntry> pairs = this.sortByFetchPreference(beanDescriptor);
        for (FetchEntry pair : pairs) {
            OrmQueryProperties chunk;
            ElPropertyDeploy elProp = pair.getElProp();
            if (!elProp.containsManySince(manyFetchProperty) || !this.isQueryJoinCandidate(lazyLoadManyPath, chunk = pair.getProperties())) continue;
            if (fetchJoinFirstMany) {
                fetchJoinFirstMany = false;
                manyFetchProperty = pair.getPath();
                chunk.filterManyInline();
                many = elProp;
                continue;
            }
            chunk.markForQueryJoin();
        }
        return many;
    }

    private List<FetchEntry> sortByFetchPreference(BeanDescriptor<?> desc) {
        ArrayList<FetchEntry> entries = new ArrayList<FetchEntry>(this.fetchPaths.size());
        int idx = 0;
        for (Map.Entry<String, OrmQueryProperties> entry : this.fetchPaths.entrySet()) {
            String fetchPath = entry.getKey();
            ElPropertyDeploy elProp = desc.elPropertyDeploy(fetchPath);
            if (elProp == null) {
                throw new PersistenceException("Invalid fetch path " + fetchPath + " from " + desc.fullName());
            }
            entries.add(new FetchEntry(idx++, fetchPath, elProp, entry.getValue()));
        }
        Collections.sort(entries);
        return entries;
    }

    private boolean isQueryJoinCandidate(String lazyLoadManyPath, OrmQueryProperties chunk) {
        return chunk.isFetchJoin() && !this.isLazyLoadManyRoot(lazyLoadManyPath, chunk) && !this.hasParentSecJoin(lazyLoadManyPath, chunk);
    }

    private boolean isLazyLoadManyRoot(String lazyLoadManyPath, OrmQueryProperties chunk) {
        return lazyLoadManyPath != null && lazyLoadManyPath.equals(chunk.getPath());
    }

    private boolean hasParentSecJoin(String lazyLoadManyPath, OrmQueryProperties chunk) {
        OrmQueryProperties parent = this.getParent(chunk);
        if (parent == null) {
            return false;
        }
        if (lazyLoadManyPath != null && lazyLoadManyPath.equals(parent.getPath())) {
            return false;
        }
        return !parent.isFetchJoin() || this.hasParentSecJoin(lazyLoadManyPath, parent);
    }

    private OrmQueryProperties getParent(OrmQueryProperties chunk) {
        String parentPath = chunk.getParentPath();
        return parentPath == null ? null : this.fetchPaths.get(parentPath);
    }

    public void setDefaultSelectClause(BeanDescriptor<?> desc) {
        if (desc.hasDefaultSelectClause() && !this.hasSelectClause()) {
            this.baseProps = new OrmQueryProperties(null, desc.defaultSelectClause());
        }
        for (OrmQueryProperties joinProps : this.fetchPaths.values()) {
            BeanDescriptor<?> assocDesc;
            if (joinProps.hasSelectClause() || (assocDesc = desc.descriptor(joinProps.getPath())) == null || !assocDesc.hasDefaultSelectClause()) continue;
            this.fetch(joinProps.getPath(), assocDesc.defaultSelectClause(), joinProps.getFetchConfig());
        }
    }

    public boolean hasSelectClause() {
        return this.baseProps.hasSelectClause();
    }

    public boolean isEmpty() {
        return this.fetchPaths.isEmpty() && this.baseProps.allProperties();
    }

    public boolean isJoinsEmpty() {
        return this.fetchPaths.isEmpty();
    }

    public void includeBeanJoin(String parentPath, String propertyName) {
        OrmQueryProperties parentChunk = this.getChunk(parentPath, true);
        parentChunk.includeBeanJoin(propertyName);
    }

    public OrmQueryProperties getChunk(String path, boolean create) {
        if (path == null) {
            return this.baseProps;
        }
        OrmQueryProperties props = this.fetchPaths.get(path);
        if (create && props == null) {
            props = new OrmQueryProperties(path);
            this.fetch(props);
        }
        return props;
    }

    public boolean includesPath(String path) {
        OrmQueryProperties chunk = this.fetchPaths.get(path);
        return chunk != null && !chunk.isCache();
    }

    public Set<String> getFetchPaths() {
        return this.fetchPaths.keySet();
    }

    public Set<Map.Entry<String, OrmQueryProperties>> entries() {
        return this.fetchPaths.entrySet();
    }

    public void prepareExpressions(BeanQueryRequest<?> request) {
        for (OrmQueryProperties value : this.fetchPaths.values()) {
            value.prepareExpressions(request);
        }
    }

    private static class FetchEntry
    implements Comparable<FetchEntry> {
        private final int index;
        private final String path;
        private final OrmQueryProperties properties;
        private final ElPropertyDeploy elProp;

        FetchEntry(int index, String path, ElPropertyDeploy elProp, OrmQueryProperties value) {
            this.index = index;
            this.path = path;
            this.elProp = elProp;
            this.properties = value;
        }

        String getPath() {
            return this.path;
        }

        OrmQueryProperties getProperties() {
            return this.properties;
        }

        ElPropertyDeploy getElProp() {
            return this.elProp;
        }

        @Override
        public int compareTo(FetchEntry other) {
            int op;
            int fp = this.elProp.fetchPreference();
            if (fp == (op = other.elProp.fetchPreference())) {
                return Integer.compare(this.index, other.index);
            }
            return fp < op ? -1 : 1;
        }
    }
}

