/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.SqlLimitRequest;
import io.ebeaninternal.api.SpiQuery;

public final class OrmQueryLimitRequest
implements SqlLimitRequest {
    private final SpiQuery<?> ormQuery;
    private final DatabasePlatform dbPlatform;
    private final String sql;
    private final String sqlOrderBy;
    private final boolean distinct;
    private final String distinctOn;
    private final String hint;
    private final String label;

    public OrmQueryLimitRequest(String sql, String sqlOrderBy, SpiQuery<?> ormQuery, DatabasePlatform dbPlatform, boolean distinct) {
        this(sql, sqlOrderBy, ormQuery, dbPlatform, distinct, null, "", "");
    }

    public OrmQueryLimitRequest(String sql, String sqlOrderBy, SpiQuery<?> ormQuery, DatabasePlatform dbPlatform, boolean distinct, String distinctOn, String hint, String label) {
        this.sql = sql;
        this.sqlOrderBy = sqlOrderBy;
        this.ormQuery = ormQuery;
        this.dbPlatform = dbPlatform;
        this.distinct = distinct;
        this.distinctOn = distinctOn;
        this.hint = hint;
        this.label = label;
    }

    private StringBuilder newBuffer() {
        return new StringBuilder(50 + this.sql.length());
    }

    public String ansiOffsetRows() {
        int maxRows;
        StringBuilder buffer = this.selectDistinct();
        buffer.append(this.sql);
        int firstRow = this.getFirstRow();
        if (firstRow > 0) {
            buffer.append(" offset ").append(firstRow).append(" rows");
        }
        if ((maxRows = this.getMaxRows()) > 0) {
            buffer.append(" fetch next ").append(maxRows).append(" rows only");
        }
        return buffer.toString();
    }

    public StringBuilder selectDistinct() {
        StringBuilder buffer = this.newBuffer();
        buffer.append("select ").append(this.hint).append(this.label);
        if (this.distinct) {
            buffer.append("distinct ");
        }
        return buffer;
    }

    public StringBuilder selectDistinctOnSql() {
        StringBuilder buffer = this.newBuffer();
        buffer.append("select ").append(this.hint).append(this.label);
        if (this.distinct) {
            buffer.append("distinct ");
            if (this.distinctOn != null) {
                buffer.append("on (").append(this.distinctOn).append(") ");
            }
        }
        buffer.append(this.sql);
        return buffer;
    }

    public String getDbOrderBy() {
        return this.sqlOrderBy;
    }

    public String getDbSql() {
        return this.sql;
    }

    public int getFirstRow() {
        return this.ormQuery.getFirstRow();
    }

    public int getMaxRows() {
        return this.ormQuery.getMaxRows();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public SpiQuery<?> getOrmQuery() {
        return this.ormQuery;
    }

    public DatabasePlatform getDbPlatform() {
        return this.dbPlatform;
    }
}

