/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.rawsql;

import io.ebeaninternal.server.rawsql.SpiRawSql;
import io.ebeaninternal.server.util.DSelectColumnsParser;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;

final class DRawSqlColumnsParser {
    private static final Pattern COLINFO_SPLIT = Pattern.compile("\\s(?=[^\\)]*(?:\\(|$))");
    private final String sqlSelect;
    private int indexPos;

    public static SpiRawSql.ColumnMapping parse(String sqlSelect) {
        return new DRawSqlColumnsParser(sqlSelect).parse();
    }

    private DRawSqlColumnsParser(String sqlSelect) {
        this.sqlSelect = sqlSelect;
    }

    private SpiRawSql.ColumnMapping parse() {
        Set<String> columnList = DSelectColumnsParser.parse(this.sqlSelect);
        ArrayList<SpiRawSql.ColumnMapping.Column> columns = new ArrayList<SpiRawSql.ColumnMapping.Column>(columnList.size());
        for (String rawColumn : columnList) {
            columns.add(this.parseColumn(rawColumn));
        }
        return new SpiRawSql.ColumnMapping(columns);
    }

    private SpiRawSql.ColumnMapping.Column parseColumn(String colInfo) {
        String[] split = COLINFO_SPLIT.split(colInfo);
        if (split.length > 1) {
            ArrayList<String> tmp = new ArrayList<String>(split.length);
            for (String aSplit : split) {
                if (aSplit.trim().isEmpty()) continue;
                tmp.add(aSplit.trim());
            }
            split = tmp.toArray(new String[0]);
        }
        if (split.length == 0) {
            throw new PersistenceException("Huh? Not expecting length=0 when parsing column " + colInfo);
        }
        if (split.length == 1) {
            return new SpiRawSql.ColumnMapping.Column(this.indexPos++, split[0], null);
        }
        if (split.length == 2) {
            return new SpiRawSql.ColumnMapping.Column(this.indexPos++, split[0], split[1]);
        }
        if (!split[split.length - 2].equalsIgnoreCase("as")) {
            throw new PersistenceException("Expecting AS keyword as second to last word when parsing column " + colInfo);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(split[0]);
        for (int i = 1; i < split.length - 2; ++i) {
            sb.append(' ').append(split[i]);
        }
        return new SpiRawSql.ColumnMapping.Column(this.indexPos++, sb.toString(), split[split.length - 1]);
    }
}

