/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import io.ebeaninternal.server.transaction.ImplicitReadOnlyTransaction;
import io.ebeaninternal.server.transaction.TransactionFactoryBasic;
import io.ebeaninternal.server.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;

final class TransactionFactoryBasicWithRead
extends TransactionFactoryBasic {
    private final DataSource readOnlyDataSource;

    TransactionFactoryBasicWithRead(TransactionManager manager, DataSourceSupplier dataSourceSupplier) {
        super(manager, dataSourceSupplier);
        this.readOnlyDataSource = dataSourceSupplier.readOnlyDataSource();
    }

    @Override
    public SpiTransaction createReadOnlyTransaction(Object tenantId, boolean useMaster) {
        Connection connection = null;
        try {
            connection = useMaster ? this.dataSource.getConnection() : this.readOnlyDataSource.getConnection();
            return new ImplicitReadOnlyTransaction(useMaster, this.manager, connection);
        }
        catch (PersistenceException ex) {
            JdbcClose.close(connection);
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }
}

