/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.util;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;

public class ArrayStack<E>
implements Iterable<E> {
    private final List<E> list;

    public ArrayStack(int size) {
        this.list = new ArrayList(size);
    }

    public ArrayStack() {
        this.list = new ArrayList();
    }

    public String toString() {
        return this.list.toString();
    }

    public void push(E item) {
        this.list.add(item);
    }

    public E pop() {
        int len = this.list.size();
        if (len == 0) {
            throw new EmptyStackException();
        }
        return this.list.remove(len - 1);
    }

    private E peekZero(boolean retNull) {
        int len = this.list.size();
        if (len == 0) {
            if (retNull) {
                return null;
            }
            throw new EmptyStackException();
        }
        return this.list.get(len - 1);
    }

    public E peek() {
        return this.peekZero(false);
    }

    public E peekWithNull() {
        return this.peekZero(true);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public boolean contains(E o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }
}

