/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.util;

import io.ebean.config.EncryptKey;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import java.util.Collection;
import javax.persistence.PersistenceException;

public final class BindParamsParser {
    private static final String ENCRYPTKEY_PREFIX = "encryptkey_";
    private static final String ENCRYPTKEY_GAP = "___";
    private static final int ENCRYPTKEY_PREFIX_LEN = "encryptkey_".length();
    private static final int ENCRYPTKEY_GAP_LEN = "___".length();
    private static final String quote = "'";
    private static final String colon = ":";
    private final BindParams params;
    private final String sql;
    private final BeanDescriptor<?> beanDescriptor;

    public static String parse(BindParams params, String sql) {
        return BindParamsParser.parse(params, sql, null);
    }

    public static String parse(BindParams params, String sql, BeanDescriptor<?> beanDescriptor) {
        return new BindParamsParser(params, sql, beanDescriptor).parseSql();
    }

    private BindParamsParser(BindParams params, String sql, BeanDescriptor<?> beanDescriptor) {
        this.params = params;
        this.sql = sql;
        this.beanDescriptor = beanDescriptor;
    }

    private String parseSql() {
        String preparedSql;
        if (this.params.isSameBindHash() && (preparedSql = this.params.preparedSql()) != null && !preparedSql.isEmpty()) {
            return preparedSql;
        }
        preparedSql = this.prepareSql();
        this.params.setPreparedSql(preparedSql);
        this.params.updateHash();
        return preparedSql;
    }

    private String prepareSql() {
        if (!this.params.requiresNamedParamsPrepare()) {
            return this.sql;
        }
        BindParams.OrderedList orderedList = this.params.createOrderedList();
        this.parseNamedParams(orderedList);
        return orderedList.getPreparedSql();
    }

    private void parseNamedParams(BindParams.OrderedList orderedList) {
        this.parseNamedParams(0, orderedList);
    }

    private void parseNamedParams(int startPos, BindParams.OrderedList orderedList) {
        if (this.sql == null) {
            throw new PersistenceException("query does not contain any named bind parameters?");
        }
        if (startPos > this.sql.length()) {
            return;
        }
        int beginQuotePos = this.sql.indexOf(quote, startPos);
        int nameParamStart = BindParamsParser.findNameStart(this.sql, startPos);
        if (beginQuotePos > 0 && beginQuotePos < nameParamStart) {
            this.addNamedParam(startPos, orderedList, beginQuotePos);
        } else if (nameParamStart < 0) {
            orderedList.appendSql(this.sql.substring(startPos));
        } else {
            int endOfParam = this.findEndOfParam(nameParamStart);
            String paramName = this.sql.substring(nameParamStart + 1, endOfParam);
            BindParams.Param param = this.extractNamedParam(paramName);
            orderedList.appendSql(this.sql.substring(startPos, nameParamStart));
            Object inValue = param.inValue();
            if (inValue instanceof Collection) {
                this.addCollectionParams(orderedList, param, (Collection)inValue);
            } else {
                this.addScalarParam(orderedList, param);
            }
            this.parseNamedParams(endOfParam, orderedList);
        }
    }

    private void addScalarParam(BindParams.OrderedList orderedList, BindParams.Param param) {
        orderedList.add(param);
        orderedList.appendSql("?");
    }

    private BindParams.Param extractNamedParam(String paramName) {
        BindParams.Param param = paramName.startsWith(ENCRYPTKEY_PREFIX) ? this.addEncryptKeyParam(paramName) : this.params.parameter(paramName);
        if (param == null) {
            throw new PersistenceException("Bind value is not set or null for " + paramName + " in " + this.sql);
        }
        return param;
    }

    private int findEndOfParam(int nameParamStart) {
        char c;
        int endOfParam = nameParamStart + 1;
        while (((c = this.sql.charAt(endOfParam)) == '_' || Character.isLetterOrDigit(c)) && ++endOfParam < this.sql.length()) {
        }
        return endOfParam;
    }

    private void addNamedParam(int startPos, BindParams.OrderedList orderedList, int beginQuotePos) {
        int endQuotePos = this.sql.indexOf(quote, beginQuotePos + 1);
        String sub = this.sql.substring(startPos, endQuotePos + 1);
        orderedList.appendSql(sub);
        this.parseNamedParams(endQuotePos + 1, orderedList);
    }

    private void addCollectionParams(BindParams.OrderedList orderedList, BindParams.Param param, Collection<?> inValue) {
        for (int c = 0; c < inValue.size(); ++c) {
            if (c > 0) {
                orderedList.appendSql(",");
            }
            orderedList.appendSql("?");
        }
        orderedList.add(param);
    }

    static int findNameStart(String sql, int startPos) {
        int colonPos;
        while ((colonPos = sql.indexOf(colon, startPos)) > -1) {
            char c = sql.charAt(colonPos + 1);
            if (c == '_' || Character.isLetterOrDigit(c)) {
                return colonPos;
            }
            startPos = colonPos + 2;
        }
        return -1;
    }

    private BindParams.Param addEncryptKeyParam(String keyNamedParam) {
        int pos = keyNamedParam.indexOf(ENCRYPTKEY_GAP, ENCRYPTKEY_PREFIX_LEN);
        String tableName = keyNamedParam.substring(ENCRYPTKEY_PREFIX_LEN, pos);
        String columnName = keyNamedParam.substring(pos + ENCRYPTKEY_GAP_LEN);
        EncryptKey key = this.beanDescriptor.encryptKey(tableName, columnName);
        String strKey = key.getStringValue();
        return this.params.setEncryptionKey(keyNamedParam, strKey);
    }
}

