/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.Database;
import io.ebean.DatabaseBuilder;
import io.ebean.SqlUpdate;
import io.ebean.Transaction;
import io.ebean.ValuePair;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanDiffVisitor;
import io.ebean.bean.BeanLoader;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebean.bean.SingleBeanLoader;
import io.ebean.cache.QueryCacheEntry;
import io.ebean.config.EncryptKey;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.core.type.ScalarType;
import io.ebean.event.BeanFindController;
import io.ebean.event.BeanPersistController;
import io.ebean.event.BeanPersistListener;
import io.ebean.event.BeanPostConstructListener;
import io.ebean.event.BeanPostLoad;
import io.ebean.event.BeanQueryAdapter;
import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeLogFilter;
import io.ebean.event.changelog.ChangeType;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaQueryPlan;
import io.ebean.meta.MetricVisitor;
import io.ebean.meta.QueryPlanInit;
import io.ebean.plugin.BeanType;
import io.ebean.plugin.ExpressionPath;
import io.ebean.plugin.Property;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.BeanCacheResult;
import io.ebeaninternal.api.CQueryPlanKey;
import io.ebeaninternal.api.ConcurrencyMode;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.LoadBeanContext;
import io.ebeaninternal.api.LoadContext;
import io.ebeaninternal.api.SpiBeanType;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiUpdatePlan;
import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.api.json.SpiJsonReader;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.bind.DataBind;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.cache.CachedManyIds;
import io.ebeaninternal.server.core.CacheOptions;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanChangeJson;
import io.ebeaninternal.server.deploy.BeanDescriptorCacheHelp;
import io.ebeaninternal.server.deploy.BeanDescriptorInitContext;
import io.ebeaninternal.server.deploy.BeanDescriptorJsonHelp;
import io.ebeaninternal.server.deploy.BeanDescriptorMap;
import io.ebeaninternal.server.deploy.BeanFkeyProperty;
import io.ebeaninternal.server.deploy.BeanIudMetrics;
import io.ebeaninternal.server.deploy.BeanNaturalKey;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.ChainedBeanPersistController;
import io.ebeaninternal.server.deploy.ChainedBeanPersistListener;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DeployPropertyParser;
import io.ebeaninternal.server.deploy.DeployUpdateParser;
import io.ebeaninternal.server.deploy.FormulaPropertyPath;
import io.ebeaninternal.server.deploy.IdentityMode;
import io.ebeaninternal.server.deploy.IndexDefinition;
import io.ebeaninternal.server.deploy.PartitionMeta;
import io.ebeaninternal.server.deploy.PersistenceContextUtil;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.TablespaceMeta;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.deploy.id.IdBinderSimple;
import io.ebeaninternal.server.deploy.id.ImportedId;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyLists;
import io.ebeaninternal.server.el.ElComparator;
import io.ebeaninternal.server.el.ElComparatorCompound;
import io.ebeaninternal.server.el.ElComparatorNoop;
import io.ebeaninternal.server.el.ElComparatorProperty;
import io.ebeaninternal.server.el.ElPropertyChainBuilder;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.persist.DeleteMode;
import io.ebeaninternal.server.persist.DmlUtil;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.ExtraJoin;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.STreePropertyAssoc;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.STreePropertyAssocOne;
import io.ebeaninternal.server.query.STreeType;
import io.ebeaninternal.server.query.SqlBeanLoad;
import io.ebeaninternal.server.querydefn.DefaultOrmQuery;
import io.ebeaninternal.server.querydefn.OrmQueryDetail;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import io.ebeaninternal.util.SortByClause;
import io.ebeaninternal.util.SortByClauseParser;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BeanDescriptor<T>
implements BeanType<T>,
STreeType,
SpiBeanType {
    private static final System.Logger log = CoreLog.internal;
    private final ConcurrentHashMap<String, SpiUpdatePlan> updatePlanCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<CQueryPlanKey, CQueryPlan> queryPlanCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ElPropertyValue> elCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ElPropertyDeploy> elDeployCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ElComparator<T>> comparatorCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, STreeProperty> dynamicProperty = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Map<String, String>> pathMaps = new ConcurrentHashMap();
    private final boolean multiValueSupported;
    private boolean batchEscalateOnCascadeInsert;
    private boolean batchEscalateOnCascadeDelete;
    private final BeanIudMetrics iudMetrics;
    private final EntityType entityType;
    private final boolean idGeneratedValue;
    private final PlatformIdGenerator idGenerator;
    private final IdentityMode identityMode;
    private final IdType idType;
    private final String selectLastInsertedId;
    private final boolean autoTunable;
    private final ConcurrencyMode concurrencyMode;
    private final IndexDefinition[] indexDefinitions;
    private final String[] dependentTables;
    private final String baseTable;
    private final String baseTableAsOf;
    private final String baseTableVersionsBetween;
    private final boolean historySupport;
    private final TableJoin primaryKeyJoin;
    private final BeanProperty softDeleteProperty;
    private final boolean softDelete;
    private final PartitionMeta partitionMeta;
    private final TablespaceMeta tablespaceMeta;
    private final String storageEngine;
    private final String dbComment;
    private final BeanProperty unmappedJson;
    private final BeanProperty tenant;
    private final LinkedHashMap<String, BeanProperty> propMap;
    private final Map<String, String> columnPath = new HashMap<String, String>();
    private final Map<String, BeanPropertyAssoc<?>> tablePath = new HashMap();
    final Class<T> beanType;
    final Class<?> rootBeanType;
    private final BeanDescriptorMap owner;
    final String[] properties;
    private final BeanPostLoad beanPostLoad;
    private final BeanPostConstructListener beanPostConstructListener;
    private volatile BeanPersistController persistController;
    private volatile BeanPersistListener persistListener;
    private final BeanQueryAdapter queryAdapter;
    private final BeanFindController beanFinder;
    private final ChangeLogFilter changeLogFilter;
    private final boolean abstractType;
    private final BeanProperty idProperty;
    private final int idPropertyIndex;
    private final BeanProperty versionProperty;
    private final int versionPropertyIndex;
    private final BeanProperty whenModifiedProperty;
    private final BeanProperty whenCreatedProperty;
    private final int[] unloadProperties;
    private final BeanProperty[] propertiesMutable;
    private final BeanPropertyAssocOne<?> unidirectional;
    private final BeanProperty orderColumn;
    private final BeanProperty[] propertiesNonMany;
    private final BeanProperty[] propertiesAggregate;
    private final BeanPropertyAssocMany<?>[] propertiesMany;
    private final BeanPropertyAssocMany<?>[] propertiesManySave;
    private final BeanPropertyAssocMany<?>[] propertiesManyDelete;
    private final BeanPropertyAssocMany<?>[] propertiesManyToMany;
    private final BeanPropertyAssocOne<?>[] propertiesOne;
    private final BeanPropertyAssocOne<?>[] propertiesOneImported;
    private final BeanPropertyAssocOne<?>[] propertiesOneImportedSave;
    private final BeanPropertyAssocOne<?>[] propertiesOneImportedDelete;
    private final BeanPropertyAssocOne<?>[] propertiesOneExportedSave;
    private final BeanPropertyAssocOne<?>[] propertiesOneExportedDelete;
    private final BeanPropertyAssocOne<?>[] propertiesEmbedded;
    private final BeanProperty[] propertiesBaseScalar;
    private final BeanProperty[] propertiesTransient;
    private final BeanProperty[] propertiesNonTransient;
    final BeanProperty[] propertiesIndex;
    private final BeanProperty[] propertiesGenInsert;
    private final BeanProperty[] propertiesGenUpdate;
    private final List<BeanProperty[]> propertiesUnique = new ArrayList<BeanProperty[]>();
    private final boolean idOnlyReference;
    private BeanNaturalKey beanNaturalKey;
    private final String fullName;
    private boolean saveRecurseSkippable;
    private boolean deleteRecurseSkippable;
    private final EntityBean prototypeEntityBean;
    private final IdBinder idBinder;
    private String idBinderInLHSSql;
    private String idBinderIdSql;
    private String deleteByIdSql;
    private String deleteByIdInSql;
    private String whereIdInSql;
    private String softDeleteByIdSql;
    private String softDeleteByIdInSql;
    private final String name;
    private final String baseTableAlias;
    private final boolean cacheSharableBeans;
    private final BeanDescriptorCacheHelp<T> cacheHelp;
    private final BeanDescriptorJsonHelp<T> jsonHelp;
    private final String defaultSelectClause;
    private SpiEbeanServer ebeanServer;

    public BeanDescriptor(BeanDescriptorMap owner, DeployBeanDescriptor<T> deploy) {
        this.owner = owner;
        this.multiValueSupported = owner.isMultiValueSupported();
        this.entityType = deploy.getEntityType();
        this.properties = deploy.propertyNames();
        this.name = InternString.intern(deploy.getName());
        this.baseTableAlias = "t0";
        this.fullName = InternString.intern(deploy.getFullName());
        this.beanType = deploy.getBeanType();
        this.rootBeanType = PersistenceContextUtil.root(this.beanType);
        this.prototypeEntityBean = this.createPrototypeEntityBean(this.beanType);
        this.iudMetrics = new BeanIudMetrics(this.name);
        this.beanFinder = deploy.getBeanFinder();
        this.persistController = deploy.getPersistController();
        this.persistListener = deploy.getPersistListener();
        this.beanPostConstructListener = deploy.getPostConstructListener();
        this.beanPostLoad = deploy.getPostLoad();
        this.queryAdapter = deploy.getQueryAdapter();
        this.changeLogFilter = deploy.getChangeLogFilter();
        this.defaultSelectClause = deploy.getDefaultSelectClause();
        this.identityMode = deploy.buildIdentityMode();
        this.idType = this.identityMode.getIdType();
        this.idGeneratedValue = deploy.isIdGeneratedValue();
        this.idGenerator = deploy.getIdGenerator();
        this.selectLastInsertedId = deploy.getSelectLastInsertedId();
        this.concurrencyMode = deploy.getConcurrencyMode();
        this.indexDefinitions = deploy.getIndexDefinitions();
        this.historySupport = deploy.isHistorySupport();
        this.baseTable = InternString.intern(deploy.getBaseTable());
        this.baseTableAsOf = deploy.getBaseTableAsOf();
        this.primaryKeyJoin = deploy.getPrimaryKeyJoin();
        this.baseTableVersionsBetween = deploy.getBaseTableVersionsBetween();
        this.dependentTables = deploy.getDependentTables();
        this.dbComment = deploy.getDbComment();
        this.partitionMeta = deploy.getPartitionMeta();
        this.tablespaceMeta = deploy.getTablespaceMeta();
        this.storageEngine = deploy.getStorageEngine();
        this.autoTunable = this.entityType == EntityType.ORM || this.entityType == EntityType.VIEW;
        DeployBeanPropertyLists listHelper = new DeployBeanPropertyLists(owner, this, deploy);
        this.softDeleteProperty = listHelper.getSoftDeleteProperty();
        this.softDelete = this.softDeleteProperty != null && !this.softDeleteProperty.isFormula();
        this.idProperty = listHelper.getId();
        this.versionProperty = listHelper.getVersionProperty();
        this.unmappedJson = listHelper.getUnmappedJson();
        this.tenant = listHelper.getTenant();
        this.propMap = listHelper.getPropertyMap();
        this.propertiesTransient = listHelper.getTransients();
        this.propertiesNonTransient = listHelper.getNonTransients();
        this.propertiesBaseScalar = listHelper.getBaseScalar();
        this.propertiesEmbedded = listHelper.getEmbedded();
        this.propertiesMutable = listHelper.getMutable();
        this.unidirectional = listHelper.getUnidirectional();
        this.orderColumn = listHelper.getOrderColumn();
        this.propertiesOne = listHelper.getOnes();
        this.propertiesOneExportedSave = listHelper.getOneExportedSave();
        this.propertiesOneExportedDelete = listHelper.getOneExportedDelete();
        this.propertiesOneImported = listHelper.getOneImported();
        this.propertiesOneImportedSave = listHelper.getOneImportedSave();
        this.propertiesOneImportedDelete = listHelper.getOneImportedDelete();
        this.propertiesMany = listHelper.getMany();
        this.propertiesNonMany = listHelper.getNonMany();
        this.propertiesAggregate = listHelper.getAggregates();
        this.propertiesManySave = listHelper.getManySave();
        this.propertiesManyDelete = listHelper.getManyDelete();
        this.propertiesManyToMany = listHelper.getManyToMany();
        this.propertiesGenInsert = listHelper.getGeneratedInsert();
        this.propertiesGenUpdate = listHelper.getGeneratedUpdate();
        this.idOnlyReference = this.isIdOnlyReference(this.propertiesBaseScalar);
        boolean noRelationships = this.propertiesOne.length + this.propertiesMany.length == 0;
        this.cacheSharableBeans = noRelationships && deploy.getCacheOptions().isReadOnly();
        this.cacheHelp = new BeanDescriptorCacheHelp(this, owner.cacheManager(), deploy.getCacheOptions(), this.cacheSharableBeans, this.propertiesOneImported);
        this.jsonHelp = this.initJsonHelp();
        this.saveRecurseSkippable = 0 == this.propertiesOneExportedSave.length + this.propertiesOneImportedSave.length + this.propertiesManySave.length;
        this.deleteRecurseSkippable = 0 == this.propertiesOneExportedDelete.length + this.propertiesOneImportedDelete.length + this.propertiesManyDelete.length;
        this.idBinder = owner.createIdBinder(this.idProperty);
        this.whenModifiedProperty = this.findWhenModifiedProperty();
        this.whenCreatedProperty = this.findWhenCreatedProperty();
        this.abstractType = Modifier.isAbstract(this.beanType.getModifiers());
        if (this.abstractType) {
            this.idPropertyIndex = -1;
            this.versionPropertyIndex = -1;
            this.unloadProperties = new int[0];
            this.propertiesIndex = new BeanProperty[0];
        } else {
            EntityBeanIntercept ebi = this.prototypeEntityBean._ebean_getIntercept();
            this.idPropertyIndex = this.idProperty == null ? -1 : ebi.findProperty(this.idProperty.name());
            this.versionPropertyIndex = this.versionProperty == null ? -1 : ebi.findProperty(this.versionProperty.name());
            this.unloadProperties = this.derivePropertiesToUnload(this.prototypeEntityBean);
            this.propertiesIndex = new BeanProperty[ebi.propertyLength()];
            for (int i = 0; i < this.propertiesIndex.length; ++i) {
                this.propertiesIndex[i] = this.propMap.get(ebi.property(i));
            }
        }
    }

    public String idSelect() {
        if (this.idBinder == null) {
            throw new UnsupportedOperationException();
        }
        return this.idBinder.idSelect();
    }

    public boolean isJacksonCorePresent() {
        return this.owner.isJacksonCorePresent();
    }

    private BeanDescriptorJsonHelp<T> initJsonHelp() {
        return this.isJacksonCorePresent() ? new BeanDescriptorJsonHelp(this) : null;
    }

    private boolean isIdOnlyReference(BeanProperty[] baseScalar) {
        for (BeanProperty beanProperty : baseScalar) {
            if (beanProperty.isGeneratedOnInsert()) continue;
            return true;
        }
        return false;
    }

    private int[] derivePropertiesToUnload(EntityBean prototypeEntityBean) {
        boolean[] loaded = prototypeEntityBean._ebean_getIntercept().loaded();
        int[] props = new int[loaded.length];
        int pos = 0;
        for (int i = 0; i < loaded.length; ++i) {
            if (!loaded[i]) continue;
            props[pos++] = i;
        }
        if (pos == 0) {
            return new int[0];
        }
        int[] unload = new int[pos];
        System.arraycopy(props, 0, unload, 0, pos);
        return unload;
    }

    EntityBean createPrototypeEntityBean(Class<T> beanType) {
        if (Modifier.isAbstract(beanType.getModifiers())) {
            return null;
        }
        try {
            return (EntityBean)beanType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error trying to create the prototypeEntityBean for " + String.valueOf(beanType), e);
        }
    }

    public DatabaseBuilder.Settings config() {
        return this.owner.config();
    }

    public void setEbeanServer(SpiEbeanServer ebeanServer) {
        this.ebeanServer = ebeanServer;
        for (BeanPropertyAssocMany<?> assocMany : this.propertiesMany) {
            assocMany.setEbeanServer(ebeanServer);
        }
    }

    public SpiEbeanServer ebeanServer() {
        return this.ebeanServer;
    }

    boolean isAbstractType() {
        return this.abstractType;
    }

    public boolean isDocStoreOnly() {
        return EntityType.DOC == this.entityType;
    }

    public EntityType entityType() {
        return this.entityType;
    }

    private String[] properties() {
        return this.properties;
    }

    public BeanProperty propertyByIndex(int pos) {
        return this.propertiesIndex[pos];
    }

    void initialiseId(BeanDescriptorInitContext initContext) {
        if (this.historySupport) {
            initContext.addHistory(this.baseTable, this.baseTableAsOf);
        }
        if (this.idProperty != null) {
            this.idProperty.initialise(initContext);
        }
    }

    public void initialiseOther(BeanDescriptorInitContext initContext) {
        if (this.historySupport) {
            for (BeanPropertyAssocMany<?> manyToMany : this.propertiesManyToMany) {
                if (manyToMany.isExcludedFromHistory()) continue;
                TableJoin intersectionTableJoin = manyToMany.intersectionTableJoin();
                initContext.addHistoryIntersection(intersectionTableJoin.getTable());
            }
        }
        for (BeanProperty prop : this.propertiesAll()) {
            if (!prop.isId()) {
                prop.initialise(initContext);
            }
            prop.registerColumn(this, null);
        }
        if (this.unidirectional != null) {
            this.unidirectional.initialise(initContext);
        }
        this.idBinder.initialise();
        this.idBinderInLHSSql = this.idBinder.bindInSql(this.baseTableAlias);
        this.idBinderIdSql = this.idBinder.bindEqSql(this.baseTableAlias);
        String idBinderInLHSSqlNoAlias = this.idBinder.bindInSql(null);
        String idEqualsSql = this.idBinder.bindEqSql(null);
        this.deleteByIdSql = "delete from " + this.baseTable + " where " + idEqualsSql;
        this.whereIdInSql = " where " + idBinderInLHSSqlNoAlias + " ";
        this.deleteByIdInSql = "delete from " + this.baseTable + this.whereIdInSql;
        if (this.softDelete) {
            this.softDeleteByIdSql = "update " + this.baseTable + " set " + this.softDeleteDbSet() + " where " + idEqualsSql;
            this.softDeleteByIdInSql = "update " + this.baseTable + " set " + this.softDeleteDbSet() + " where " + idBinderInLHSSqlNoAlias + " ";
        } else {
            this.softDeleteByIdSql = null;
            this.softDeleteByIdInSql = null;
        }
        this.initNaturalKey();
    }

    private void initNaturalKey() {
        String[] naturalKey = this.cacheHelp.getNaturalKey();
        if (naturalKey != null && naturalKey.length != 0) {
            BeanProperty[] props = new BeanProperty[naturalKey.length];
            for (int i = 0; i < naturalKey.length; ++i) {
                props[i] = this.beanProperty(naturalKey[i]);
            }
            this.beanNaturalKey = new BeanNaturalKey(naturalKey, props);
        }
    }

    private boolean hasCircularImportedId() {
        for (BeanPropertyAssocOne<?> assocOne : this.propertiesOneImportedSave) {
            if (!assocOne.hasCircularImportedId(this)) continue;
            return true;
        }
        return false;
    }

    boolean hasCircularImportedIdTo(BeanDescriptor<?> sourceDesc) {
        for (BeanPropertyAssocOne<?> assocOne : this.propertiesOneImportedSave) {
            if (assocOne.targetDescriptor() != sourceDesc) continue;
            return true;
        }
        return false;
    }

    void registerColumn(String dbColumn, String path) {
        String key = dbColumn.toLowerCase();
        if (!this.columnPath.containsKey(key)) {
            this.columnPath.put(key, path);
        }
    }

    void registerTable(String baseTable, BeanPropertyAssoc<?> assocProperty) {
        if (baseTable != null) {
            this.tablePath.put(baseTable.toLowerCase(), assocProperty);
        }
    }

    void initLast() {
        for (BeanProperty prop : this.propertiesNonTransient) {
            if (!prop.isUnique()) continue;
            this.propertiesUnique.add(new BeanProperty[]{prop});
        }
        if (this.indexDefinitions != null) {
            for (IndexDefinition indexDef : this.indexDefinitions) {
                if (!indexDef.isUnique()) continue;
                this.addUniqueColumns(indexDef);
            }
        }
    }

    private void addUniqueColumns(IndexDefinition indexDef) {
        String[] cols = indexDef.getColumns();
        BeanProperty[] props = new BeanProperty[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            String propName = this.findBeanPath("", "", cols[i]);
            if (propName == null) {
                return;
            }
            props[i] = this.findProperty(propName);
        }
        if (props.length == 1) {
            for (BeanProperty[] inserted : this.propertiesUnique) {
                if (inserted.length != 1 || !inserted[0].equals(props[0])) continue;
                return;
            }
        }
        this.propertiesUnique.add(props);
    }

    void initialiseDocMapping() {
        this.batchEscalateOnCascadeInsert = this.supportBatchEscalateOnInsert();
        this.batchEscalateOnCascadeDelete = this.supportBatchEscalateOnDelete();
        for (BeanPropertyAssocMany<?> beanPropertyAssocMany : this.propertiesMany) {
            beanPropertyAssocMany.initialisePostTarget();
        }
        for (BeanPropertyAssoc beanPropertyAssoc : this.propertiesOne) {
            ((BeanPropertyAssocOne)beanPropertyAssoc).initialisePostTarget();
        }
        this.cacheHelp.deriveNotifyFlags();
    }

    private boolean supportBatchEscalateOnDelete() {
        if (this.softDelete) {
            return false;
        }
        for (BeanPropertyAssocMany<?> assocMany : this.propertiesManyDelete) {
            if (!assocMany.isCascadeDeleteEscalate()) continue;
            return true;
        }
        return false;
    }

    private boolean supportBatchEscalateOnInsert() {
        return this.idType == IdType.IDENTITY || !this.hasCircularImportedId();
    }

    public boolean isBatchEscalateOnCascade(PersistRequest.Type type) {
        return type == PersistRequest.Type.INSERT ? this.batchEscalateOnCascadeInsert : this.batchEscalateOnCascadeDelete;
    }

    public void metricPersistBatch(PersistRequest.Type type, long startNanos, int size) {
        this.iudMetrics.addBatch(type, startNanos, size);
    }

    public void metricPersistNoBatch(PersistRequest.Type type, long startNanos) {
        this.iudMetrics.addNoBatch(type, startNanos);
    }

    public void merge(EntityBean bean, EntityBean existing) {
        EntityBeanIntercept fromEbi = bean._ebean_getIntercept();
        EntityBeanIntercept toEbi = existing._ebean_getIntercept();
        int propertyLength = toEbi.propertyLength();
        String[] names = this.properties();
        for (int i = 0; i < propertyLength; ++i) {
            if (!fromEbi.isLoadedProperty(i)) continue;
            BeanProperty property = this.beanProperty(names[i]);
            if (!toEbi.isLoadedProperty(i)) {
                Object val = property.getValue(bean);
                property.setValue(existing, val);
                continue;
            }
            if (!property.isMany()) continue;
            property.merge(bean, existing);
        }
    }

    public void bindElementValue(SqlUpdate insert, Object value) {
        EntityBean bean = (EntityBean)value;
        for (BeanProperty property : this.propertiesBaseScalar) {
            insert.setParameter(property.getValue(bean));
        }
    }

    public boolean isChangeLog() {
        return this.changeLogFilter != null;
    }

    public BeanChange changeLogBean(PersistRequestBean<T> request) {
        switch (request.type()) {
            case INSERT: {
                return this.changeLogFilter.includeInsert(request) ? this.insertBeanChange(request) : null;
            }
            case UPDATE: 
            case DELETE_SOFT: {
                return this.changeLogFilter.includeUpdate(request) ? this.updateBeanChange(request) : null;
            }
            case DELETE: {
                return this.changeLogFilter.includeDelete(request) ? this.deleteBeanChange(request) : null;
            }
        }
        throw new IllegalStateException("Unhandled request type " + String.valueOf((Object)request.type()));
    }

    private BeanChange beanChange(ChangeType type, Object id, String data, String oldData) {
        Object tenantId = this.ebeanServer.currentTenantId();
        return new BeanChange(this.name, tenantId, id, type, data, oldData);
    }

    private BeanChange deleteBeanChange(PersistRequestBean<T> request) {
        return this.beanChange(ChangeType.DELETE, request.beanId(), null, null);
    }

    private BeanChange updateBeanChange(PersistRequestBean<T> request) {
        try {
            BeanChangeJson changeJson = new BeanChangeJson(this, request.isStatelessUpdate());
            request.intercept().addDirtyPropertyValues((BeanDiffVisitor)changeJson);
            changeJson.flush();
            return this.beanChange(ChangeType.UPDATE, request.beanId(), changeJson.newJson(), changeJson.oldJson());
        }
        catch (RuntimeException e) {
            log.log(System.Logger.Level.ERROR, "Failed to write ChangeLog entry for update", (Throwable)e);
            return null;
        }
    }

    private BeanChange insertBeanChange(PersistRequestBean<T> request) {
        try {
            StringWriter writer = new StringWriter(200);
            SpiJsonWriter jsonWriter = this.createJsonWriter(writer);
            this.jsonWriteForInsert(jsonWriter, request.entityBean());
            jsonWriter.flush();
            return this.beanChange(ChangeType.INSERT, request.beanId(), writer.toString(), null);
        }
        catch (IOException e) {
            log.log(System.Logger.Level.ERROR, "Failed to write ChangeLog entry for insert", (Throwable)e);
            return null;
        }
    }

    SpiJsonWriter createJsonWriter(StringWriter writer) {
        return this.ebeanServer.jsonExtended().createJsonWriter(writer);
    }

    SpiJsonReader createJsonReader(String json) {
        return this.ebeanServer.jsonExtended().createJsonRead(this, json);
    }

    void jsonWriteForInsert(SpiJsonWriter jsonWriter, EntityBean newBean) throws IOException {
        jsonWriter.writeStartObject();
        for (BeanProperty beanProperty : this.propertiesBaseScalar) {
            beanProperty.jsonWriteForInsert(jsonWriter, newBean);
        }
        for (BeanProperty beanProperty : this.propertiesOne) {
            ((BeanPropertyAssocOne)beanProperty).jsonWriteForInsert(jsonWriter, newBean);
        }
        for (BeanProperty beanProperty : this.propertiesEmbedded) {
            ((BeanPropertyAssocOne)beanProperty).jsonWriteForInsert(jsonWriter, newBean);
        }
        jsonWriter.writeEndObject();
    }

    public SqlUpdate deleteById(Object id, List<Object> idList, DeleteMode mode) {
        if (id != null) {
            return this.deleteById(id, mode);
        }
        return this.deleteByIdList(idList, mode);
    }

    public String whereIdInSql() {
        return this.whereIdInSql;
    }

    public String deleteByIdInSql() {
        return this.deleteByIdInSql;
    }

    private SqlUpdate deleteByIdList(List<Object> idList, DeleteMode mode) {
        String baseSql = mode.isHard() ? this.deleteByIdInSql : this.softDeleteByIdInSql;
        StringBuilder sb = new StringBuilder(baseSql);
        String inClause = this.idBinder.idInValueExprDelete(idList.size());
        sb.append(inClause);
        DefaultSqlUpdate delete = new DefaultSqlUpdate(sb.toString());
        this.idBinder.addBindValues(delete, idList);
        return delete;
    }

    private SqlUpdate deleteById(Object id, DeleteMode mode) {
        Object[] bindValues;
        String baseSql = mode.isHard() ? this.deleteByIdSql : this.softDeleteByIdSql;
        DefaultSqlUpdate sqlDelete = new DefaultSqlUpdate(baseSql);
        for (Object bindValue : bindValues = this.idBinder.bindValues(id)) {
            sqlDelete.setParameter(bindValue);
        }
        return sqlDelete;
    }

    public void add(BeanFkeyProperty fkey) {
        this.elDeployCache.put(fkey.name(), fkey);
    }

    void initialiseFkeys() {
        for (BeanPropertyAssocOne<?> oneImported : this.propertiesOneImported) {
            if (oneImported.isFormula()) continue;
            oneImported.addFkey();
        }
    }

    public CacheOptions cacheOptions() {
        return this.cacheHelp.getCacheOptions();
    }

    public EncryptKey encryptKey(BeanProperty p) {
        return this.owner.encryptKey(this.baseTable, p.dbColumn());
    }

    public EncryptKey encryptKey(String tableName, String columnName) {
        return this.owner.encryptKey(tableName, columnName);
    }

    public ScalarType<?> scalarType(int jdbcType) {
        return this.owner.scalarType(jdbcType);
    }

    public ScalarType<?> scalarType(String cast) {
        return this.owner.scalarType(cast);
    }

    public boolean hasDefaultSelectClause() {
        return this.defaultSelectClause != null;
    }

    public String defaultSelectClause() {
        return this.defaultSelectClause;
    }

    public void prepareQuery(SpiQuery<T> query) {
        Object tenantId;
        if (this.tenant != null && !query.isNativeSql() && (tenantId = this.ebeanServer.currentTenantId()) != null) {
            this.tenant.addTenant(query, tenantId);
        }
    }

    public BeanNaturalKey naturalKey() {
        return this.beanNaturalKey;
    }

    public boolean isBeanCaching() {
        return this.cacheHelp.isBeanCaching();
    }

    public boolean isNaturalKeyCaching() {
        return this.cacheHelp.isNaturalKeyCaching();
    }

    public boolean isQueryCaching() {
        return this.cacheHelp.isQueryCaching();
    }

    public boolean isManyPropCaching() {
        return this.isBeanCaching();
    }

    public boolean isCacheNotify(PersistRequest.Type type) {
        return this.cacheHelp.isCacheNotify(type);
    }

    public void clearBeanCache() {
        this.cacheHelp.beanCacheClear();
    }

    public void clearQueryCache() {
        this.cacheHelp.queryCacheClear();
    }

    public Object queryCacheGet(Object id) {
        return this.cacheHelp.queryCacheGet(id);
    }

    public void queryCachePut(Object id, QueryCacheEntry entry) {
        this.cacheHelp.queryCachePut(id, entry);
    }

    public boolean cacheManyPropLoad(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, String parentKey, Boolean readOnly) {
        return this.cacheHelp.manyPropLoad(many, bc, parentKey, readOnly);
    }

    public void cacheManyPropPut(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, String parentKey) {
        this.cacheHelp.manyPropPut(many, bc, parentKey);
    }

    public void cacheManyPropPut(String name, String parentKey, CachedManyIds entry) {
        this.cacheHelp.cachePutManyIds(name, parentKey, entry);
    }

    public void cacheManyPropRemove(String propertyName, String parentKey) {
        this.cacheHelp.manyPropRemove(propertyName, parentKey);
    }

    public void cacheManyPropClear(String propertyName) {
        this.cacheHelp.manyPropClear(propertyName);
    }

    public CachedBeanData cacheEmbeddedBeanExtract(EntityBean bean) {
        return this.cacheHelp.beanExtractData(this, bean);
    }

    public EntityBean cacheEmbeddedBeanLoad(CachedBeanData data, PersistenceContext context) {
        return this.cacheHelp.embeddedBeanLoad(data, context);
    }

    EntityBean cacheEmbeddedBeanLoadDirect(CachedBeanData data, PersistenceContext context) {
        return this.cacheHelp.embeddedBeanLoadDirect(data, context);
    }

    EntityBean cacheBeanLoadDirect(Object id, Boolean readOnly, CachedBeanData data, PersistenceContext context) {
        return this.cacheHelp.loadBeanDirect(id, readOnly, data, context);
    }

    public void cacheBeanPut(T bean) {
        this.cacheBeanPut((EntityBean)bean);
    }

    public void cacheBeanPut(EntityBean bean) {
        this.cacheHelp.beanCachePut(bean);
    }

    public void cacheBeanPutAll(Collection<?> beans) {
        if (!beans.isEmpty()) {
            this.cacheHelp.beanPutAll(beans);
        }
    }

    void cacheBeanPutAllDirect(Collection<EntityBean> beans) {
        this.cacheHelp.beanCachePutAllDirect(beans);
    }

    void cacheBeanPutDirect(EntityBean bean) {
        this.cacheHelp.beanCachePutDirect(bean);
    }

    public T cacheBeanGet(Object id, Boolean readOnly, PersistenceContext context) {
        return this.cacheHelp.beanCacheGet(this.cacheKey(id), readOnly, context);
    }

    public void cacheApplyInvalidate(Collection<Object> ids) {
        ArrayList<String> keys = new ArrayList<String>(ids.size());
        for (Object id : ids) {
            keys.add(this.cacheKey(id));
        }
        this.cacheHelp.beanCacheApplyInvalidate(keys);
    }

    public Set<EntityBeanIntercept> cacheBeanLoadAll(Set<EntityBeanIntercept> batch, PersistenceContext persistenceContext, int lazyLoadProperty, String propertyName) {
        return this.cacheHelp.beanCacheLoadAll(batch, persistenceContext, lazyLoadProperty, propertyName);
    }

    public boolean cacheBeanLoad(EntityBean bean, EntityBeanIntercept ebi, Object id, PersistenceContext context) {
        return this.cacheHelp.beanCacheLoad(bean, ebi, this.cacheKey(id), context);
    }

    public BeanCacheResult<T> cacheIdLookup(PersistenceContext context, Collection<?> ids) {
        return this.cacheHelp.cacheIdLookup(context, ids);
    }

    public BeanCacheResult<T> naturalKeyLookup(PersistenceContext context, Set<Object> keys) {
        return this.cacheHelp.naturalKeyLookup(context, keys);
    }

    public void cacheNaturalKeyPut(String key, String newKey) {
        this.cacheHelp.cacheNaturalKeyPut(key, newKey);
    }

    public void cacheUpdateQuery(boolean update, SpiTransaction transaction) {
        this.cacheHelp.cacheUpdateQuery(update, transaction);
    }

    void cachePersistTableIUD(TransactionEventTable.TableIUD tableIUD, CacheChangeSet changeSet) {
        this.cacheHelp.persistTableIUD(tableIUD, changeSet);
    }

    public void cachePersistDeleteByIds(Collection<Object> ids, CacheChangeSet changeSet) {
        this.cacheHelp.persistDeleteIds(ids, changeSet);
    }

    public void cachePersistDelete(Object id, PersistRequestBean<T> deleteRequest, CacheChangeSet changeSet) {
        this.cacheHelp.persistDelete(id, deleteRequest, changeSet);
    }

    public void cachePersistInsert(PersistRequestBean<T> insertRequest, CacheChangeSet changeSet) {
        this.cacheHelp.persistInsert(insertRequest, changeSet);
    }

    public void cachePersistUpdate(Object id, PersistRequestBean<T> updateRequest, CacheChangeSet changeSet) {
        this.cacheHelp.persistUpdate(id, updateRequest, changeSet);
    }

    public void cacheApplyBeanUpdate(String key, Map<String, Object> changes, boolean updateNaturalKey, long version) {
        this.cacheHelp.cacheBeanUpdate(key, changes, updateNaturalKey, version);
    }

    public String baseTableAlias() {
        return this.baseTableAlias;
    }

    public void preAllocateIds(int batchSize) {
        if (this.idGenerator != null) {
            this.idGenerator.preAllocateIds(batchSize);
        }
    }

    public Object nextId(Transaction t) {
        if (this.idGenerator != null) {
            return this.idGenerator.nextId(t);
        }
        return null;
    }

    public DeployPropertyParser parser() {
        return new DeployPropertyParser(this);
    }

    public String convertOrmUpdateToSql(String ormUpdateStatement) {
        return new DeployUpdateParser(this).parse(ormUpdateStatement);
    }

    void queryPlanInit(QueryPlanInit request, List<MetaQueryPlan> list) {
        for (CQueryPlan queryPlan : this.queryPlanCache.values()) {
            if (!request.includeHash(queryPlan.hash())) continue;
            queryPlan.queryPlanInit(request.thresholdMicros());
            list.add(queryPlan.createMeta(null, null));
        }
    }

    public void visitMetrics(MetricVisitor visitor) {
        this.iudMetrics.visit(visitor);
        for (CQueryPlan queryPlan : this.queryPlanCache.values()) {
            if (queryPlan.isEmptyStats()) continue;
            visitor.visitQuery((MetaQueryMetric)queryPlan.visit(visitor));
        }
    }

    public void clearQueryStatistics() {
        for (CQueryPlan queryPlan : this.queryPlanCache.values()) {
            queryPlan.resetStatistics();
        }
    }

    void trimQueryPlans(long unusedSince) {
        this.queryPlanCache.values().removeIf(queryPlan -> queryPlan.lastQueryTime() < unusedSince);
    }

    @Override
    public void postLoad(Object bean) {
        if (this.beanPostLoad != null) {
            this.beanPostLoad.postLoad(bean);
        }
    }

    public CQueryPlan queryPlan(CQueryPlanKey key) {
        return this.queryPlanCache.get(key);
    }

    public void queryPlan(CQueryPlanKey key, CQueryPlan plan) {
        this.queryPlanCache.put(key, plan);
    }

    public SpiUpdatePlan updatePlan(String key) {
        return this.updatePlanCache.get(key);
    }

    public void updatePlan(String key, SpiUpdatePlan plan) {
        this.updatePlanCache.put(key, plan);
    }

    public String updateImportedIdSql(ImportedId prop) {
        return "update " + this.baseTable + " set " + prop.importedIdClause() + " where " + this.idBinder.bindEqSql(null);
    }

    boolean isSaveRecurseSkippable() {
        return this.saveRecurseSkippable;
    }

    boolean isDeleteRecurseSkippable() {
        return this.deleteRecurseSkippable;
    }

    public boolean isDeleteByStatement() {
        return this.persistListener == null && this.persistController == null && this.deleteRecurseSkippable && !this.isBeanCaching();
    }

    public boolean isDeleteByBulk() {
        return this.persistListener == null && this.persistController == null && this.propertiesManyToMany.length == 0;
    }

    public BeanProperty whenModifiedProperty() {
        return this.whenModifiedProperty;
    }

    public BeanProperty whenCreatedProperty() {
        return this.whenCreatedProperty;
    }

    private BeanProperty findWhenCreatedProperty() {
        for (BeanProperty baseScalar : this.propertiesBaseScalar) {
            if (!baseScalar.isGeneratedWhenCreated()) continue;
            return baseScalar;
        }
        return null;
    }

    private BeanProperty findWhenModifiedProperty() {
        for (BeanProperty baseScalar : this.propertiesBaseScalar) {
            if (!baseScalar.isGeneratedWhenModified()) continue;
            return baseScalar;
        }
        return null;
    }

    public BeanPropertyAssocMany<?> manyProperty(SpiQuery<?> query) {
        OrmQueryDetail detail = query.detail();
        for (BeanPropertyAssocMany<?> many : this.propertiesMany) {
            if (!detail.includesPath(many.name())) continue;
            return many;
        }
        return null;
    }

    String parentIdInExpr(int parentIdSize, String rawWhere) {
        String inClause = this.idBinder.idInValueExpr(false, parentIdSize);
        return this.idBinder.isIdInExpandedForm() ? inClause : rawWhere + inClause;
    }

    @Override
    public IdBinder idBinder() {
        return this.idBinder;
    }

    boolean isSimpleId() {
        return this.idBinder instanceof IdBinderSimple;
    }

    @Override
    public boolean hasId() {
        return this.idProperty != null;
    }

    public boolean hasSingleIdProperty() {
        return this.idPropertyIndex != -1;
    }

    public boolean isMultiValueIdSupported() {
        return this.multiValueSupported && this.isSimpleId();
    }

    public boolean isPadInExpression() {
        return !this.multiValueSupported && this.isSimpleId();
    }

    public String idBinderIdSql(String alias) {
        if (alias == null) {
            return this.idBinderIdSql;
        }
        return this.idBinder.bindEqSql(alias);
    }

    public String idBinderInLHSSql() {
        return this.idBinderInLHSSql;
    }

    public void bindId(DataBind dataBind, Object idValue) throws SQLException {
        this.idBinder.bindId(dataBind, idValue);
    }

    public Object[] bindIdValues(Object idValue) {
        return this.idBinder.bindValues(idValue);
    }

    public T createBean() {
        return (T)this.createEntityBean(true);
    }

    private EntityBean createEntityBean(boolean isNew) {
        if (this.prototypeEntityBean == null) {
            throw new UnsupportedOperationException("cannot create entity bean for abstract entity " + this.name());
        }
        try {
            EntityBean bean = (EntityBean)this.prototypeEntityBean._ebean_newInstance();
            if (this.beanPostConstructListener != null) {
                this.beanPostConstructListener.autowire((Object)bean);
                this.beanPostConstructListener.postConstruct((Object)bean);
            }
            if (isNew) {
                if (this.beanPostConstructListener != null) {
                    this.beanPostConstructListener.postCreate((Object)bean);
                }
            } else if (this.unloadProperties.length > 0) {
                EntityBeanIntercept ebi = bean._ebean_getIntercept();
                for (int unloadProperty : this.unloadProperties) {
                    ebi.setPropertyUnloaded(unloadProperty);
                }
            }
            return bean;
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    @Override
    public EntityBean createEntityBean() {
        return this.createEntityBean(false);
    }

    @Override
    public EntityBean createEntityBean2(boolean readOnlyNoIntercept) {
        if (readOnlyNoIntercept) {
            return (EntityBean)this.prototypeEntityBean._ebean_newInstanceReadOnly();
        }
        return this.createEntityBean(false);
    }

    public EntityBean createEntityBeanForJson() {
        return this.createEntityBean();
    }

    private T findReferenceBean(Object id, PersistenceContext pc) {
        DefaultOrmQuery query = new DefaultOrmQuery(this, this.ebeanServer, this.ebeanServer.expressionFactory());
        query.setPersistenceContext(pc);
        return (T)query.setId(id).findOne();
    }

    public EntityBean createReference(Boolean readOnly, Object id, PersistenceContext pc) {
        Object refBean = this.contextGet(pc, id);
        if (refBean == null) {
            refBean = this.createReference(readOnly, false, id, pc);
        }
        return (EntityBean)refBean;
    }

    public T createReference(Boolean readOnly, boolean disableLazyLoad, Object id, PersistenceContext pc) {
        Object shareableBean;
        CachedBeanData d;
        if (this.cacheSharableBeans && !disableLazyLoad && !Boolean.FALSE.equals(readOnly) && (d = this.cacheHelp.beanCacheGetData(this.cacheKey(id))) != null && (shareableBean = d.getSharableBean()) != null) {
            return (T)shareableBean;
        }
        try {
            EntityBean eb = this.createEntityBean();
            id = this.convertSetId(id, eb);
            EntityBeanIntercept ebi = eb._ebean_getIntercept();
            if (disableLazyLoad) {
                ebi.setDisableLazyLoad(true);
            } else {
                ebi.setBeanLoader((BeanLoader)this.refBeanLoader());
            }
            ebi.setReference(this.idPropertyIndex);
            if (Boolean.TRUE == readOnly) {
                ebi.setReadOnly(true);
            }
            if (pc != null) {
                this.contextPut(pc, id, eb);
                ebi.setPersistenceContext(pc);
            }
            return (T)eb;
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    SingleBeanLoader refBeanLoader() {
        return new SingleBeanLoader.Ref((Database)this.ebeanServer);
    }

    SingleBeanLoader l2BeanLoader() {
        return new SingleBeanLoader.L2((Database)this.ebeanServer);
    }

    public T createReference(Object id, PersistenceContext pc) {
        return this.createRef(id, pc);
    }

    public T createRef(Object id, PersistenceContext pc) {
        try {
            EntityBean eb = this.createEntityBean();
            id = this.convertSetId(id, eb);
            EntityBeanIntercept ebi = eb._ebean_getIntercept();
            ebi.setBeanLoader((BeanLoader)this.refBeanLoader());
            ebi.setReference(this.idPropertyIndex);
            if (pc != null) {
                this.contextPut(pc, id, eb);
                ebi.setPersistenceContext(pc);
            }
            return (T)eb;
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    @Override
    public BeanProperty findPropertyFromPath(String path) {
        BeanDescriptor other = this;
        String[] split;
        while ((split = SplitName.splitBegin((String)path))[1] != null) {
            BeanPropertyAssoc assocProp = (BeanPropertyAssoc)other._findBeanProperty(split[0]);
            if (assocProp == null) {
                throw new IllegalStateException("Unknown property path " + split[0] + " from " + path);
            }
            BeanDescriptor targetDesc = assocProp.targetDescriptor();
            path = split[1];
            other = targetDesc;
        }
        return other._findBeanProperty(split[0]);
    }

    public BeanType<?> beanTypeAtPath(String path) {
        return this.descriptor(path);
    }

    public BeanDescriptor<?> descriptor(String path) {
        BeanDescriptor result = this;
        while (true) {
            if (path == null) {
                return result;
            }
            String[] splitBegin = SplitName.splitBegin((String)path);
            BeanProperty beanProperty = result.findProperty(splitBegin[0]);
            if (!(beanProperty instanceof BeanPropertyAssoc)) break;
            BeanPropertyAssoc assocProp = (BeanPropertyAssoc)beanProperty;
            path = splitBegin[1];
            result = assocProp.targetDescriptor();
        }
        throw new PersistenceException("Invalid path " + path + " from " + result.fullName());
    }

    public <U> BeanDescriptor<U> descriptor(Class<U> otherType) {
        return this.owner.descriptor(otherType);
    }

    public boolean isTableManaged(String tableName) {
        return this.owner.isTableManaged(tableName);
    }

    public BeanProperty orderColumn() {
        return this.orderColumn;
    }

    public BeanPropertyAssocOne<?> unidirectional() {
        return this.unidirectional;
    }

    public boolean isUseIdGenerator() {
        return this.idGenerator != null;
    }

    public String descriptorId() {
        return this.fullName;
    }

    public Class<T> type() {
        return this.beanType;
    }

    public String fullName() {
        return this.fullName;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String simpleName() {
        return this.beanType.getSimpleName();
    }

    public String toString() {
        return this.fullName;
    }

    public Object contextGet(PersistenceContext pc, Object id) {
        return pc.get(this.rootBeanType, id);
    }

    public PersistenceContext.WithOption contextGetWithOption(PersistenceContext pc, Object id) {
        return pc.getWithOption(this.rootBeanType, id);
    }

    public void contextPut(PersistenceContext pc, Object id, Object bean) {
        pc.put(this.rootBeanType, id, bean);
    }

    @Override
    public Object contextPutIfAbsent(PersistenceContext pc, Object id, EntityBean localBean) {
        return pc.putIfAbsent(this.rootBeanType, id, (Object)localBean);
    }

    public Object contextRef(PersistenceContext pc, Boolean readOnly, boolean disableLazyLoad, Object id) {
        return this.createReference(readOnly, disableLazyLoad, id, pc);
    }

    public void contextClear(PersistenceContext pc, Object idValue) {
        pc.clear(this.rootBeanType, idValue);
    }

    public void contextClear(PersistenceContext pc) {
        pc.clear(this.rootBeanType);
    }

    public void contextDeleted(PersistenceContext pc, Object idValue) {
        pc.deleted(this.rootBeanType, idValue);
    }

    public String idName() {
        return this.idProperty == null ? null : this.idProperty.name();
    }

    public Object getId(EntityBean bean) {
        return this.idProperty == null ? null : this.idProperty.getValueIntercept(bean);
    }

    public String cacheKeyForBean(EntityBean bean) {
        return this.cacheKey(this.idProperty.getValue(bean));
    }

    public String cacheKey(Object id) {
        return this.idBinder.cacheKey(id);
    }

    public Object id(Object bean) {
        return this.getId((EntityBean)bean);
    }

    public Object idForJson(Object bean) {
        return this.idBinder.convertForJson((EntityBean)bean);
    }

    Object convertIdFromJson(Object idValue) {
        return this.idBinder.convertFromJson(idValue);
    }

    public String defaultOrderBy() {
        return this.idBinder.orderBy();
    }

    public Object convertId(Object idValue) {
        return this.idBinder.convertId(idValue);
    }

    public void setId(T bean, Object idValue) {
        this.idBinder.convertSetId(idValue, (EntityBean)bean);
    }

    public Object convertSetId(Object idValue, EntityBean bean) {
        return this.idBinder.convertSetId(idValue, bean);
    }

    public void setId(Object idValue, EntityBean bean) {
        this.idProperty.setValueIntercept(bean, idValue);
    }

    public Property property(String propName) {
        return this.findProperty(propName);
    }

    public BeanProperty beanProperty(String propName) {
        return this.propMap.get(propName);
    }

    public void sort(List<T> list, String sortByClause) {
        list.sort(this.elComparator(sortByClause));
    }

    public ElComparator<T> elComparator(String propNameOrSortBy) {
        return this.comparatorCache.computeIfAbsent(propNameOrSortBy, this::createComparator);
    }

    public void lazyLoadRegister(String prefix, EntityBeanIntercept ebi, EntityBean bean, LoadContext loadContext) {
        for (BeanPropertyAssocMany<?> many : this.propertiesMany()) {
            BeanCollection<?> ref;
            if (ebi.isLoadedProperty(many.propertyIndex()) || (ref = many.createReferenceIfNull(bean)) == null || ref.isRegisteredWithLoadContext()) continue;
            String path = SplitName.add((String)prefix, (String)many.name());
            loadContext.register(path, many, ref);
        }
    }

    public boolean lazyLoadMany(EntityBeanIntercept ebi) {
        return this.lazyLoadMany(ebi, null);
    }

    public boolean lazyLoadMany(EntityBeanIntercept ebi, LoadBeanContext parent) {
        int lazyLoadProperty = ebi.lazyLoadPropertyIndex();
        if (lazyLoadProperty == -1) {
            return false;
        }
        return this.lazyLoadMany(ebi, lazyLoadProperty, parent);
    }

    public boolean isGeneratedProperty(int propertyIndex) {
        return this.propertiesIndex[propertyIndex].isGenerated();
    }

    private boolean lazyLoadMany(EntityBeanIntercept ebi, int lazyLoadProperty, LoadBeanContext loadBeanContext) {
        BeanProperty lazyLoadBeanProp = this.propertiesIndex[lazyLoadProperty];
        if (lazyLoadBeanProp instanceof BeanPropertyAssocMany) {
            BeanPropertyAssocMany manyProp = (BeanPropertyAssocMany)lazyLoadBeanProp;
            BeanCollection<?> collection = manyProp.createReference(ebi.owner());
            ebi.setLoadedLazy();
            if (loadBeanContext != null) {
                loadBeanContext.register(manyProp, collection);
            }
            return true;
        }
        return false;
    }

    private ElComparator<T> createComparator(String sortByClause) {
        SortByClause sortBy = SortByClauseParser.parse(sortByClause);
        if (sortBy.size() == 1) {
            return this.createPropertyComparator(sortBy.getProperties().get(0));
        }
        ElComparator[] comparators = new ElComparator[sortBy.size()];
        List<SortByClause.Property> sortProps = sortBy.getProperties();
        for (int i = 0; i < sortProps.size(); ++i) {
            SortByClause.Property sortProperty = sortProps.get(i);
            comparators[i] = this.createPropertyComparator(sortProperty);
        }
        return new ElComparatorCompound(comparators);
    }

    private ElComparator<T> createPropertyComparator(SortByClause.Property sortProp) {
        ElPropertyValue elGetValue = this.elGetValue(sortProp.getName());
        if (elGetValue == null) {
            log.log(System.Logger.Level.ERROR, "Sort property [" + String.valueOf(sortProp) + "] not found in " + String.valueOf(this.beanType) + ". Cannot sort.");
            return new ElComparatorNoop();
        }
        if (elGetValue.isAssocMany()) {
            log.log(System.Logger.Level.ERROR, "Sort property [" + String.valueOf(sortProp) + "] in " + String.valueOf(this.beanType) + " is a many-property. Cannot sort.");
            return new ElComparatorNoop();
        }
        Boolean nullsHigh = sortProp.getNullsHigh();
        if (nullsHigh == null) {
            nullsHigh = Boolean.TRUE;
        }
        return new ElComparatorProperty(elGetValue, sortProp.isAscending(), nullsHigh);
    }

    public boolean isValidExpression(String propertyName) {
        try {
            return this.elGetValue(propertyName) != null;
        }
        catch (PersistenceException e) {
            return false;
        }
    }

    public ElPropertyValue elGetValue(String propName) {
        ElPropertyValue elGetValue = this.elCache.get(propName);
        if (elGetValue != null) {
            return elGetValue;
        }
        elGetValue = this.buildElGetValue(propName, null, false);
        if (elGetValue != null) {
            this.elCache.put(propName, elGetValue);
        }
        return elGetValue;
    }

    public ExpressionPath expressionPath(String path) {
        return this.elGetValue(path);
    }

    public ElPropertyDeploy elPropertyDeploy(String propName) {
        ElPropertyDeploy elProp = this.elDeployCache.get(propName);
        if (elProp != null) {
            return elProp;
        }
        elProp = !propName.contains(".") ? this.elGetValue(propName) : this.buildElGetValue(propName, null, true);
        if (elProp != null) {
            this.elDeployCache.put(propName, elProp);
        }
        return elProp;
    }

    ElPropertyValue buildElGetValue(String propName, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        ElPropertyDeploy fk;
        if (propertyDeploy && chain != null && (fk = this.elDeployCache.get(propName)) instanceof BeanFkeyProperty) {
            return ((BeanFkeyProperty)fk).create(chain.expression(), chain.isContainsMany());
        }
        int basePos = propName.indexOf(46);
        if (basePos > -1) {
            String baseName = propName.substring(0, basePos);
            BeanProperty assocProp = this._findBeanProperty(baseName);
            if (assocProp == null) {
                return null;
            }
            String remainder = propName.substring(basePos + 1);
            return assocProp.buildElPropertyValue(propName, remainder, chain, propertyDeploy);
        }
        BeanProperty property = this._findBeanProperty(propName);
        if (chain == null) {
            return property;
        }
        if (property == null) {
            throw new PersistenceException("No property found for [" + propName + "] in expression " + chain.expression());
        }
        if (property.containsMany()) {
            chain.setContainsMany();
        }
        return chain.add(property).build();
    }

    public String findBeanPath(String schemaName, String tableName, String columnName) {
        String relativePath;
        if (this.matchBaseTable(tableName)) {
            return this.columnPath.get(columnName);
        }
        BeanPropertyAssoc<?> assocProperty = this.tablePath.get(tableName);
        if (assocProperty == null) {
            assocProperty = this.tablePath.get(schemaName + "." + tableName);
        }
        if (assocProperty != null && (relativePath = assocProperty.targetDescriptor().findBeanPath(schemaName, tableName, columnName)) != null) {
            return SplitName.add((String)assocProperty.name(), (String)relativePath);
        }
        return null;
    }

    boolean matchBaseTable(String tableName) {
        return tableName.isEmpty() || this.baseTable.equalsIgnoreCase(tableName) || this.baseTable.endsWith("." + tableName);
    }

    private STreeProperty findSqlTreeFormula(String formula, String path) {
        String key = formula + "-" + path;
        return this.dynamicProperty.computeIfAbsent(key, fullKey -> FormulaPropertyPath.create(this, formula, path));
    }

    @Override
    public STreeProperty findPropertyWithDynamic(String propName, String path) {
        if (propName.indexOf(40) > -1) {
            return this.findSqlTreeFormula(propName, path);
        }
        return this.findProperty(propName);
    }

    @Override
    public BeanProperty findProperty(String propName) {
        int basePos = propName.indexOf(46);
        if (basePos > -1) {
            String baseName = propName.substring(0, basePos);
            return this._findBeanProperty(baseName);
        }
        return this._findBeanProperty(propName);
    }

    BeanProperty _findBeanProperty(String propName) {
        BeanProperty prop = this.propMap.get(propName);
        if (prop == null && "_$IdClass$".equals(propName)) {
            return this.idProperty;
        }
        return prop;
    }

    public void resetManyProperties(Object dbBean) {
        EntityBean bean = (EntityBean)dbBean;
        for (BeanPropertyAssocMany<?> many : this.propertiesMany) {
            if (!many.isCascadeRefresh()) continue;
            many.resetMany(bean);
        }
    }

    public boolean isCacheSharableBeans() {
        return this.cacheSharableBeans;
    }

    public boolean isAutoTunable() {
        return this.autoTunable;
    }

    public boolean isEmbedded() {
        return EntityType.EMBEDDED == this.entityType;
    }

    public IndexDefinition[] indexDefinitions() {
        return this.indexDefinitions;
    }

    public BeanPersistListener persistListener() {
        return this.persistListener;
    }

    public BeanFindController beanFinder() {
        return this.beanFinder;
    }

    public BeanFindController findController() {
        return this.beanFinder;
    }

    public BeanQueryAdapter queryAdapter() {
        return this.queryAdapter;
    }

    public void deregister(BeanPersistListener listener) {
        BeanPersistListener currentListener = this.persistListener;
        if (currentListener != null) {
            if (currentListener instanceof ChainedBeanPersistListener) {
                this.persistListener = ((ChainedBeanPersistListener)currentListener).deregister(listener);
            } else if (currentListener.equals((Object)listener)) {
                this.persistListener = null;
            }
        }
    }

    public void deregister(BeanPersistController controller) {
        BeanPersistController currentController = this.persistController;
        if (currentController != null) {
            if (currentController instanceof ChainedBeanPersistController) {
                this.persistController = ((ChainedBeanPersistController)currentController).deregister(controller);
            } else if (currentController.equals((Object)controller)) {
                this.persistController = null;
            }
        }
    }

    public void register(BeanPersistListener newPersistListener) {
        if (newPersistListener.isRegisterFor(this.beanType)) {
            BeanPersistListener currentListener = this.persistListener;
            this.persistListener = currentListener == null ? newPersistListener : (currentListener instanceof ChainedBeanPersistListener ? ((ChainedBeanPersistListener)currentListener).register(newPersistListener) : new ChainedBeanPersistListener(currentListener, newPersistListener));
        }
    }

    public void register(BeanPersistController newController) {
        if (newController.isRegisterFor(this.beanType)) {
            BeanPersistController currentController = this.persistController;
            this.persistController = currentController == null ? newController : (currentController instanceof ChainedBeanPersistController ? ((ChainedBeanPersistController)currentController).register(newController) : new ChainedBeanPersistController(currentController, newController));
        }
    }

    public BeanPersistController persistController() {
        return this.persistController;
    }

    @Override
    public boolean isRawSqlBased() {
        return EntityType.SQL == this.entityType;
    }

    public String dbComment() {
        return this.dbComment;
    }

    public boolean suppressForeignKey() {
        return this.partitionMeta != null;
    }

    public PartitionMeta partitionMeta() {
        return this.partitionMeta;
    }

    public TablespaceMeta tablespaceMeta() {
        return this.tablespaceMeta;
    }

    public String storageEngine() {
        return this.storageEngine;
    }

    public String[] dependentTables() {
        return this.dependentTables;
    }

    public String baseTable() {
        return this.baseTable;
    }

    public boolean isBaseTable() {
        return this.baseTable != null && this.entityType == EntityType.ORM;
    }

    @Override
    public String baseTable(SpiQuery.TemporalMode mode) {
        switch (mode) {
            case VERSIONS: {
                return this.baseTableVersionsBetween;
            }
            case AS_OF: {
                return this.baseTableAsOf;
            }
        }
        return this.baseTable;
    }

    @Override
    public boolean isSoftDelete() {
        return this.softDelete;
    }

    public void softDeleteValue(EntityBean bean) {
        this.softDeleteProperty.setSoftDeleteValue(bean);
    }

    String softDeleteDbSet() {
        return this.softDeleteProperty.softDeleteDbSet();
    }

    @Override
    public String softDeletePredicate(String tableAlias) {
        return this.softDeleteProperty.softDeleteDbPredicate(tableAlias);
    }

    @Override
    public void markAsDeleted(EntityBean bean) {
        if (this.softDeleteProperty == null) {
            Object id = this.getId(bean);
            log.log(System.Logger.Level.INFO, "(Lazy) loading unsuccessful for type:{0} id:{1} - expecting when bean has been deleted", this.name(), id);
            bean._ebean_getIntercept().setLazyLoadFailure(id);
        } else {
            this.softDeleteValue(bean);
            bean._ebean_getIntercept().setLoaded();
            this.setAllLoaded(bean);
        }
    }

    @Override
    public Map<String, String> pathMap(String prefix) {
        return this.pathMaps.computeIfAbsent(prefix, s -> {
            String name;
            HashMap<String, CallSite> m = new HashMap<String, CallSite>();
            for (STreePropertyAssocMany sTreePropertyAssocMany : this.propsMany()) {
                name = sTreePropertyAssocMany.name();
                m.put(name, (CallSite)((Object)(prefix + "." + name)));
            }
            for (STreePropertyAssoc sTreePropertyAssoc : this.propsOne()) {
                name = sTreePropertyAssoc.name();
                m.put(name, (CallSite)((Object)(prefix + "." + name)));
            }
            return m.isEmpty() ? Collections.emptyMap() : m;
        });
    }

    @Override
    public boolean isEmbeddedPath(String propertyPath) {
        ElPropertyDeploy elProp = this.elPropertyDeploy(propertyPath);
        if (elProp == null) {
            throw new PersistenceException("Invalid path " + propertyPath + " from " + this.fullName());
        }
        return elProp.beanProperty().isEmbedded();
    }

    @Override
    public ExtraJoin extraJoin(String propertyPath) {
        BeanPropertyAssoc assocProp;
        BeanProperty beanProperty;
        ElPropertyValue elGetValue = this.elGetValue(propertyPath);
        if (elGetValue != null && (beanProperty = elGetValue.beanProperty()) instanceof BeanPropertyAssoc && !(assocProp = (BeanPropertyAssoc)beanProperty).isEmbedded()) {
            return new ExtraJoin(assocProp, elGetValue.containsMany());
        }
        return null;
    }

    @Override
    public void inheritanceLoad(SqlBeanLoad sqlBeanLoad, STreeProperty property, DbReadContext ctx) {
        BeanProperty p = this.beanProperty(property.name());
        if (p != null) {
            p.load(sqlBeanLoad);
        } else {
            property.loadIgnore(ctx);
        }
    }

    void setUnmappedJson(EntityBean bean, Map<String, Object> unmappedProperties) {
        if (this.unmappedJson != null) {
            this.unmappedJson.setValueIntercept(bean, unmappedProperties);
        }
    }

    public void setTenantId(EntityBean entityBean, Object tenantId) {
        if (this.tenant != null) {
            this.tenant.setTenantValue(entityBean, tenantId);
        }
    }

    @Override
    public boolean isToManyDirty(EntityBean bean) {
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        for (BeanPropertyAssocMany<?> many : this.propertiesManySave) {
            Object value;
            if (!ebi.isLoadedProperty(many.propertyIndex()) || (!((value = many.getValue(bean)) instanceof BeanCollection) || !((BeanCollection)value).hasModifications()) && value == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHistorySupport() {
        return this.historySupport;
    }

    public IdType idType() {
        return this.idType;
    }

    public void setGeneratedId(EntityBean entityBean, Transaction transaction) {
        if (this.idGenerator == null || this.idProperty == null || this.idProperty.isEmbedded()) {
            return;
        }
        if (DmlUtil.isNullOrZero(this.idProperty.getValue(entityBean))) {
            this.convertSetId(this.nextId(transaction), entityBean);
        }
    }

    public boolean isIdGeneratedValue() {
        return this.idGeneratedValue;
    }

    public IdentityMode identityMode() {
        return this.identityMode;
    }

    public String selectLastInsertedId() {
        return this.selectLastInsertedId;
    }

    public boolean supportsSelectLastInsertedId() {
        return this.selectLastInsertedId != null;
    }

    public Collection<? extends Property> allProperties() {
        return this.propertiesAll();
    }

    public Collection<BeanProperty> propertiesAll() {
        return this.propMap.values();
    }

    public BeanProperty propertyUnmappedJson() {
        return this.unmappedJson;
    }

    public BeanProperty[] propertiesNonTransient() {
        return this.propertiesNonTransient;
    }

    public BeanProperty[] propertiesTransient() {
        return this.propertiesTransient;
    }

    public BeanPropertyAssocOne<?>[] propertiesEmbedded() {
        return this.propertiesEmbedded;
    }

    public boolean includesAggregation(OrmQueryDetail detail) {
        return detail != null && this.propertiesAggregate.length > 0 && this.includesAggregation(detail.getChunk(null, false));
    }

    private boolean includesAggregation(OrmQueryProperties rootProps) {
        Set<String> included;
        if (rootProps != null && (included = rootProps.getIncluded()) != null) {
            for (BeanProperty property : this.propertiesAggregate) {
                if (!included.contains(property.name())) continue;
                return true;
            }
        }
        return false;
    }

    public void setAllLoaded(EntityBean bean) {
        bean._ebean_getIntercept().setLoadedPropertyAll();
        for (BeanPropertyAssocOne<?> embedded : this.propertiesEmbedded) {
            embedded.setAllLoadedEmbedded(bean);
        }
    }

    public TableJoin primaryKeyJoin() {
        return this.primaryKeyJoin;
    }

    public BeanProperty idProperty() {
        return this.idProperty;
    }

    public boolean isInsertMode(EntityBeanIntercept ebi, boolean insertMode) {
        if (ebi.isLoaded()) {
            return false;
        }
        if (this.idProperty.isEmbedded()) {
            return !ebi.isLoaded();
        }
        if (!this.hasIdValue(ebi.owner())) {
            return true;
        }
        return insertMode;
    }

    public boolean isReference(EntityBeanIntercept ebi) {
        return ebi.isReference() || this.referenceIdPropertyOnly(ebi);
    }

    public boolean referenceIdPropertyOnly(EntityBeanIntercept ebi) {
        return this.idOnlyReference && ebi.hasIdOnly(this.idPropertyIndex);
    }

    public boolean isIdLoaded(EntityBeanIntercept ebi) {
        return this.idPropertyIndex == -1 || ebi.isLoadedProperty(this.idPropertyIndex);
    }

    boolean hasIdValue(EntityBean bean) {
        return this.idProperty != null && !DmlUtil.isNullOrZero(this.idProperty.getValue(bean));
    }

    boolean hasVersionProperty(EntityBeanIntercept ebi) {
        return this.versionPropertyIndex > -1 && ebi.isLoadedProperty(this.versionPropertyIndex);
    }

    void setReferenceIfIdOnly(EntityBeanIntercept ebi) {
        if (this.referenceIdPropertyOnly(ebi)) {
            ebi.setReference(this.idPropertyIndex);
        }
    }

    public long setVersion(EntityBean entityBean, Object versionValue) {
        this.versionProperty.setValueIntercept(entityBean, versionValue);
        return this.versionProperty.scalarType.asVersion(versionValue);
    }

    public long getVersion(EntityBean entityBean) {
        if (this.versionProperty == null) {
            return 0L;
        }
        Object value = this.versionProperty.getValue(entityBean);
        return value == null ? 0L : this.versionProperty.scalarType.asVersion(value);
    }

    public void checkAllMutableProperties(EntityBeanIntercept ebi) {
        for (BeanProperty beanProperty : this.propertiesMutable) {
            Object value;
            int propertyIndex = beanProperty.propertyIndex();
            if (!ebi.isLoadedProperty(propertyIndex) || !beanProperty.checkMutable(value = beanProperty.getValue(ebi.owner()), ebi.isDirtyProperty(propertyIndex), ebi)) continue;
            ebi.markPropertyAsChanged(propertyIndex);
        }
    }

    public void checkAnyMutableProperties(EntityBeanIntercept ebi) {
        for (BeanProperty beanProperty : this.propertiesMutable) {
            Object value;
            int propertyIndex = beanProperty.propertyIndex();
            if (!ebi.isLoadedProperty(propertyIndex) || !beanProperty.checkMutable(value = beanProperty.getValue(ebi.owner()), ebi.isDirtyProperty(propertyIndex), ebi)) continue;
            ebi.markPropertyAsChanged(propertyIndex);
            return;
        }
    }

    public ConcurrencyMode concurrencyMode(EntityBeanIntercept ebi) {
        if (!this.hasVersionProperty(ebi)) {
            return ConcurrencyMode.NONE;
        }
        return this.concurrencyMode;
    }

    public Map<String, ValuePair> diff(EntityBean newBean, EntityBean oldBean) {
        LinkedHashMap<String, ValuePair> map = new LinkedHashMap<String, ValuePair>();
        this.diff(null, map, newBean, oldBean);
        return map;
    }

    public void diff(String prefix, Map<String, ValuePair> map, EntityBean newBean, EntityBean oldBean) {
        for (BeanProperty beanProperty : this.propertiesBaseScalar) {
            beanProperty.diff(prefix, map, newBean, oldBean);
        }
        for (BeanProperty beanProperty : this.propertiesOne) {
            ((BeanPropertyAssocOne)beanProperty).diff(prefix, map, newBean, oldBean);
        }
        for (BeanProperty beanProperty : this.propertiesEmbedded) {
            ((BeanPropertyAssocOne)beanProperty).diff(prefix, map, newBean, oldBean);
        }
    }

    public void appendOrderById(SpiQuery<T> query) {
        if (this.idProperty != null && !this.idProperty.isEmbedded() && !query.order().containsProperty(this.idProperty.name())) {
            query.order().asc(this.idProperty.name());
        }
    }

    @Override
    public STreeProperty[] propsBaseScalar() {
        return this.propertiesBaseScalar;
    }

    @Override
    public STreePropertyAssoc[] propsEmbedded() {
        return this.propertiesEmbedded;
    }

    @Override
    public STreePropertyAssocOne[] propsOne() {
        return this.propertiesOne;
    }

    @Override
    public STreePropertyAssocMany[] propsMany() {
        return this.propertiesMany;
    }

    public BeanPropertyAssocOne<?>[] propertiesOne() {
        return this.propertiesOne;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneImported() {
        return this.propertiesOneImported;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneImportedSave() {
        return this.propertiesOneImportedSave;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneImportedDelete() {
        return this.propertiesOneImportedDelete;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneExportedSave() {
        return this.propertiesOneExportedSave;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneExportedDelete() {
        return this.propertiesOneExportedDelete;
    }

    public BeanProperty[] propertiesNonMany() {
        return this.propertiesNonMany;
    }

    public BeanPropertyAssocMany<?>[] propertiesMany() {
        return this.propertiesMany;
    }

    public BeanPropertyAssocMany<?>[] propertiesManySave() {
        return this.propertiesManySave;
    }

    public BeanPropertyAssocMany<?>[] propertiesManyDelete() {
        return this.propertiesManyDelete;
    }

    public BeanPropertyAssocMany<?>[] propertiesManyToMany() {
        return this.propertiesManyToMany;
    }

    public BeanProperty versionProperty() {
        return this.versionProperty;
    }

    public boolean isMultiTenant() {
        return this.tenant != null;
    }

    public BeanProperty tenantProperty() {
        return this.tenant;
    }

    public BeanProperty[] propertiesBaseScalar() {
        return this.propertiesBaseScalar;
    }

    public BeanProperty[] propertiesGenInsert() {
        return this.propertiesGenInsert;
    }

    public BeanProperty[] propertiesGenUpdate() {
        return this.propertiesGenUpdate;
    }

    public void jsonWriteDirty(SpiJsonWriter writeJson, EntityBean bean, boolean[] dirtyProps) throws IOException {
        this.jsonHelp.jsonWriteDirty(writeJson, bean, dirtyProps);
    }

    void jsonWriteDirtyProperties(SpiJsonWriter writeJson, EntityBean bean, boolean[] dirtyProps) throws IOException {
        this.jsonHelp.jsonWriteDirtyProperties(writeJson, bean, dirtyProps);
    }

    public void jsonWriteMapEntry(SpiJsonWriter ctx, Map.Entry<?, ?> entry) throws IOException {
        throw new IllegalStateException("Unexpected - expect Element override");
    }

    public void jsonWriteElement(SpiJsonWriter ctx, Object element) {
        throw new IllegalStateException("Unexpected - expect Element override");
    }

    public Object jsonReadCollection(SpiJsonReader readJson, EntityBean parentBean) throws IOException {
        throw new IllegalStateException("Unexpected - expect Element override");
    }

    public boolean isJsonReadCollection() {
        return false;
    }

    public void jsonWrite(SpiJsonWriter writeJson, EntityBean bean) throws IOException {
        this.jsonHelp.jsonWrite(writeJson, bean, null);
    }

    public void jsonWrite(SpiJsonWriter writeJson, EntityBean bean, String key) throws IOException {
        this.jsonHelp.jsonWrite(writeJson, bean, key);
    }

    void jsonWriteProperties(SpiJsonWriter writeJson, EntityBean bean) {
        this.jsonHelp.jsonWriteProperties(writeJson, bean);
    }

    public T jsonRead(SpiJsonReader jsonRead, String path, T target) throws IOException {
        return this.jsonHelp.jsonRead(jsonRead, path, true, target);
    }

    T jsonReadObject(SpiJsonReader jsonRead, String path, T target) throws IOException {
        return this.jsonHelp.jsonRead(jsonRead, path, false, target);
    }

    public List<BeanProperty[]> uniqueProps() {
        return this.propertiesUnique;
    }

    public static enum EntityType {
        ORM,
        EMBEDDED,
        VIEW,
        SQL,
        DOC;

    }
}

