/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.expression.AbstractExpression;

final class ArrayContainsExpression
extends AbstractExpression {
    private final boolean contains;
    private final Object[] values;

    ArrayContainsExpression(String propName, boolean contains, Object ... values) {
        super(propName);
        this.contains = contains;
        this.values = values;
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values must not be null or empty");
        }
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("ArrayContains[").append(this.propName).append(" b:").append(this.contains).append(" ?:").append(this.values.length).append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.values.length);
        for (Object value : this.values) {
            key.add(value);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        ArrayContainsExpression that = (ArrayContainsExpression)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(that.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.platformHandler().arrayContains(request, this.propName, this.contains, this.values);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        for (Object value : this.values) {
            request.addBindValue(value);
        }
    }
}

